/*
 * newam.h --
 *	POSTGRES definitions which interface with new access methods.
 *
 * Identification:
 *	$Header: RCS/newam.h,v 1.10 91/11/14 15:02:57 jolly Exp $
 */

#ifndef	NewAMIncluded
#define NewAMIncluded	1

#include "tmp/postgres.h"

#include "access/istrat.h"
#include "access/itup.h"
#include "access/relscan.h"
#include "access/sdir.h"
#include "access/skey.h"
#include "utils/rel.h"
#include "rules/rlock.h"
#include "access/funcindex.h"

/*
 * NewCreate --
 *	Interface for new access method create file routine.
 */
extern
void
NewCreate ARGS((
	Relation	relation,
	char		relationName[16],
	char		databaseName[16],
	char		databasePath[]
));

/*
 * NewBuild --
 *	Interface for new access method build index routine.
 */
extern
void
NewBuild ARGS((
	Relation	heapRelation,
	Relation	indexRelation,
	AttributeNumber	numberOfAttributes,
	AttributeNumber	attributeNumber[],
	uint16		parameterCount,
	Datum		parameter[]
));

/*
 * DefaultBuild --
 *	Default build index routine.
 */
extern
void
DefaultBuild ARGS((
	Relation	heapRelation,
	Relation	indexRelation,
	AttributeNumber	numberOfAttributes,
	AttributeNumber	attributeNumber[],
	IndexStrategy	indexStrategy,
	uint16		parameterCount,
	Datum		parameter[],
	FuncIndexInfoPtr    funcInfo
));

/*
 * FormIndexDatum --
 *	extracts attribute information from a heap tuple,
 *	from which an index tuple is created.
 */
extern
void
FormIndexDatum ARGS((
    AttributeNumber	numberOfAttributes,
    AttributeNumber	attributeNumber[],
    HeapTuple		heapTuple,
    TupleDescriptor	heapDescriptor,
    Buffer		buffer,
    Datum		*datum,
    char		*null,
    FuncIndexInfoPtr    fInfo
));

/*
 * NewDestroy --
 *	Interface for new access method remove file routine.
 */
extern
void
NewDestroy ARGS((
	Relation	relation,
	char		relationName[16],
	char		databaseName[16],
	char		databasePath[]
));

/*
 * NewOpen --
 *	Interface for new access method open file routine.
 */
extern
int		/* for now */
NewOpen ARGS((
	Relation	relation,
	char		relationName[16],
	char		databaseName[16],
	char		databasePath[]
));

/*
 * NewClose --
 *	Interface for new access method close file routine.
 */
extern
void
NewClose ARGS((
	Relation	relation,
	int		f		/* for now */
));

/*
 * NewInsert --
 *	Interface for new access method index tuple insertion routine.
 */
extern
InsertIndexResult
NewInsert ARGS((
	Relation	relation,
	IndexTuple	indexTuple,
	bool		computeOffset,
	char		*scan		/* XXX fix this */
));

/*
 * NewDelete --
 *	Interface for new access method index tuple deletion routine.
 */
extern
void
NewDelete ARGS((
	Relation	relation,
	ItemPointer	tid
));

/*
 * NewSetLock --
 *	Interface for new access method lock setting routine.
 */
extern
void
NewSetLock ARGS((
	Relation	relation,
	ItemPointer	indexItemPointer,
	RuleLock	lock
));

/*
 * NewSetTid --
 *	Interface for new access method base "tid" setting routine.
 */
extern
void
NewSetTid ARGS((
	Relation	relation,
	ItemPointer	indexItemPointer,
	ItemPointer	heapItemPointer
));

/*
 * NewBeginScan --
 *	Interface for new access method initialize index scan routine.
 */
extern
IndexScanDesc
NewBeginScan ARGS((
	Relation	relation,
	bool		startScanAtEnd,
	uint16		numberOfKeys,
	ScanKey		key
));

/*
 * NewRescan --
 *	Interface for new access method restart index scan routine.
 */
extern
void
NewRescan ARGS((
	IndexScanDesc	scan,
	ScanKey		key
));

/*
 * NewEndScan --
 *	Interface for new access method end index scan routine.
 */
extern
void
NewEndScan ARGS((
	IndexScanDesc	scan
));

/*
 * NewMarkPos --
 *	Interface for new access method mark index scan position routine.
 */
extern
void
NewMarkPos ARGS((
	IndexScanDesc	scan
));

/*
 * NewRestrPos --
 *	Interface for new access method restore index scan position routine.
 */
extern
void
NewRestrPos ARGS((
	IndexScanDesc	scan
));

/*
 * NewGetTuple --
 *	Interface for new access method get index tuple routine.
 */
extern
RetrieveIndexResult
NewGetTuple ARGS((
	Relation	relation,
	ItemPointer	indexItem,
	int		direction,	/* -1 backwd, 1 fwd, 0 no move XXX */
	uint16		numberOfKeys,
	ScanKey		key
));

/*
 * NewFreeTuple --
 *	Interface for new access method free tuple routine.
 */
extern
NewFreeTuple ARGS((
	Relation	relation
	/* this needs more thought */
));

#endif	/* !defined(NewAMIncluded) */
