#!/bin/sh
# $Header: /usr/local/devel/postgres/src/regress/demo/RCS/wholedemo.sh,v 1.6 1993/01/09 01:34:03 aoki Exp $
# This is a simple script used to run the entire demo without having to
# type all of those tedious include commands to the terminal monitor.
# This script assumes that the postmaster is currently running.
# 
# NOTE:
# It also assumes that you don't have a data base demo in which you keep
# important data (it destroys demo if it exists then re-creates it to run
# the postgres demo queries).
if [ -d ./obj ]; then
	cd ./obj
fi

echo =============== destroying old demo database... =================
destroydb demo

echo =============== creating new demo database... =================
createdb demo
if [ $? -ne 0 ]; then
	echo createdb failed
	exit 1
fi

echo =============== running demo queries... =================
monitor demo < demo.pq
if [ $? -ne 0 ]; then
	echo demo failed
	exit 1
fi

echo =============== destroying demo database... =================
destroydb demo
if [ $? -ne 0 ]; then
	echo destroydb failed
	exit 1
fi

exit 0
