/*
 * part.h --
 *	POSTGRES "partition" definitions.
 */

#ifndef	PartIncluded		/* Include this file only once */
#define PartIncluded	1

/*
 * Identification:
 */
#define PART_H	"$Header: /usr/local/devel/postgres/src/backend/storage/RCS/part.h,v 1.9 1991/09/30 10:12:49 glass Exp $"

#include "tmp/c.h"
#include "storage/page.h"

typedef uint32	PagePartition;	/* subpage partition indicator */

#define SinglePagePartition	0	/* partition when 1 page per block */

#define InvalidPagePartition	((PagePartition) 0)

/*
 * PagePartitionIsValid --
 *	True iff the page partition is valid.
 */
#define PagePartitionIsValid(partition) \
    ((bool) ((partition) != InvalidPagePartition))

/*
 * CreatePagePartition --
 *	Returns a new page partition.
 */
extern
PagePartition
CreatePagePartition();/* BAD PROTOTYPE DELETED -- glass */
/*ARGS((
	BlockSize	blockSize,
	PageSize	pageSize
)); */

/*
 * PagePartitionGetPagesPerBlock --
 *	Returns the count pages for the disk block associated with
 *	this page partition.
 */
extern
Count
PagePartitionGetPagesPerBlock ARGS((
	PagePartition	partition
));

#endif	/* !defined(PartIncluded) */
