/* ----------------------------------------------------------------
 *   FILE
 *	pg_magic.h
 *
 *   DESCRIPTION
 *	definition of the system "magic" relation (pg_magic)
 *	along with the relation's initial contents.
 *
 *   NOTES
 *	the genbki.sh script reads this file and generates .bki
 *	information from the DATA() statements.
 *
 *   IDENTIFICATION
 *	$Header: /usr/local/devel/postgres/src/backend/catalog/RCS/pg_magic.h,v 1.3 1990/08/17 08:52:00 cimarron Exp $
 * ----------------------------------------------------------------
 */
#ifndef PgMagicIncluded
#define PgMagicIncluded 1	/* include this only once */

/* ----------------
 *	postgres.h contains the system type definintions and the
 *	CATALOG(), BOOTSTRAP and DATA() sugar words so this file
 *	can be read by both genbki.sh and the C compiler.
 * ----------------
 */
#include "tmp/postgres.h"

/* ----------------
 *	pg_magic definition.  cpp turns this into
 *	typedef struct FormData_pg_magic
 * ----------------
 */ 
CATALOG(pg_magic) BOOTSTRAP {
    char16 	magname;
    char16 	magvalue;
} FormData_pg_magic;

/* ----------------
 *	Form_pg_magic corresponds to a pointer to a tuple with
 *	the format of pg_magic relation.
 * ----------------
 */
typedef FormData_pg_magic	*Form_pg_magic;

/* ----------------
 *	compiler constants for pg_magic
 * ----------------
 */
#define Name_pg_magic			"pg_magic"
#define Natts_pg_magic			2
#define Anum_pg_magic_magname		1
#define Anum_pg_magic_magvalue		2

/* ----------------
 *	old definition of struct magic
 * ----------------
 */
#ifndef struct_magic_Defined
#define struct_magic_Defined 1

struct	magic {
	char	magname[16];
	char	magvalue[16];
};
#endif struct_magic_Defined


#endif PgMagicIncluded
