.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/fetch.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/fetch.cmdsrc,v 1.7 1993/01/26 02:43:13 aoki Exp $
.TH FETCH COMMANDS 01/23/93
.XA 2 Fetch
.SH NAME
fetch \(em fetch instance(s) from a portal 
.SH SYNOPSIS
.(l M
\fBfetch\fR [ (\fBforward\fR | \fBbackward\fR) ] [ ( number | \fBall\fR) ] [\fBin\fR portal_name]
.)l
.SH DESCRIPTION
.BR Fetch
allows a user to retrieve instances from a portal named
.IR portal_name .
The number of instances retrieved is specified by
.IR number .
If the number of instances remaining in the portal is less than
.IR number ,
then only those available are fetched.  Substituting the keyword
.BR all
in place of a number will cause all remaining instances in the portal
to be retrieved.  Instances may be fetched in both
.IR forward
and
.IR backward
directions.  The default direction is
.IR forward .
.PP
Updating data in a portal is not supported by \*(PG, because mapping
portal updates back to base classes is impossible in general as with
view updates.  Consequently, users must issue explicit replace
commands to update data.
.PP
Portals may only be used inside of
.BR begin / end
transaction blocks, since the data that they store spans multiple user
queries.
.SH EXAMPLE
.(C
/*
 * set up and use a portal
 */
begin \eg
   retrieve portal myportal (pg_user.all) \eg
   fetch 2 in myportal \eg
   fetch all in myportal \eg
   close myportal \eg
end \eg
.)C
.(C
/*
 * Fetch all the instances available in the portal FOO
 */
fetch all in FOO
.)C
.(C
/*
 * Fetch 5 instances backward in the portal FOO
 */
fetch backward 5 in FOO
.)C
.SH "SEE ALSO"
close(commands),
move(commands),
retrieve(commands).
.SH BUGS
Currently, the smallest transaction in \*(PG is a single \*(PQ
command.  It should be possible for a single fetch to be a
transaction.
