.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_type.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/define_type.cmdsrc,v 1.13 1993/01/26 02:43:13 aoki Exp $
.TH "DEFINE TYPE " COMMANDS 01/23/93
.XA 2 "Define Type"
.SH NAME
define type \(em define a new base data type 
.SH SYNOPSIS
.(l M
\fBdefine type\fP typename \fB(\fR\fBexternallength\fR = (\fBnumber\fR | \fBvariable\fR),
	[ \fBexternallength\fR = (\fBnumber\fR | \fBvariable\fR)\fB,\fR ]
	\fBinput\fR = input_function,
	\fBoutput\fR = output_function
	[\fB,\fR \fBelement\fR = typename]
	[\fB,\fR \fBdelimiter\fR = <character>]
	[\fB,\fR \fBdefault\fR = "string" ]
	[\fB,\fR \fBsend\fR = procedure ]
	[\fB,\fR \fBreceive\fR = procedure ]
	[\fB,\fR \fBpassedbyvalue\fR]\fB)\fR
.)l
.\" \fBdefine type\fP typename as postquel_commands
.SH DESCRIPTION
.BR "Define type"
allows the user to register a new user data type with \*(PG for use in
the current data base.  The user who defines a type becomes its owner.
.IR Typename
is the name of the new type and must be unique within the types
defined for this database.
.PP
.IR "Define type"
requires the registration of two functions (using
.IR "define function" )
before defining the type.  The representation of a new base type is
determined by the function
.IR input ,
which converts the type's external representation to an internal
representation usable by the operators and functions defined for the
type.  Naturally,
.IR "output"
performs the reverse transformation.
.PP
New base data types can be fixed length, in which case
.IR "internal length"
is a positive integer, or variable length, in which case \*(PG assumes
that the new type has the same format as the \*(PG-supplied data type,
.BR "text".
To indicate that a type is variable-length, set
.IR "internal length"
to
.BR "-1" .
The external representation is similarly specified using
.IR "external length."
.PP
To indicate that a type is an array and to indicate that a type has
array elements, indicate the type of the array element using the
.IR "element"
attribute.  For example, to define an array of 4 byte integers (int4),
set the
.IR "element"
attribute equal to
.BR "int4".
.PP
To indicate the delimiter to be used on arrays of this type, the 
.IR "delimiter"
attribute can be set to a specific character.  The default delimiter
is the comma (\*(lq,\*(rq) character.
.PP
A
.IR "default"
value is optionally available in case a user wants some specific bit
pattern to mean \*(lqdata not present.\*(rq
.PP
The optional functions
.IR "send"
and
.IR "receive"
are used when the application program requesting \*(PG services
resides on a different machine.  In this case, the machine on which
\*(PG runs may use a different format for the data type than used on
the remote machine.  In this case it is appropriate to convert data
items to a standard form on output
.IR "send"
and convert from the standard format to the machine specific format on
input
.IR "receive" .
If these functions are not specified, then it is assumed that the
internal format of the type is acceptable on all relevant machine
architectures (for example, single characters do not have to be
converted if passed from a Sun-3 to a DECstation).
.PP
The optional
.IR "passedbyvalue"
flag indicates that operators and functions which use this data type
should be passed an argument by value rather than by reference.  Note
that only types whose internal representation is at most four bytes
may be passed by value.
.PP
For new base types, a user can define operators, functions and
aggregates using the appropriate facilities described in this section.
.SH "ARRAY TYPES"
Two generalized built-in functions,
.BR array_in
and
.BR array_out,
exist for quick creation of variable length array types.  These
functions operate on any existing \*(PG type.
.SH "LARGE OBJECT TYPES"
A \*(lqregular\*(rq \*(PG type can only be 8192 bytes in length.  If
you need a larger type you must create a Large Object type.  The
interface for these types is discussed at length in Section 7, the
Large Object Backend Interface.  The length of all large object types
is always
.BR variable,
meaning the internallength for large objects is always -1.
.SH EXAMPLES
.(C
/*
 * This command creates the box data type and then uses the
 * type in a class definition
 */
define type box (internallength = 8,
 	input = my_procedure_1, output = my_procedure_2)

create MYBOXES (id = int4, description = box)
.)C
.(C
/*
 * This command creates a variable length array type with
 * integer elements.
 */
define type int4array
   (input = array_in, output = array_out,
    internallength = variable, element = int4)

   create MYARRAYS (id = int4, numbers = int4array)
.)C
.(C
/*
 * This command creates a large object type and uses it in
 * a class definition.
 */
define type bigobj
   (input = lo_filein, output = lo_fileout,
    internallength = variable)

   create BIG_OBJS (id = int4, obj = bigobj)
.)C
.SH "SEE ALSO"
define function(commands),
define operator(commands),
remove type(commands),
Large Object Backend Interface.
