.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/define_operator.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/define_operator.cmdsrc,v 1.11 1993/01/26 02:43:13 aoki Exp $
.TH "DEFINE OPERATOR" COMMANDS 01/23/93
.XA 2 "Define Operator"
.SH NAME
define operator \(em define a new user operator
.SH SYNOPSIS
.(l M
\fBdefine operator\fR operator_name
	\fB(\fR \fBarg1\fR \fB=\fR type-1
	 [ \fB,\fR \fBarg2\fR \fB=\fR type-2 ]
	 , \fBprocedure =\fR func_name
	 [\fB, precedence =\fR number ]
	 [\fB, associativity =\fR \fB(left | right | none | any)\fR ]
	 [\fB, commutator =\fR com_op ]
	 [\fB, negator =\fR neg_op ]
	 [\fB, restrict =\fR res_proc ]
	 [\fB, hashes\fR]
	 [\fB, join =\fR join_proc ]
	 [\fB, sort =\fR sor_op1 {\fB,\fR sor_op2 } ]
	\fB)\fR
.\" \fB"arg is ("
.\" type [
.\" \fB,
.\" type ]
.\" \fB)
.)l
.SH DESCRIPTION
This command defines a new user operator,
.IR "operator_name" .
The user who defines an operator becomes its owner.
.PP
The name of the operator,
.IR operator_name ,
can be composed of symbols only.  Also, the
.IR func_name
procedure must have been previously defined using
.BR "define function"
and must have one or two arguments.  The types of the arguments for
the operator and the type of the answer are as defined by the
function.
.BR Precedence
refers to the order that multiple instances of the same operator are
evaluated.
.\" what does this number mean and what is its range?
The next several fields are primarily for the use of the query
optimizer.
.PP
The
.BR associativity
value is used to indicate how an expression containing this operator
should be evaluated when precedence and explicit grouping are
insufficient to produce a complete order of evaluation.
.BR Left
and
.BR right
indicate that expressions containing the operator are to be evaluated
from left to right or from right to left, respectively.
.BR None
means that it is an error for this operator to be used without
explicit grouping when there is ambiguity.  And
.BR any ,
the default, indicates that the optimizer may choose to evaluate an
expression which contains this operator arbitrarily.
.PP
.\" that multiple instances of the 
.\" operator must be be evaluated
.\" For example, consider the area-intersection operator,
.\" .q A,
.\" and the following expression:
.\" .(l
.\" MYBOXES2.description A \*(lq0,0,1,1\*(rq A MYBOXES.description
.\" .)l
.\" .in .5i
.\" The associativity flag indicates that
.\" .(l
.\" (MYBOXES2.description A \*(lq0,0,1,1\*(rq) A MYBOXES.description
.\" .)l
.\" .in .5i
.\" is the same as
.\" .(l
.\" MYBOXES2.description A (\*(lq0,0,1,1\*(rq A MYBOXES.description).
.\" .)l
The commutator operator is present so that \*(PG can reverse the order
of the operands if it wishes.  For example, the operator
area-less-than, >>>, would have a commutator operator,
area-greater-than, <<<.  Suppose that an operator, area-equal, ===,
exists, as well as an area not equal, !==.  Hence, the query optimizer
could freely convert:
.(C
"0,0,1,1"::box >>> MYBOXES.description
.)C
to
.(C
MYBOXES.description <<< "0,0,1,1"::box
.)C
This allows the execution code to always use the latter representation
and simplifies the query optimizer somewhat.
.PP
The negator operator allows the query optimizer to convert
.(C
not MYBOXES.description === "0,0,1,1"::box
.)C
to
.(C
MYBOXES.description !== "0,0,1,1"::box
.)C
If a commutator operator name is supplied, \*(PG searches for it in
the catalog.  If it is found and it does not yet have a commutator
itself, then the commutator's entry is updated to have the current
(new) operator as its commutator.  This applies to the negator, as
well.
.PP
This is to allow the definition of two operators that are the
commutators or the negators of each other.  The first operator should
be defined without a commutator or negator (as appropriate).  When the
second operator is defined, name the first as the commutator or
negator.  The first will be updated as a side effect.
.PP
The next two specifications are present to support the query optimizer
in performing joins.  \*(PG can always evaluate a join (i.e.,
processing a clause with two tuple variables separated by an operator
that returns a boolean) by iterative substitution [WONG76].  In
addition, \*(PG is planning on implementing a hash-join algorithm
along the lines of [SHAP86]; however, it must know whether this
strategy is applicable.  For example, a hash-join algorithm is usable
for a clause of the form:
.(C
MYBOXES.description === MYBOXES2.description
.)C
but not for a clause of the form:
.(C
MYBOXES.description <<< MYBOXES2.description.
.)C
The
.BR hashes
flag gives the needed information to the query optimizer concerning
whether a hash join strategy is usable for the operator in question.
.PP
Similarly, the two sort operators indicate to the query optimizer
whether merge-sort is a usable join strategy and what operators should
be used to sort the two operand classes.  For the === clause above,
the optimizer must sort both relations using the operator, <<<.  On
the other hand, merge-sort is not usable with the clause:
.(C
MYBOXES.description <<< MYBOXES2.description
.)C
If other join strategies are found to be practical, \*(PG will change
the optimizer and run-time system to use them and will require
additional specification when an operator is defined.  Fortunately,
the research community invents new join strategies infrequently, and
the added generality of user-defined join strategies was not felt to
be worth the complexity involved.
.PP
The last two pieces of the specification are present so the query
optimizer can estimate result sizes.  If a clause of the form:
.(C
MYBOXES.description <<< "0,0,1,1"::box
.)C
is present in the qualification, then \*(PG may have to estimate the
fraction of the instances in MYBOXES that satisfy the clause.  The
function res_proc must be a registered function (meaning it is already
defined using
.BR "define function" )
which accepts one argument of the correct data type and returns a
floating point number.  The query optimizer simply calls this
function, passing the parameter
.(C
"0,0,1,1"
.)C
and multiplies the result by the relation size to get the desired
expected number of instances.
.PP
Similarly, when the operands of the operator both contain instance
variables, the query optimizer must estimate the size of the resulting
join.  The function join_proc will return another floating point
number which will be multiplied by the cardinalities of the two
classes involved to compute the desired expected result size.
.PP
The difference between the function
.(C
my_procedure_1 (MYBOXES.description, "0,0,1,1"::box)
.)C
and the operator
.(C
MYBOXES.description === "0,0,1,1"::box
.)C
is that \*(PG attempts to optimize operators and can decide to use an
index to restrict the search space when operators are involved.
However, there is no attempt to optimize functions, and they are
performed by brute force.  Moreover, functions can have any number of
arguments while operators are restricted to one or two.
.SH EXAMPLE
.(C
/*
 * The following command defines a new operator,
 * area-equality, for the BOX data type.
 */
define operator === (
	arg1 = box,
	arg2 = box,
	procedure = area_equal_procedure,
	precedence = 30,
	associativity = left,
	commutator = ===,
	negator = !==,
	restrict = area_restriction_procedure,
	hashes,
	join = area-join-procedure,
	sort = <<<, <<<)
.\"	arg is (box, box)
.)C
.SH "SEE ALSO"
define function(commands),
remove operator(commands).
.SH BUGS
Operator names cannot be composed of alphabetic characters in Version
\*(PV.
.PP
Operator precedence and associativity are not implemented in Version
\*(PV.
