.lf 1 tmac.an.nr
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/RCS/tmac.an.nr,v 1.1 1993/01/26 02:43:13 aoki Exp $
.ds II INGRES
.ds PG POSTGRES
.ds UU UNIX
.ds PQ POSTQUEL
.ds LI LIBPQ
.ds PV 4.1
.de (l 			\" fake "-me"-style lists
.nf
.ie '\\$1'M' .in +0n
.el .in +5n
..
.de )l
.fi
.in
..
.de (C			\" constant-width font blocks
.(l \\$1
.sp
..
.de )C
.sp
.)l
..
.de BH			\" reference manual "big header" for sections
.SH NAME
\&\\$1
..
.de SB			\" section/index stuff
..	\" no-op
.de SE
..	\" no-op
.de XA
..	\" no-op
.de XP
..	\" no-op
.de SP
..
.ds lq ""
.ds rq ""
.lf 1 postquel/append.cmdsrc
.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /home2/aoki/master/ref/postquel/RCS/append.cmdsrc,v 1.7 1993/01/26 02:43:13 aoki Exp $
.TH APPEND COMMANDS 01/23/93
.XA 2 Append
.SH NAME
append \(em append tuples to a relation
.SH SYNOPSIS
.(l M
\fBappend\fR classname
	\fB(\fR att_name1 \fB=\fR expression1 {\fB,\fR att_name-i \fB=\fR expression-i} \fB)\fR
    [ \fBfrom\fR from_list ] [ \fBwhere\fR qual ]
.)l
.SH DESCRIPTION
.BR Append 
adds instances which satisfy the qualification,
.IR qual ,
to 
.IR classname .
.IR Classname 
must be the name of an existing class.  The target list specifies the
values of the fields to be appended to
.IR classname .
The fields may be listed in any order.  Fields of the result class
which do not appear in the target list are default a null value.  If
the expression for each field is not of the correct data type,
automatic type coercion will be attempted.
.PP
The keyword
.BR all
can be used when it is desired
to append all domains of a class to another class.
.PP
You must have write or append access to a class in order to append to
it, as well as read access on any class whose values are read in the
target list or qualification (see
.IR "change acl" (commands)).
.SH EXAMPLE
.(C
/*
 * Make a new employee Jones work for Smith
 */
append emp (newemp.name, newemp.salary, mgr = "Smith",
            bdate = 1990 - newemp.age)
    where newemp.name = "Jones"
.)C
.(C
/*
 * same command using the from list clause
 */
append emp (n.name, n.salary, mgr = "Smith",
            bdate = 1990 - n.age)
    from n in newemp
    where n.name = "Jones"
.)C
.(C
/*
 * Append the newemp1 class to newemp
 */
append newemp (newemp1.all)
.)C
.SH "SEE ALSO"
postquel(commands),
define type(commands),
retrieve(commands).

