/* 
 *  Postgres/CommonLISP Interface
 * 
 *  Copyright (c) 1986 Regents of the University of California
 *  
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and
 *  that both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of the University of
 *  California not be used in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior
 *  permission.  The University of California makes no representations
 *  about the suitability of this software for any purpose.  It is
 *  provided "as is" without express or implied warranty.
 *  
 *  $Author: picasso $
 *  $Source: RCS/libpq.c,v $
 *  $Revision: 1.1 $
 *  $Date: 90/07/23 13:18:06 $
 *
 */

#ifndef lint
static char rcs_id[] = "$Header: RCS/libpq.c,v 1.1 90/07/23 13:18:06 picasso Exp $";
#endif not lint

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

getinaddr(sin, host, port)
struct	sockaddr_in *sin;
char	*host;
int	port;
{
	struct	hostent	*hs;

	bzero((char *)sin, sizeof *sin);
	if (host) {
		if (*host >= '0' && *host <= '9')
			sin->sin_addr.s_addr = inet_addr(host);
		else {
			if (!(hs = gethostbyname(host))) {
				perror(host);
				return(1);
			}
			if (hs->h_addrtype != AF_INET) {
				fputs(host, stderr);
				fputs(": Not Internet\n", stderr);
				return(1);
			}
			bcopy(hs->h_addr, (char *)&sin->sin_addr, hs->h_length);
		}
	}
	sin->sin_family = AF_INET;
	sin->sin_port = htons(port);
	return(0);
}

getinserv(sin, host, serv)
struct	sockaddr_in *sin;
char	*host, *serv;
{
	struct	servent	*ss;

	if (*serv >= '0' && *serv <= '9')
		return(getinaddr(sin, host, atoi(serv)));
	if (!(ss = getservbyname(serv, NULL))) {
		fputs(serv, stderr);
		fputs(": Unknown service\n", stderr);
		return(1);
	}
	return(getinaddr(sin, host, ntohs(ss->s_port)));
}

FILE	*Pfout, *Pfin;

pconnect(host, port)
char	*host, *port;
{
	struct	sockaddr_in	sin;
	int			fd, port_no;

	port_no = atoi(port);
	if (getinaddr(&sin, host, port_no))
	    return(-1);
	fd = socket(AF_INET, SOCK_STREAM, 0);
	if (connect(fd, &sin, sizeof sin))
		return(-1);
	Pfout = fdopen(fd, "w");
	Pfin = fdopen(dup(fd), "r");
	return(0);
}

paccept()
{
	struct	sockaddr_in	sin;
	int			fd, nfd, i;

	if (!(fd = socket(AF_INET, SOCK_STREAM, 0)))
		return(-2);
	getinaddr(&sin, 0, 4321);
	if (bind(fd, &sin, sizeof sin))
		return(-3);
	listen(fd, SOMAXCONN);
	if ((nfd = accept(fd, NULL, NULL)) < 0)
		return(-1);
	close(fd);
	Pfout = fdopen(nfd, "w");
	Pfin = fdopen(dup(nfd), "r");
	return(0);
}

pgclose()
{
	fclose(Pfin);
	fclose(Pfout);
}

pflush()
{
	fflush(Pfout);
}

getpstr(s, maxlen)
char	*s;
int	maxlen;
{
	int	c, slen;

	slen = 0;
	while (maxlen-- && (c = getc(Pfin)) != EOF && c) {
		*s++ = c;
		++slen;
	}
	*s = '\0';
	return (slen);
}

getpchar(s, off, maxlen)
char	*s;
int	off, maxlen;
{
	int	c;

	s += off;
	while (maxlen-- && (c = getc(Pfin)) != EOF)
		*s++ = c;
}

getpint(b)
int	b;
{
	int	n, c, p;

	n = p = 0;
	while (b-- && (c = getc(Pfin)) != EOF && p < 32) {
		n |= (c & 0xff) << p;
		p += 8;
	}
	return(n);
}

putstr(s)
char	*s;
{
	fputs(s, Pfout);
	putc('\0', Pfout);
}

putnchar(s, n)
char	*s;
int      n;
{
	while (n--)
		putc(*s++, Pfout);
}

putint(i, b)
int	i, b;
{
	if (b > 4)
		b = 4;
	while(b--) {
		putc(i & 0xff, Pfout);
		i >>= 8;
	}
}

/* PUT in by luis to handle floats and doubles */

void putsinglefloat (sf)
    float      sf;
{
    int i, times;
    int n = *(int*) &sf;

    times = sizeof (float);
    for (i = 1; i == times ; i++) {
	putc (n & 0xff, Pfout);
	n >>= 8;
    }
}

void putsinglefloat_two (n)
    int   n; 	
{
    int size = sizeof (int);

    while (size--) {
	putc (n & 0xff, Pfout);
	n >>= 8;
    }
}

void putsinglefloat_three (sf)
    float      sf;
{
    int n = *(int*) &sf;
    int size = sizeof(float);

    while (size--) {
	putc (n, Pfout);
	n >>= 8;
    }
}

void putsinglefloat_four (n)
    int   n; 	
{
    int size = sizeof (int);

    while (size--) {
	putc (n, Pfout);
	n >>= 8;
    }
}

void putdoublefloat_two (df, size)
    double     df;
    int        size;
{
    long n = (long ) df;

    if (size > sizeof (long))
 	      size = sizeof (long);
    while (size--) {
	putc (n & 0xff, Pfout);
	n >>= 8;
    }
}

void putdoublefloat (df)
    double      df;
{
    int i, times;
    long n = (long ) df;

    times = sizeof (double);
    for (i = 1; i == times ; i++) {
	putc (n & 0xff, Pfout);
	n >>= 8;
    }
}

float getsinglefloat ()
{
	int	n;
	int     b, c, p;

	n = p = 0;
	b = sizeof (float);
	while (b-- && (c = getc(Pfin)) != EOF && p < 32) {
		n |= (c & 0xff) << p;
		p += 8;
	}
	return (float ) n;
}

double getdoublefloat ()
{
	long	n;
	int     b, c, p;

	n = p = 0;
	b = sizeof (double);
	while (b-- && (c = getc(Pfin)) != EOF && p < 32) {
		n |= (c & 0xff) << p;
		p += 8;
	}
	return (double ) n;
}

getpfloat(s, off, maxlen)
char	*s;
int	off, maxlen;
{
	int	c;

	s += off;
	while (maxlen-- && (c = getc(Pfin)) != EOF)
		*s++ = c;
}

void putsinglefloatarray_four(s,n)
double	*s;
int      n;
{
	while (n--) {
		putc(*s, Pfout);
		*s = *s + 1;
	    }
}

void putsinglefloatarray_three(s,n)
char	*s;
int      n;
{
	while (n--)
		putc(*s++, Pfout);
}

void putsinglefloatarray_two(s,n)
float	*s;
int      n;
{
	while (n--) {
		putc(*s, Pfout);
		*s = *s + 1;
	    }
}

void putsinglefloatarray(s)
float	*s;
{
    int n = sizeof (float);

	while (n--) {
		putc(*s, Pfout);
		*s = *s + 1;
	    }
}

void putnfloat(f, n)
float	 f;
int      n;
{
    char *c = (char *) &f;

	while (n--) 
		putc(*c++, Pfout);

}

