/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* Defines to make different thread packages compatible */

#ifndef _my_pthread_h
#define _my_pthread_h

#ifdef HAVE_rts_threads
#define sigwait org_sigwait
#include <signal.h>
#undef sigwait
#endif
#include <pthread.h>
#ifdef HAVE_THRSETCONCURRENCY
#include <thread.h>				/* Probably solaris */
#endif

extern void my_thread_init(void);

#if defined(HAVE_rts_thread)
void *my_pthread_getspecific(pthread_key_t key);
int my_sigwait(sigset_t *set,int *sig);
extern int my_pthread_create_detached;
#define pthread_sigmask(A,B,C) sigprocmask((A),(B),(C))
#define my_pthread_setprio(A,B) pthread_setprio_np((A),(B))
#define my_pthread_attr_setprio(A,B) pthread_attr_setprio((A),(B))
#define PTHREAD_MUTEX_INITIALIZER {}	/* should work in most cases */
#define PTHREAD_COND_INITIALIZER {}
#define PTHREAD_CREATE_DETACHED &my_pthread_create_detached
#define PTHREAD_SCOPE_SYSTEM  PTHREAD_SCOPE_GLOBAL
#define PTHREAD_SCOPE_PROCESS PTHREAD_SCOPE_LOCAL
#define USE_ALARM_THREAD

#elif defined(HAVE_mit_thread)
#define USE_ALARM_THREAD
#define sigset(A,B) pthread_signal((A),(void (*)(int)) (B))
#define signal(A,B) pthread_signal((A),(void (*)(int)) (B))
#define my_pthread_attr_setprio(A,B)
#define my_pthread_getspecific(A) pthread_getspecific(A)
#define my_sigwait(A,B) sigwait((A),(B))

#else /* POSIX THREADS */
#define my_pthread_getspecific(A) pthread_getspecific(A)
#define my_sigwait(A,B) sigwait((A),(B))
extern void my_pthread_setprio(pthread_t thread_id,int prior);
extern void my_pthread_attr_setprio(pthread_attr_t *attr, int priority);
#endif

#endif /* _my_ptread_h */
