/* Test of searching a string for the last occurrence of a character.
   Copyright (C) 2007-2022 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* Written by Bruno Haible <bruno@clisp.org>, 2007.  */

#include <config.h>

#include <string.h>

#include <locale.h>

#include "macros.h"

int
main ()
{
  /* configure should already have checked that the locale is supported.  */
  if (setlocale (LC_ALL, "") == NULL)
    return 1;

  /* Tests with a character < 0x30.  */
  {
    const char input[] = "\312\276\300\375 \312\276\300\375 \312\276\300\375"; /* "示例 示例 示例" */
    const char *result = mbsrchr (input, ' ');
    ASSERT (result == input + 9);
  }

  {
    const char input[] = "\312\276\300\375"; /* "示例" */
    const char *result = mbsrchr (input, ' ');
    ASSERT (result == NULL);
  }

  /* Tests with a character >= 0x30.  */
  {
    const char input[] = "\272\305123\324\313\320\320\241\243"; /* "号123运行。" */
    const char *result = mbsrchr (input, '2');
    ASSERT (result == input + 3);
  }

  /* This test shows how mbschr() is different from strchr().  */
  {
    const char input[] = "\203\062\332\066123\324\313\203\062\332\066\320\320\241\243"; /* "씋123运씋行。" */
    const char *result = mbsrchr (input, '2');
    ASSERT (result == input + 5);
  }

  return 0;
}
