
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

main :- generate_no_garbage(_).

generate_no_garbage(Result) :- 
	object(X),
	link_copy(10000,X,Result,Link),
	dummy(X,Result,Link).


link_copy(0,_,Link,Link) :- !.
link_copy(N,X,[CopyX|R],Link) :-
	copy(X,CopyX),
	N1 is N - 1,
	link_copy(N1,X,R,Link).

object([[1,2,3],[4,5,6],[7,8,9]]).

copy(X,X) :- (atomic(X); var(X)), !.
copy([A|B],[CopyA|CopyB]) :- !,
	copy(A,CopyA),
	copy(B,CopyB).
copy(X,CopyX) :-
	functor(X,Name,Arity),
	functor(CopyX,Name,Arity),
	copy(Arity,X,CopyX).

copy(0,_,_) :- !.
copy(N,X,CopyX) :-
	arg(N,X,Arg),
	copy(Arg,CopyArg),
	arg(N,CopyX,CopyArg),
	N1 is N - 1,
	copy(N1,X,CopyX).

dummy(_,_,_).