
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% IO Package

% Arity of the compiled code never goes above 7, but the actual arity
% of the predicate is output here in order to distinguish predicates
% with arities>7.

write_plm(NameArity, List) :-
	compile_options(l), !,
	write_plm_list(NameArity, List), nl, nl, !.
write_plm(NameArity, List) :-
	\+(compile_options(l)), !,
	write_plm_nice(NameArity, List), nl, nl, !.

% Write the procedure code in human-readable form:
write_plm_nice(NameArity, List) :-
	write('procedure  '), 
	NameArity = Name/Arity,
	write(Name), write(/), write(Arity), nl, nl,
	set(arity,Arity),
	write_plm_nice(List).

write_plm_nice([I|List]) :-
	winstr(I),
	write_plm_nice(List), !.
write_plm_nice([]).

% Write the procedure code in list-form, able to be read by read/1:
write_plm_list(NameArity, List) :-
	write('[procedure('), writeq(NameArity), write('),'), nl,
	write_plm_list(List),
	write('].').
	
write_plm_list([I]) :-
	writeq(I).
write_plm_list([I|List]) :-
	writeq(I), comma, nl,
	write_plm_list(List).
write_plm_list([]).

% Write arguments separated by commas:
wcomma([A]) :- warg(A), nl.
wcomma([A|L]) :- warg(A), comma, wcomma(L).
wcomma([]) :- nl.

% Write a label or constant label:
wlbl(L) :- var(L), compile_options(a(A)), atomic(A), !, write(L), und, write(A).
wlbl(L) :- var(L), !, write(L).
wlbl(X) :- write(X).

% Write an argument:
warg(Lbl) :- var(Lbl), wlbl(Lbl). % var/1 needed here.
warg(x(I)) :- write('X'), write(I), !.
warg(y(I)) :- write('Y'), write(I), !.
warg(N) :- number(N), write('&'), write(N), !.
warg(C) :- compile_options(q), write(''''),write(C),write(''''), !.
warg(A/B) :- write(A),write('/'),write(B), !.
warg(C) :- \+(compile_options(q)), writeq(C), !.

% Write a single instruction on a line:
winstr(X) :- atomic(X), wtabln(X).
winstr(fail/0) :- wtabln(fail).
winstr(label(L)) :- wlbl(L), wln(':').
winstr(execute(L)) :- var(L), !, wtab(execute_label), space, wlbl(L), nl.
winstr(execute(Proc)) :- wtab(execute_proc), space, wlbl(Proc), nl.
winstr(cutd(L)) :- wtab(cutd), space, wlbl(L), nl.
winstr(pair(A,B)) :- tab1, warg(A), nl, tab1, wlbl(B), nl.
winstr(cdrpair(A,B)) :- A==fail,B==fail, wtab(fail), wtabln(tcdr), wtabln(fail).
winstr(cdrpair(A,B)) :- tab1, warg(A), wtabln(tcdr), tab1, wlbl(B), nl.
winstr(switch_on_term(A,B,C)) :-
	wtab(switch_on_term), space, wcomma([A,B,C]).
winstr(switch(Kind,Mask,Lbl)) :-
	wtab(switch_on_), write(Kind), space,
	write(Mask),comma,wlbl(Lbl),nl.
winstr(unify(void,_,Mode)) :- wtab(unify_void), write_mode(Mode), nl.
winstr(unify_nil(Mode)) :- wtab(unify_nil), write_mode(Mode), nl.
winstr(get_cdr_list(Mode)) :- wtab(get_cdr_list), write_mode(Mode), nl.
% Instructions for VLSI PLM:
% winstr(Instr) :-
% 	Instr=..[Name|Args],
% 	vlsi_instr(_, Name),
% 	wtab(Name), space,
% 	wcomma(Args).
% winstr(deref(Arg)) :-
% 	wtab(deref),space, warg(Arg), nl.
winstr(Instr) :-
	Instr =.. [Name,structure,Atom/Arity,X],
	(Name = get; Name = put),
	!,
	wtab(Name), und, write(structure), space,
	warg(Atom/Arity), comma, warg(X), comma, wln(Arity).
winstr(Instr) :-
	Instr=..[Name,Type,FirstArg|Args],
	(Name=get; Name=put),
	wtab(Name), und, write(Type), write_xy(Type,FirstArg),
	space, wcomma([FirstArg|Args]).
winstr(unify(Type,X,Mode)) :-
	wtab(unify), und, write(Type), write_mode(Mode), write_xy(Type,X),
	space, wcomma([X]).
winstr(call(Name,N)) :-
	wtab(call), space,
	wname(Name),comma,wln(N).
winstr(init(N)) :-
	wtab(init), space, wcomma([y(N)]).
winstr(Instr) :-
	Instr=..[try|Args],
	wtab(try),
	access(arity,Arity),
	min(Arity,7,Min),
	write_else(Min, Args).
winstr(Instr) :-
	Instr=..[Name|Args],
	(Name=retry; Name=trust),
	wtab(Name),
	write_else(Args).
winstr(Instr) :-
	Instr=..[Name,Arg],
	(Name=get_nil; Name=put_nil; Name=get_list; Name=put_list), !,
	wtab(Name), space, wcomma([Arg]).
winstr(Instr) :-
	Instr=..[Name,Arg],
	wtab(Name), space, wln(Arg).
winstr(Name/Arity) :-
	wtab(escape), space, wname(Name/Arity), nl.

wname(N/A) :- !, write(N), write('/'), write(A).
wname(N) :- write(N).

% Write a space, comma, or underline character:
space :- write('  ').
comma :- write(',').
und :- write('_').

% Tab before or newline after:
wtab(X) :- tab1, write(X).
wln(X) :- write(X), nl.
wtabln(X) :- tab1, write(X), nl.
tab1 :- put(9).


w(Expr) :- _ is Expr, write(Expr).

wl([A|Rest]) :- write(A), nl, wl(Rest).
wl([]) :- nl.

write_else(Arity, [else,Label]) :-
	write('_me_else'), space,
	warg(Label), comma, wln(Arity).
write_else(Arity, [Label]) :-
	space, warg(Label), comma, wln(Arity).

write_else([else,Label]) :-
	write('_me_else'), space,
	wcomma([Label]).
write_else([Label]) :-
	space, wcomma([Label]).

write_mode(unknown).
write_mode(write) :- write('_write').

write_xy(variable,x(_)) :- write('_x').
write_xy(value,x(_)) :- write('_x').
write_xy(variable,y(_)) :- write('_y').
write_xy(value,y(_)) :- write('_y').
write_xy(_,_).

min(X,Y,X) :- X < Y, !.
min(X,Y,Y).
