#
# System Makefile for:
#	Sun running UNIX and a Bourne Shell that does error-checking
# switching.
#
#if exists(/usr/include/sun)
# if exists(/usr/etc/mc68881version)
#  include <sys-sun3.mk>
# elif exists(/usr/etc/fpuversion4)
#  include <sys-sun4.mk>
# endif
#elif exists(/usr/include/next)
# include <sys-next.mk>
#elif exists(/usr/include/mips)
# include <sys-mips.mk>
#elif exists(/hp-ux)
# include <sys-hpux.mk>
#endif
#
# so we can say ifdef pmake
pmake=
#

.SUFFIXES : .out .a .ln .o .c .cc .F .f .e .r .y .l .s .cl .p .h \
	    .c,v .cc,v .y,v .l,v .s,v .h,v
.INCLUDES : .h
.LIBS	: .a

#
# Assume files without suffix are executables
#
#ifndef NONULL
.NULL	: .out
#endif

# Use absolute paths whenever possible. This greatly reduces server load
# once pmake has created parallel jobs all over the network ...
YACC	?= /usr/bin/yacc
YFLAGS	?=
LEX	?= /usr/bin/lex
LFLAGS	?=
CC	?= /bin/cc
RM	?= /bin/rm -f
MV	?= /bin/mv
AS	?= /bin/as
PC	?= /usr/ucb/pc
PFLAGS	?=
CFLAGS	?=
AFLAGS	?=
RC	?= /usr/bin/f77
RFLAGS	?=
FC	?= /usr/bin/f77
EFLAGS	?=
FFLAGS	?=
LOADLIBES ?=
CO	?= /usr/local/bin/co
COFLAGS	?=
CI	?= /usr/local/bin/ci
CIFLAGS	?=
AR	?= /bin/ar
ARFLAGS	?= r
RANLIB	?= /bin/ranlib
LD	?= /bin/ld
LINT	?= /usr/bin/lint
MKDEP	?= makedepend

.c,v.c .y,v.y .l,v.l .s,v.s .h,v.h :
	$(CO) $(COFLAGS) $(.IMPSRC) $(.TARGET)

.c.o :
	$(CC) $(CFLAGS) -c $(.IMPSRC)

.p.o :
	$(PC) $(PFLAGS) -c $(.IMPSRC)

.cl.o :
	class -c $(.IMPSRC)

.e.o .r.o .F.o .f.o :
	$(FC) $(RFLAGS) $(EFLAGS) $(FFLAGS) -c $(.IMPSRC)

.s.o :
	$(AS) $(AFLAGS) -o $(.TARGET) $(.IMPSRC)

.y.o :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) -c y.tab.c
	$(RM) y.tab.c
	$(MV) y.tab.o $(.TARGET)

.l.o :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) -c lex.yy.c
	$(RM) lex.yy.c
	$(MV) lex.yy.o $(.TARGET)

.y.c :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(MV) y.tab.c $(.TARGET)

.l.c :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(MV) lex.yy.c $(.TARGET)

.s.out .c.out .o.out :
	$(CC) $(CFLAGS) $(.IMPSRC) $(LOADLIBES) -o $(.TARGET)

.f.out .F.out .r.out .e.out :
	$(FC) $(EFLAGS) $(RFLAGS) $(FFLAGS) $(.IMPSRC) \
		$(LOADLIBES) -o $(.TARGET)
	$(RM) $(.PREFIX).o

.y.out :
	$(YACC) $(YFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) y.tab.c $(LOADLIBES) -ly -o $(.TARGET)
	$(RM) y.tab.c

.l.out :
	$(LEX) $(LFLAGS) $(.IMPSRC)
	$(CC) $(CFLAGS) lex.yy.c $(LOADLIBES) -ll -o $(.TARGET)
	$(RM) lex.yy.c

#
# System search-path specifications.
#
.PATH.h: /usr/include
.PATH.a: /usr/local/lib /usr/lib
