/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Iterator;
import java.util.List;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;

public class TraceMethods
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String type = this.args.remove(0).toString().toLowerCase();
        if (!type.equals("entry") && !type.equals("exit")) {
            throw new JDEException("Invalid type");
        }
        Object thread = Etc.getThreadFromArgs(this.args);
        ObjectReference tRef = null;
        if (thread == null) {
            tRef = null;
        } else if (thread instanceof Long) {
            tRef = this.proc.getStore().get(thread);
            if (tRef == null) {
                throw new JDEException("No such thread exists");
            }
            if (!(tRef instanceof ThreadReference)) {
                throw new JDEException("No such thread exists (anymore?)");
            }
        } else if (thread instanceof String) {
            tRef = this.proc.getThread(thread.toString());
        }
        List classFilters = Etc.getClassFiltersFromArgs(this.args);
        List classExFilters = Etc.getClassExFiltersFromArgs(this.args);
        Long requestID = null;
        EventRequestManager em = this.proc.getVM().eventRequestManager();
        if (type.equals("entry")) {
            Iterator it;
            MethodEntryRequest mer = em.createMethodEntryRequest();
            if (tRef != null) {
                mer.addThreadFilter((ThreadReference)tRef);
            }
            mer.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(mer);
        } else if (type.equals("exit")) {
            Iterator it;
            MethodExitRequest mer = em.createMethodExitRequest();
            if (tRef != null) {
                mer.addThreadFilter((ThreadReference)tRef);
            }
            mer.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
            if (classFilters != null) {
                it = classFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassFilter(it.next().toString());
                }
            }
            if (classExFilters != null) {
                it = classExFilters.iterator();
                while (it.hasNext()) {
                    mer.addClassExclusionFilter(it.next().toString());
                }
            }
            requestID = this.addIdentifiableRequest(mer);
        }
        this.jde.signalCommandResult(this.procID, this.cmdID, requestID);
    }

    public Object clone() {
        return new TraceMethods();
    }
}

