/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import jde.wizards.DefaultNameFactory;
import jde.wizards.InterfaceFactory;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.NotAnAbstractClassException;
import jde.wizards.Signature;

public class AbstractClassFactory
extends InterfaceFactory {
    static AbstractClassFactory abstractClassFactory;

    public AbstractClassFactory() {
    }

    public AbstractClassFactory(NameFactory factory) {
        super(factory);
    }

    public void process(String argAbstracClassName) throws ClassNotFoundException, NotAnAbstractClassException {
        this.process(argAbstracClassName, true);
    }

    public void process(String name, boolean truncate) throws ClassNotFoundException, NotAnAbstractClassException {
        Class<?> aclass;
        int iModifiers;
        if (null == this.namefactory) {
            this.namefactory = new DefaultNameFactory();
        }
        if (!Modifier.isAbstract(iModifiers = (aclass = Class.forName(name)).getModifiers())) {
            throw new NotAnAbstractClassException(name);
        }
        Vector methods = new Vector();
        this.getAbstractMethods(aclass, methods);
        int size = methods.size();
        int i = 0;
        while (i < size) {
            this.sortByDeclaringClass(new Signature((Method)methods.get(i), this, truncate));
            ++i;
        }
    }

    private void getAbstractMethods(Class argClass, Vector abstractMethods) {
        Method[] methods = argClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers) && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers))) {
                abstractMethods.add(method);
            }
            ++i;
        }
        Class superClass = argClass.getSuperclass();
        if (superClass != null) {
            this.getAbstractMethods(superClass, abstractMethods);
        }
        Class<?>[] interfaces = argClass.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            this.getAbstractMethods(interfaces[i2], abstractMethods);
            ++i2;
        }
    }

    public static void getImportedClasses() {
        MethodFactory.println(abstractClassFactory.getImportsAsList());
    }

    public static void makeAbstractClassExpression(String name, boolean truncate) {
        if (abstractClassFactory == null) {
            abstractClassFactory = new AbstractClassFactory();
        }
        abstractClassFactory.flush();
        abstractClassFactory.makeAbstractClassExpressionInternal(name, truncate);
    }

    private void makeAbstractClassExpressionInternal(String name, boolean truncate) {
        try {
            this.process(name, truncate);
        }
        catch (ClassNotFoundException e) {
            MethodFactory.println("(error \"Error: could not find abstract class named: " + name + ". " + "Note: name must be qualified.\")");
            return;
        }
        catch (NotAnAbstractClassException e) {
            MethodFactory.println("(error \"Error: " + name + " is not an abstract class.\")");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            MethodFactory.println("(error \"Error: unknown type.\")");
            return;
        }
        this.dumpExpression(new PrintWriter(System.out, true), truncate);
    }

    public static void main(String[] args) {
        AbstractClassFactory.makeAbstractClassExpression("java.net.SocketImpl", false);
    }
}

