;;; essd-ipy.el --- IPython customization

;; Copyright (C) 2002 A.J. Rossini

;; Author: A.J. Rossini <rossini@u.washington.edu>
;; Maintainers: A.J. Rossini <rossini@u.washington.edu>
;; Created: 20 Feb 2002
;; Modified: $Date: 2002/05/24 23:27:39 $
;; Version: $Revision: 1.1 $
;; RCS: $Id: essd-ipy.el,v 1.1 2002/05/24 23:27:39 rossini Exp $
;;
;; Keywords: start up, configuration.

;; This file is part of ESS.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:
;;; This file defines all the R customizations for ESS.  See essl-s.el
;;; for general S language customizations.

;;; Autoloads and Requires

(ess-message "[essd-ipy:] (require 'essl-py)")
(require 'essl-py)

(ess-message "[essd-ipy:] (autoload ..) & (def** ..)")

(autoload 'inferior-ess "ess-inf" "Run an ESS process.")
(autoload 'ess-mode     "ess-mode" "Edit an ESS process.")

;;; Code:

(defvar IPy-customize-alist
  '((ess-local-customize-alist     . 'IPy-customize-alist)
    (ess-language                  . "Py")
    (ess-dialect                   . "IPy")
    (ess-suffix                    . "py")
    (ess-loop-timeout              . 500000 )
    (ess-dump-filename-template    . (concat (user-login-name)
					     ".%s."
					     ess-suffix))
    (ess-mode-editing-alist        . ess-py-editing-alist)
    (ess-mode-syntax-table         . ess-py-syntax-table)
    (ess-help-sec-regex            . ess-help-py-sec-regex)
    (ess-help-sec-keys-alist       . ess-py-help-sec-keys-alist)
    (ess-object-name-db-file       . "ess-ipy-namedb.el" )
    (ess-retr-lastvalue-command    . nil)
    (ess-save-lastvalue-command    . nil)
    (ess-imenu-mode-function       . 'ess-imenu-ipy)
    (inferior-ess-program          . inferior-IPY-program-name)
    (inferior-ess-objects-command  . "objects(pos = %d)\n")
    (inferior-ess-search-list-command   . "search()\n")
    (inferior-ess-help-command     . "help(\"%s\", htmlhelp=FALSE)\n")
    (inferior-ess-exit-command     . "q()\n")
    (inferior-ess-primary-prompt   . "In \[[1234567890]\]: ")
    (inferior-ess-secondary-prompt . "...: ")
    (comint-use-prompt-regexp-instead-of-fields . t) ;; emacs 21 and up
    (inferior-ess-start-file       . nil)            ;; "~/.ess-R"
    (inferior-ess-start-args       . "")
    (ess-STERM  . "iESS")
    (ess-editor . R-editor)
    (ess-pager  . R-pager)
    (inferior-ess-language-start .
				 (concat "options("
					 "STERM='"  ess-STERM  "'"
					 (if ess-editor 
					     (concat ", editor='" ess-editor "'"))
					 (if ess-pager 
					     (concat ", pager='"  ess-pager  "'"))
					 ")")))
  "Variables to customize for IPython")

;;; AJR: Need to condition on this...!
(require 'ess-menu)

;; R that does the right thing irregardless of OS.
(defun IPython (&optional start-args)
  "Call 'IPython', the CLI for Python.
Optional prefix (C-u) allows to set command line arguments, such as --vsize."
  (interactive "P")
  (setq ess-customize-alist IPy-customize-alist)
  ;; for debugging only
  (ess-write-to-dribble-buffer
   (format
    "\n(R): ess-dialect=%s, buf=%s, start-arg=%s\n current-prefix-arg=%s\n"
    ess-dialect (current-buffer) start-args current-prefix-arg))
  (let* ((r-always-arg "  ")
	 (r-start-args
	  (concat r-always-arg
		  (if start-args
		      (read-string
		       (concat "Starting Args [other than `"
			       r-always-arg
			       "'] ? "))
		    nil)))
	 default-process-coding-system)
    (if ess-microsoft-p
	(setq default-process-coding-system '(undecided-dos . undecided-dos)))
    (inferior-ess r-start-args) ;; (R)
    (if inferior-ess-language-start
	(ess-eval-linewise inferior-ess-language-start))))


(defun ess-Py-mode  (&optional proc-name)
  "Major mode for editing R source.  See `ess-mode' for more help."
  (interactive)
  (setq ess-customize-alist R-customize-alist)
  ;;(setq imenu-generic-expression R-imenu-generic-expression)
  (ess-mode R-customize-alist proc-name)
  ;;; AJR: Need to condition on this...!
  ;; MM: and you probably should really use ess-imenu-mode-function from above!
  (ess-imenu-R))

(fset 'ipy-mode 'IPy-mode)


(autoload 'ess-transcript-mode "ess-trns"
  "Major mode for editing S transcript files." t)

(defun IPy-transcript-mode ()
  "Does the right thing."
  (interactive)
  (ess-transcript-mode R-customize-alist))

(fset 'r-transcript-mode 'R-transcript-mode)

 ; provides

(provide 'essd-r)

 ; Local variables section

;;; This file is automatically placed in Outline minor mode.
;;; The file is structured as follows:
;;; Chapters:     ^L ;
;;; Sections:    ;;*;;
;;; Subsections: ;;;*;;;
;;; Components:  defuns, defvars, defconsts
;;;              Random code beginning with a ;;;;* comment

;;; Local variables:
;;; mode: emacs-lisp
;;; outline-minor-mode: nil
;;; mode: outline-minor
;;; outline-regexp: "\^L\\|\\`;\\|;;\\*\\|;;;\\*\\|(def[cvu]\\|(setq\\|;;;;\\*"
;;; End:

;;; ess-site.el ends here
