//
//   Copyright (C) 2005, 2006 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "sdl_glue.h"
#include <SDL.h>



using namespace std;


namespace gnash
{

class SdlAggGlue : public SdlGlue
{
  public:
    SdlAggGlue();
    virtual ~SdlAggGlue();

    bool init(int argc, char **argv[]);
    render_handler* createRenderHandler(int depth);
    bool prepDrawingArea(int width, int height, uint32_t sdl_flags);
    uint32_t maskFlags(uint32_t sdl_flags);
    void render();
    void render(int minx, int miny, int maxx, int maxy);

    virtual void setInvalidatedRegion(const rect& bounds);
    virtual void resize(int width, int height);

  private:
    SDL_Surface     *_sdl_surface;
    unsigned char   *_offscreenbuf;
    SDL_Surface     *_screen;
    render_handler  *_agg_renderer;
    SDL_Rect         _bounds;
    int              _width, _height;
    uint32_t         _sdl_flags;
};

}
