/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -7 -C -k '1,3-11,$' -i 1 lib/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 308
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 2816
/* maximum key range = 2813, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817,    1,   21, 2817,   11,  371,
        66,  366,   91,  211,  171,   36,    1,  506,   56, 2817,
      2817, 2817, 2817, 2817, 2817,  111,   16,  507,   16,    1,
        51,   36,  256,    1,  131,  111,    1,    1,    6,    1,
         6, 2817,   81,    1,    1,  506,   41,    1,    1,   11,
         1, 2817, 2817, 2817, 2817,   36, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817,
      2817, 2817, 2817, 2817, 2817, 2817, 2817, 2817
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
        hval += asso_values[(unsigned char) str[7]];
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  static const struct alias wordlist[] =
    {
      {""}, {""}, {""}, {""},
      {"L8", ei_iso8859_14},
      {""}, {""}, {""},
      {"SJIS", ei_sjis},
      {""},
      {"MS-EE", ei_cp1250},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN8", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"850", ei_cp850},
      {""}, {""}, {""}, {""},
      {"NEXTSTEP", ei_nextstep},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"L7", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TCVN", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"L2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"R8", ei_hp_roman8},
      {"X0208", ei_jisx0208},
      {""},
      {"LATIN7", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"L4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-ANSI", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"862", ei_cp862},
      {""}, {""},
      {"JP", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"BIGFIVE", ei_ces_big5},
      {""},
      {"BIG-FIVE", ei_ces_big5},
      {"GREEK8", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"ISO-IR-87", ei_jisx0208},
      {""}, {""},
      {"ASMO-708", ei_iso8859_6},
      {""}, {""},
      {"L6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"LATIN4", ei_iso8859_4},
      {"SHIFT-JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"L5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"JIS0208", ei_jisx0208},
      {"WINBALTRIM", ei_cp1257},
      {""}, {""},
      {"SHIFT_JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM850", ei_cp850},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-874", ei_cp874},
      {""},
      {"HZ", ei_hz},
      {""},
      {"GBK", ei_ces_gbk},
      {""}, {""}, {""},
      {"GREEK", ei_iso8859_7},
      {""},
      {"TIS620", ei_tis620},
      {"JIS_X0208", ei_jisx0208},
      {"TIS-620", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"TIS620-0", ei_tis620},
      {"KOI8-R", ei_koi8_r},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"GEORGIAN-PS", ei_georgian_ps},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-58", ei_gb2312},
      {""}, {""}, {""},
      {"IBM862", ei_cp862},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KOREAN", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"MS-ARAB", ei_cp1256},
      {""},
      {"866", ei_cp866},
      {""}, {""}, {""}, {""},
      {"MS-GREEK", ei_cp1253},
      {""}, {""}, {""}, {""}, {""},
      {"LATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""},
      {"HEBREW", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"ISO-2022-JP", ei_iso2022_jp},
      {""},
      {"L3", ei_iso8859_3},
      {""}, {""}, {""}, {""},
      {"L1", ei_iso8859_1},
      {""}, {""}, {""},
      {"ISO-IR-57", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"JAVA", ei_java},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS_KANJI", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO-2022-JP-2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-6", ei_ascii},
      {"LATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-HEBR", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"HP-ROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"BIG5", ei_ces_big5},
      {""},
      {"BIG-5", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"WCHAR_T", ei_local_wchar_t},
      {""}, {""},
      {"ISO-2022-KR", ei_iso2022_kr},
      {""}, {""},
      {"ISO-IR-100", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"US", ei_ascii},
      {""}, {""}, {""}, {""}, {""},
      {"CN", ei_iso646_cn},
      {"EUCTW", ei_euc_tw},
      {""},
      {"EUC-TW", ei_euc_tw},
      {""}, {""}, {""},
      {"IBM866", ei_cp866},
      {""}, {""},
      {"CHINESE", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"JOHAB", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"VISCII", ei_viscii},
      {""},
      {"ISO-IR-148", ei_iso8859_9},
      {""}, {""}, {""}, {""},
      {"UTF-8", ei_utf8},
      {""}, {""}, {""}, {""},
      {"ISO-IR-226", ei_iso8859_16},
      {""}, {""}, {""}, {""},
      {"X0212", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""},
      {"CN-GB", ei_euc_cn},
      {""}, {""},
      {"UCS-2LE", ei_ucs2le},
      {""}, {""}, {""},
      {"ISO646-JP", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UCS-2BE", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-127", ei_iso8859_6},
      {""}, {""}, {""},
      {"UCS-4LE", ei_ucs4le},
      {"MS-CYRL", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM367", ei_ascii},
      {""}, {""}, {""},
      {"ELOT_928", ei_iso8859_7},
      {""}, {""},
      {"UCS-4BE", ei_ucs4be},
      {""},
      {"ASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ARMSCII-8", ei_armscii_8},
      {"UTF-7", ei_utf7},
      {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-2", ei_ucs2},
      {""}, {""},
      {"ISO-IR-14", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"JIS_X0208-1990", ei_jisx0208},
      {"EUCJP", ei_euc_jp},
      {""},
      {"EUC-JP", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"UCS-2-INTERNAL", ei_ucs2internal},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1258", ei_cp1258},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4", ei_ucs4},
      {""},
      {"CSISO87JISX0208", ei_jisx0208},
      {"WINDOWS-1250", ei_cp1250},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4-INTERNAL", ei_ucs4internal},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACROMAN", ei_mac_roman},
      {"WINDOWS-1257", ei_cp1257},
      {""}, {""}, {""}, {""}, {""},
      {"UCS-2-SWAPPED", ei_ucs2swapped},
      {""},
      {"CP874", ei_cp874},
      {""}, {""},
      {"ISO-2022-JP-1", ei_iso2022_jp1},
      {"ISO-8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"ISO-IR-144", ei_iso8859_5},
      {""},
      {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
      {"ISO-2022-CN", ei_iso2022_cn},
      {""}, {""},
      {"CP850", ei_cp850},
      {"LATIN3", ei_iso8859_3},
      {""}, {""},
      {"ISO-IR-157", ei_iso8859_10},
      {""}, {""},
      {"WINDOWS-1252", ei_cp1252},
      {"UCS-4-SWAPPED", ei_ucs4swapped},
      {""}, {""},
      {"LATIN1", ei_iso8859_1},
      {"JIS_X0212", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO_8859-8", ei_iso8859_8},
      {""}, {""},
      {"CSISOLATIN2", ei_iso8859_2},
      {""}, {""}, {""}, {""},
      {"WINDOWS-1254", ei_cp1254},
      {""}, {""}, {""}, {""}, {""},
      {"CHAR", ei_local_char},
      {""},
      {"EUCKR", ei_euc_kr},
      {""},
      {"EUC-KR", ei_euc_kr},
      {""},
      {"CSKOI8R", ei_koi8_r},
      {""},
      {"CSISOLATINGREEK", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO-8859-7", ei_iso8859_7},
      {""}, {""},
      {"TCVN-5712", ei_tcvn},
      {""}, {""}, {""}, {""}, {""},
      {"GB18030", ei_gb18030},
      {""},
      {"CP862", ei_cp862},
      {""}, {""},
      {"MS-TURK", ei_cp1254},
      {""}, {""}, {""},
      {"CSISOLATIN4", ei_iso8859_4},
      {""},
      {"X0201", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8:1988", ei_iso8859_8},
      {""}, {""}, {""},
      {"ISO-IR-138", ei_iso8859_8},
      {""}, {""}, {""}, {""},
      {"ISO_8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACGREEK", ei_mac_greek},
      {"WINDOWS-1256", ei_cp1256},
      {""},
      {"ISO-IR-110", ei_iso8859_4},
      {""}, {""}, {""}, {""},
      {"ISO-8859-2", ei_iso8859_2},
      {"ECMA-118", ei_iso8859_7},
      {""},
      {"MULELAO-1", ei_mulelao},
      {""}, {""},
      {"CN-GB-ISOIR165", ei_isoir165},
      {""},
      {"CSISO2022JP", ei_iso2022_jp},
      {"MACHEBREW", ei_mac_hebrew},
      {"ISO-IR-126", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACTHAI", ei_mac_thai},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"WINDOWS-1255", ei_cp1255},
      {""},
      {"ISO_8859-2", ei_iso8859_2},
      {"ISO_8859-7:1987", ei_iso8859_7},
      {""},
      {"CSISOLATINHEBREW", ei_iso8859_8},
      {""},
      {"ISO-IR-203", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-4", ei_iso8859_4},
      {""}, {""},
      {"GEORGIAN-ACADEMY", ei_georgian_academy},
      {""}, {""},
      {"ISO_8859-4:1988", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-2:1987", ei_iso8859_2},
      {""}, {""},
      {"CSISO2022JP2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACROMANIA", ei_mac_romania},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-4", ei_iso8859_4},
      {""}, {""},
      {"ISO646-US", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSSHIFTJIS", ei_sjis},
      {""}, {""},
      {"ISO646-CN", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"GB_2312-80", ei_gb2312},
      {""},
      {"GB2312", ei_euc_cn},
      {""}, {""},
      {"ISO-IR-166", ei_tis620},
      {"CSHPROMAN8", ei_hp_roman8},
      {""},
      {"CSISOLATIN6", ei_iso8859_10},
      {""},
      {"GB_1988-80", ei_iso646_cn},
      {""}, {""},
      {"CSBIG5", ei_ces_big5},
      {""},
      {"CN-BIG5", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"UTF-32LE", ei_utf32le},
      {"ISO_646.IRV:1991", ei_ascii},
      {"CSISO2022KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""},
      {"JIS_X0201", ei_jisx0201},
      {""},
      {"JIS_X0208-1983", ei_jisx0208},
      {""}, {""}, {""}, {""},
      {"ANSI_X3.4-1968", ei_ascii},
      {"UTF-32BE", ei_utf32be},
      {""},
      {"MAC", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP866", ei_cp866},
      {""}, {""}, {""}, {""}, {""},
      {"EUCCN", ei_euc_cn},
      {""},
      {"EUC-CN", ei_euc_cn},
      {""},
      {"ISO_8859-6:1987", ei_iso8859_6},
      {""}, {""},
      {"MACINTOSH", ei_mac_roman},
      {""},
      {"ISO_8859-5:1988", ei_iso8859_5},
      {""}, {""}, {""}, {""},
      {"ECMA-114", ei_iso8859_6},
      {"CSIBM866", ei_cp866},
      {""}, {""},
      {"UNICODELITTLE", ei_ucs2le},
      {""}, {""},
      {"WINDOWS-1253", ei_cp1253},
      {""}, {""}, {""}, {""},
      {"WINDOWS-1251", ei_cp1251},
      {""},
      {"ISO-IR-165", ei_isoir165},
      {""},
      {"UTF-32", ei_utf32},
      {"CSISOLATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""},
      {"CSVISCII", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""},
      {"JIS_X0212-1990", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"JIS_X0212.1990-0", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-6", ei_iso8859_6},
      {"UTF-16LE", ei_utf16le},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP367", ei_ascii},
      {""}, {""}, {""}, {""},
      {"UTF-16BE", ei_utf16be},
      {"ISO-8859-10", ei_iso8859_10},
      {""}, {""}, {""},
      {"UNICODEBIG", ei_ucs2be},
      {"KOI8-U", ei_koi8_u},
      {""}, {""}, {""},
      {"CSASCII", ei_ascii},
      {"US-ASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"BIG5HKSCS", ei_big5hkscs},
      {""},
      {"BIG5-HKSCS", ei_big5hkscs},
      {""}, {""}, {""},
      {"ISO-8859-5", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-10", ei_iso8859_10},
      {"CP1258", ei_cp1258},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"MACICELAND", ei_mac_iceland},
      {""}, {""}, {""}, {""}, {""},
      {"CP1250", ei_cp1250},
      {""},
      {"ANSI_X3.4-1986", ei_ascii},
      {""}, {""}, {""}, {""},
      {"ISO_8859-5", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3:1988", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KOI8-RU", ei_koi8_ru},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-101", ei_iso8859_2},
      {""},
      {"ISO_8859-10:1992", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO58GB231280", ei_gb2312},
      {"CP1257", ei_cp1257},
      {"MACCENTRALEUROPE", ei_mac_centraleurope},
      {""},
      {"ISO_8859-1:1987", ei_iso8859_1},
      {"ISO_8859-14:1998", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSISO2022CN", ei_iso2022_cn},
      {""},
      {"CP950", ei_cp950},
      {""}, {""}, {""},
      {"HZ-GB-2312", ei_hz},
      {""}, {""}, {""},
      {"ARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""},
      {"CSISOLATINARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"UTF-16", ei_utf16},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-14", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""},
      {"CP1252", ei_cp1252},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"TIS620.2533-0", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-14", ei_iso8859_14},
      {""}, {""}, {""}, {""},
      {"ISO_8859-16:2000", ei_iso8859_16},
      {""}, {""}, {""},
      {"CSHALFWIDTHKATAKANA", ei_jisx0201},
      {""}, {""}, {""}, {""},
      {"MACUKRAINE", ei_mac_ukraine},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1254", ei_cp1254},
      {"MACCROATIAN", ei_mac_croatian},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"ISO_8859-15:1998", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_C6220-1969-RO", ei_iso646_jp},
      {""}, {""}, {""},
      {"CSISOLATIN1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSPC862LATINHEBREW", ei_cp862},
      {"IBM819", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-2", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-4", ei_ucs4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-16", ei_iso8859_16},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-1", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-16", ei_iso8859_16},
      {""}, {""},
      {"TCVN5712-1", ei_tcvn},
      {""}, {""}, {""}, {""},
      {"ISO-IR-109", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3", ei_iso8859_3},
      {""},
      {"CSGB2312", ei_euc_cn},
      {"CP1256", ei_cp1256},
      {"TIS620.2529-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-1", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"ISO-IR-179", ei_iso8859_13},
      {"CP932", ei_cp932},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UHC", ei_cp949},
      {""}, {""}, {""},
      {"ISO-8859-15", ei_iso8859_15},
      {""}, {""}, {""},
      {"CSEUCTW", ei_euc_tw},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-CELTIC", ei_iso8859_14},
      {""}, {""},
      {"TCVN5712-1:1993", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSUNICODE", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-15", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-149", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CP1255", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO14JISC6220RO", ei_iso646_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"JISX0201-1976", ei_jisx0201},
      {""}, {""}, {""}, {""},
      {"CSMACINTOSH", ei_mac_roman},
      {""}, {""},
      {"CSISOLATINCYRILLIC", ei_iso8859_5},
      {""},
      {"TIS620.2533-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-159", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO57GB1988", ei_iso646_cn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSUCS4", ei_ucs4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP936", ei_ces_gbk},
      {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
      {""}, {""}, {""},
      {"MACTURKISH", ei_mac_turkish},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO-8859-9", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO159JISX02121990", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSPC850MULTILINGUAL", ei_cp850},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-9", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KSC_5601", ei_ksc5601},
      {""}, {""}, {""},
      {"CSEUCKR", ei_euc_kr},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1-UTF-7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-13", ei_iso8859_13},
      {""}, {""}, {""},
      {"ISO_8859-9:1989", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACARABIC", ei_mac_arabic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"ISO_8859-13", ei_iso8859_13},
      {""}, {""}, {""},
      {"KS_C_5601-1987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1253", ei_cp1253},
      {""}, {""},
      {"CP819", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"JIS_C6226-1983", ei_jisx0208},
      {""},
      {"CP1251", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-199", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"VISCII1.1-1", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP949", ei_cp949},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"MACCYRILLIC", ei_mac_cyrillic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"UNICODE-1-1", ei_ucs2be},
      {""}, {""}, {""}, {""},
      {"CP1361", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSUNICODE11UTF7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KS_C_5601-1989", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"IBM-CP1133", ei_cp1133},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"CSUNICODE11", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSKSC56011987", ei_ksc5601}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
