/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>

/* external functions from genlib ***********************/
FILE	getifile(),getofile();
int	sorttab(),srchtab(),lsttab(),getdec(),putdec();
TEXTPTR	getstr();

/* external functions from supprt ***********************/
int	initnode(),freenodes();
TREEPTR	getnode(),fndleft(),makcopy();
int	link(),unlink(),adjpos();

/* external functions from edimg ***********************/
int	edimage(),dispimg();

/* external functions from edtext ***********************/
int	edtext(),disptx();

/* external functions from getmmm ***********************/
int	dumper(),readmmm();

/* external functions from putmmm ***********************/
int	stormmm(),sndmmm();

/* external functions from diolib ***********************/
int	dclose();


/*********************************************************/
/* command table */
#define	MAXCOM  17

static	TEXTPTR  comtab[] =
	{ "QUIT","EDTEXT","EDIMAGE","STORE","HARDCOPY",
	"DISPLAY","?","READ","NEXT","BACKUP",
	"DUMP","PAGE","SNDMSG","INFO","INIT",
	"DELETE","UNDELETE",
	};

/* table of function names which handle corresponding commands */
/* last two entries are for illegal and ambiguous commands resp. */
static	PFI  functab[] =
	{&quit,&edtext,&edimage,&store,&hardcopy,
	&display,&lstmcom,&readm,&next,&backup,
	&dump,&selpage,&sndmsg,&tinfo,&tinit,
	&pgdelete,&pgundelete,
	&illcom,&ambcom 
	};

static	int	comquit = 0;

/*********************************************************/
/* algorithm name table. Internally, alg. is represented as 
a number = index of the alg. in this table */
int	maxalg	= 4;
TEXTPTR	algnam[]
	{"BITMAP","MBITMAP","HUFFMAN","TEXT" };

TEXT	linbuf[80] = " " ; /* temp buff */
TEXT	filenam[20] = " "; /* file name of current file */

/* error messages */
TEXT	errtyp[] = "illegal type of node\n";
TEXT	opnerr[] = "open error";

/* global variables */
FILE	fd = 0;		/* fd of current open file; GLOBAL */
TREEPTR	top = NULL;	/* ptr to current page node */
TREEPTR	mtop = NULL;	/* topmost dummy node */
TREEPTR	delnode = NULL;	/* pointer to last deleted structure */
int	format = 0;	/* format of message being outputted */
			/* 0 => filenames ; 1 => actual data */
int	dumpflag = 0;	/* 1 => give logical dump of MM message */
			/* being read */ 
int	pagenum   = 1;  /* current page number */

/*********************************************************/
/* This is the top level command interpreter. It first sorts
    the command tables ( makes list of commands look prettier) ;
    then it calls appropriate routine in response to user command */

main()

{
FAST	int	command ;

sorttab(comtab,functab,MAXCOM);		/* sort command tables */
comquit = srchtab(comtab,MAXCOM,"QUIT"); /* index of QUIT command */

initnode(mtop = getnode() );		/* mtop is forever */
top = NULL;				/* no current page */
do {
	getstr(">",linbuf) ; 		/* get user command string */
	command = srchtab(comtab,MAXCOM,linbuf) ;
	INDCALL(functab[command]) ;     /* call command handler */
	}
while (command != comquit );

} 	/* of main */


/*********************************************************/
/* list all commands 					 */

lstmcom()
{
lsttab(comtab,MAXCOM);
}

/*******************************************************/
/* generate hard copy of current message. Unimplemented */
hardcopy()
{
}

/**********************************************************/
/* create MMM with headers 				*/
/* prompts user for output file and message format */
/* and header fields (date (?),from,to,cc,subject ) */

sndmsg()
{
if ( (fd = getofile(filenam,"MMM") ) < 0 ) return;
getformat();
sndmmm(mtop);
dclose(fd);
}

/**********************************************************/
/* store everything without headers 			*/
/* prompts user fot output file name and format */

store()
{
if ( (fd = getofile(filenam,"TMM") ) < 0 ) return;
getformat();
stormmm(mtop);
dclose(fd);
}

/**********************************************************/
/* read MMM, construct structure and append to present page list */
/* set present page to first page. MMM in file can be MM message*/
/* with headers or body only				*/

readm()
{
if ( (fd = getifile(filenam,"MMM") ) < 0 ) return;
dumpflag = 0;		/* no dump. can make it user specifiable */
readmmm(mtop);
dclose(fd);
top=mtop->lptr;
pagenum = 1;
}

/********************************************************/
/* display all pages; set present page to first page (?)*/

display()
{
putstr(STDOUT,"\n\n\n",NULL);
for (top = mtop->lptr; top ; top =top->rptr) { /* for each page */
	if (top->alg == ALGTEXT) disptx(top);  /* call display routine */
	else dispimg(top);
	}
top=mtop->lptr;
pagenum = 1;
}

/*********************************************************/
/* select next page and give appropriate info */
next()
{
if (top ) { 			/* if top != NULL */
	top = top->rptr;
	pagenum += 1;
	}
sayhi(top,pagenum);
}

/******************************************************/
/* select prevoius page */
backup()

{
top = fndleft(top);		/* find left node of top */
if ( (pagenum -= 1) < 1) pagenum = 1;
if (top == NULL) putstr(STDOUT,"at front\n",NULL);
else sayhi(top,pagenum);
}

/*******************************************************/
/* select specified page; if too large, select last page */
selpage()
{
int n;

if ( (n=getdec("page No.:")) == 0) n = 1; /* default page is 1 */
pagenum = 1;
for (top=mtop->lptr; top && (pagenum < n); top=top->rptr) 
	pagenum += 1;		/* ferret out the nth page */
sayhi(top,pagenum);
}

/******************************************************/
/* give useful info about current page */
sayhi(node,pagenum)
FAST	TREEPTR	 node;
int	pagenum;

{
if (node ) {
	putstr(STDOUT,"page:",NULL);
	putdec(pagenum,"   ");
	if (node->alg == ALGTEXT) putstr(STDOUT,"text here \n",NULL);
	else if (( node->alg >= ALGBITMAP ) && ( node->alg <= ALGCCITT ) )
		putstr(STDOUT,"image here \n",NULL);
	else	putstr(STDERR,"unknown type node\n",NULL);
	}
else	putstr(STDOUT,"end of message \n",NULL);

}

/***********************************************************/
/* provide logical dump of MM message */
/* prompts for input MM file */

dump()
{
if ( (fd=getifile(filenam,"MMM")) < 0) return;
dumper();
dclose(fd);
}

/******************************************************/
/* initialize everything. release all nodes except mtop */
tinit()

{
freenodes(mtop->lptr);
initnode(mtop);
top = NULL;
}

/************************************************/
/* print info about all pages */
tinfo()
{
FAST	TREEPTR node;
int	i;

i = 1;
for (node=mtop->lptr; (node ) ; node=node->rptr) {
	sayhi(node,i++);
	if(top == node) putstr(STDOUT,"you are here\n",NULL);
	}
}

/*********************************************************/
/* illegal command typed by user. gives error message */
illcom()
{
putstr(STDOUT,"unrecognized command -",linbuf,"\n",NULL);
}

/*********************************************************/
/* ambiguous command ( non-unique prefix of command typed
	by user	 */
ambcom()
{
putstr(STDOUT,"ambiguous command -",linbuf,"\n",NULL);
}

/*********************************************************/
quit()
{
putstr(STDOUT,"bye","\n",NULL);
}

/**********************************************************/
/* get format of MM message to be produced */
getformat()
{
TEXTPTR	s;

s = getstr("what format? 0-file names, 1-actual data-",linbuf);
format = 0;
if (*s == '1') format = 1;
}

/******************************************************/
/* delete current page. free nodes pointed to by delnode 
   and make delnode point to deleted ( unlinked) node */

pgdelete()
{
if ( !top ) putstr(STDOUT,"huh?\n",NULL);
else	{
	if ( delnode) freenodes(delnode); 	/* if previous deleted */
	delnode = top ;				/* str. exists, free it */
	unlink(top);			/* unlink present page. delnode*/
	pagenum = 1;			/* to it now */
	top = mtop->lptr;		/* select first page */
	}
}

/******************************************************/
/* undelete node. delnode points to previously deleted
   structure. new copy of deleted structure is made
   and linked to end of page list. For image
   structure, screen position is adjusted so that top segment
   is at virtual location (0,0) */

pgundelete()
{
if ( !delnode ) putstr(STDOUT,"huh?\n",NULL);
else	{
	link(mtop,top = makcopy(delnode) );	/* create copy and link */
	if ( (top->alg >= ALGBITMAP) && (top->alg <= ALGCCITT) )
		adjpos(top,0,0);
 	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              