/*****************************************************************************
*
* getime uses the RT-11 programmed request to obtain the system
* time. If for some reason there is no system time, getime returns
* a null pointer. Otherwise getime converts the system time into a null
* terminated string with the form hh:mm:ss and returns a pointer to the string
*
*****************************************************************************/
#include	<std.h>

getime(pbuf)
	TEXT	*pbuf;
{
int	n,totmin,time[3];
long	ticks;
TEXT	*buf ;

	if(emt375((021<<8),&ticks) < 0)
		return(NULL);

	buf = pbuf ;
	totmin = ticks/3600 ;
	time[0] = totmin / 60 ;		/* hours */
	time[1] = totmin % 60 ;		/* minutes */
	time[2] = (ticks % 3600) / 60 ;	/* seconds */
	for(n = 0; n != 3 ; ++n){
		if(time[n] < 10)
			*buf++ = '0' ;
		buf += itob(buf,time[n],10) ;
		*buf++ = ':' ;
		}
	*(--buf) = NULL ;
	return(pbuf);
}
                                                                                        