      INTEGER FUNCTION IGAIN3(KOP,DELTA,BETA,FMC,SIGMA,ER,PHI,EL,H,
     1EX,RAIN,EFF,RIN)
C
C     POWER GAIN OF ANTENNA AND GROUND REFLECTION LOSS.
C
      DIMENSION D1D(16),ELL(16),EX(4),Z(16)
      COMPLEX ACSQ,CIZ,DIF,EP,ET,QPAR,QPER,SQRD,V,Z,ZIJOT,ZT,ZTR
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /CUR/ DIJ,EIL,HIJ,KODE,ZIJOT
      COMMON /ONE/ CIX(16),CIY(16),CIZ(16),D(16),HP(16),N,SUM1,XK(16),ZZ
     1ERO
C
      WAVE=(VOFL*.001)/FMC
      Q=SIN(DELTA)
      T=COS(DELTA)
      DIF=CMPLX(ER,-60.*SIGMA*WAVE)
      ACSQ=CSQRT(DIF-T*T)
      QPER=(DIF*Q-ACSQ)/(DIF*Q+ACSQ)
      QPAR=(Q-ACSQ)/(Q+ACSQ)
      EL1=EL/WAVE
      IF (EL.LT.0.) EL1=ABS(EL)
      X=H/WAVE
      IF (H.LT.0.) X=ABS(H)
      HWAVE=PI2*X
      HQWAVE=2.*HWAVE*Q
      RHI=PHI*D2R
      SR=SIN(RHI)
      CR=COS(RHI)
      RETA=BETA*D2R
      SB=SIN(RETA)
      CB=COS(RETA)
      IF (IABS(KOP).EQ.13) GOTO 68
C
C     HORIZONTAL YAGI ANTENNA, KOP=4
C
17    IF (EL1.LT..25.OR.EL1.GT..75) GOTO 83
      N=EX(2)
      IF (N.LT.2.OR.N.GT.16) GOTO 87
      NM1=N-1
      NM2=N-2
      ZZERO=100.
      ELL(NM1)=EL1
      ELL(N)=PHI/WAVE
      IF (PHI.LT.0.) ELL(N)=ABS(PHI)
      ELL(1)=EX(1)/WAVE
      IF (EX(1).LT.0.) ELL(1)=ABS(EX(1))
      D(1)=EX(3)/WAVE
      IF (EX(3).LT.0.) D(1)=ABS(EX(3))
      D(NM1)=EX(4)/WAVE
      IF (EX(4).LT.0.) D(NM1)=ABS(EX(4))
      XK(1)=0.
      IF (NM2.LT.2) GOTO 19
      DO 18 J=2,NM2
      ELL(J)=ELL(1)
18    D(J)=D(1)
19    DO 20 J=2,N
20    XK(J)=XK(J-1)+D(J-1)
      DO 21 J=1,N
21    HP(J)=ELL(J)/2.
      IF (KOP.LT.0) GOTO 25
      SUM1=0.
      CALL CIN
      TT=4.*X*X
      DO 22 J=1,NM1
      TX=(NM1-J)*(NM1-J)
22    D1D(J)=SQRT(TT+TX*D(J)*D(J))
      D1D(N)=SQRT(TT+D(NM1)*D(NM1))
      DO 23 J=1,N
      EIL=PI2*HP(NM1)
      HIJ=PI2*HP(NM1)
      DIJ=PI2*D1D(J)
      CALL SIMP
23    Z(J)=ZIJOT
      SQRD=CSQRT(DIF)
      V=CMPLX(0.,0.)
      DO 24 J=1,N
24    V=V+CMPLX(CIX(J),CIY(J))*Z(J)
      SUM2=REAL(V*(1.-SQRD)/(1.+SQRD)/CMPLX(CIX(NM1),CIY(NM1)))
      RIN=SUM1+SUM2
      EFF=0.
25    CPSI=T*SB
      SPSI2=1.-CPSI*CPSI
      IF (SPSI2.EQ.0.) GOTO 83
      ET=CMPLX(0.,0.)
      EP=CMPLX(0.,0.)
      PR=-CB*PI2*T
      DO 26 J=1,N
      TK=PR*XK(J)
      TT=COS(PI*ELL(J)*CPSI)-COS(PI*ELL(J))
26    ET=ET+CIZ(J)*CMPLX(COS(TK),SIN(TK))*TT/SIN(PI*ELL(J))
      EP=ET
      ZTR=CMPLX(COS(HQWAVE),SIN(-HQWAVE))
      ET=ET*(1.-ZTR*QPER)*SB*Q
      EP=-CB*EP*(1.+ZTR*QPAR)
      ETMAG=CABS(ET)
      EPMAG=CABS(EP)
      RAIN=120.*RIN*(ETMAG*ETMAG+EPMAG*EPMAG)/(SPSI2*SPSI2)
      GOTO 82
C
C     GENERAL HORIZONTAL LOG-PERIODIC ANTENNA, KOP=13
C
68    IF (KOP.LT.0) GOTO 73
      ZZERO=EX(1)
      EX3=EX(3)
      N=EX(4)
      IF (N.LT.2.OR.N.GT.16) GOTO 87
      ELL(N)=EL1
      H1=X
      HP(N)=ELL(N)/2.
      D(N)=ELL(N)/4.
      XK(N)=HP(N)*COTAN(EX(2)*D2R)
      NM1=N-1
      DO 69 J=1,NM1
      ELL(N-J)=ELL(N-J+1)*EX3
      HP(N-J)=HP(N-J+1)*EX3
      XK(N-J)=XK(N-J+1)*EX3
69    D(N-J)=XK(N-J+1)-XK(N-J)
      SUM1=1.
      CALL CIN
      TH=4.*H1*H1
      SUMD=0.
      D1D(1)=2.*H1
      TX=4.*H1*CR
      DO 70 NJ=2,N
      SUMD=SUMD+D(NJ-1)
70    D1D(NJ)=SQRT(TH+SUMD*SUMD+TX*SUMD)
      DO 71 J=1,N
      EIL=PI2*HP(1)
      HIJ=PI2*HP(J)
      DIJ=PI2*D1D(J)
      CALL SIMP
71    Z(J)=ZIJOT
      V=CMPLX(0.,0.)
      DO 72 J=1,N
72    V=V+CMPLX(CIX(J),CIY(J))*Z(J)
      SQRD=CSQRT(DIF)
      SUM2=REAL(V*(1.-SQRD)/(1.+SQRD))
      RIN=SUM1+SUM2
      EFF=0.
73    CPSI=T*SB
      SPSI2=1.-CPSI*CPSI
      IF (SPSI2.EQ.0.) GOTO 83
      ET=CMPLX(0.,0.)
      EP=CMPLX(0.,0.)
      CBETA=PI2*(Q*CR-T*CB*SR)
      DO 74 J=1,N
      ZT=CMPLX(COS(XK(J)*CBETA),SIN(XK(J)*CBETA))
      ZTR=CMPLX(COS(2.*PI2*(XK(J)*CR+H1)*Q),SIN(-2.*PI2*(XK(J)*CR+H1)*
     1Q))
      TT=COS(PI2*ELL(J)/2.*CPSI)-COS(PI2*ELL(J)/2.)
      ET=ET+CIZ(J)*ZT*TT*(1.-QPER*ZTR)
74    EP=EP+CIZ(J)*ZT*TT*(1.+QPAR*ZTR)
      ET=ET*Q*SB/SPSI2
      EP=-EP*CB/SPSI2
      ETMAG=CABS(ET)
      EPMAG=CABS(EP)
      RAIN=120.*(ETMAG*ETMAG+EPMAG*EPMAG)/RIN
      GOTO 82
C
C     NORMAL EXIT
C
82    IGAIN3=1
      RETURN
C
83    IGAIN3=2
      RETURN
C
C     ERROR RETURN
C
87    IGAIN3=3
      RETURN
C
      END
      SUBROUTINE CIN
      DIMENSION LI(16), LJ(16), TVX(16,16), TVY(16,16), TX(16,16), TY(16
     1,16), TZ(16,16), Y(16,16), Z(16,16)
      COMPLEX CIZ,TZ,V,Y,Z,ZIJOT
      COMMON /CON/ D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RO,VOFL
      COMMON /ONE/ CIX(16),CIY(16),CIZ(16),D(16),HP(16),N,SUM1,XK(16),ZZ
     1ERO
      COMMON /CUR/ DIJ,EIL,HIJ,KODE,ZIJOT
      ZT=0.0
      SQR2=SQRT(2.0)
      YZ=1.0/ZZERO
      NM1=N-1
      IF (SUM1.EQ.0.0) GO TO 4
      DO 1 I1=1,N
      DO 1 J1=1,N
1     Y(I1,J1)=CMPLX(0.0,0.0)
      Y(1,1)=CMPLX(0.0,-YZ*COTAN(PI2*D(1)))
      COT=COTAN(PI2*D(N))
      T=ZT**2+1.0/(YZ*COT)**2
      Y(N,N)=CMPLX(ZT/T,-1.0/(YZ*COT*T)-YZ*COTAN(PI2*D(NM1)))
      DO 3 I2=1,NM1
      PDI=PI2*D(I2)
      IF (I2.EQ.1) GO TO 2
      Y(I2,I2)=CMPLX(0.0,-YZ*(COTAN(PDI)+COTAN(PI2*D(I2-1))))
2     J2=I2+1
      Y(I2,J2)=CMPLX(0.0,-YZ/SIN(PDI))
3     Y(J2,I2)=Y(I2,J2)
4     DO 7 I=1,N
      DO 7 J=I,N
      IF (I.NE.J) GO TO 5
      DIJ=HP(I)*SQR2/177.0
      GO TO 6
5     DIJ=ABS(XK(I)-XK(J))
6     EIL=PI2*HP(I)
      HIJ=PI2*HP(J)
      DIJ=PI2*DIJ
      CALL SIMP
      Z(I,J)=ZIJOT
      Z(J,I)=ZIJOT
      TZ(I,J)=ZIJOT
7     TZ(J,I)=ZIJOT
      DO 8 K2=1,N
      LI(K2)=0
8     LJ(K2)=0
      DO 9 K1=1,N
      IF (REAL(Z(K1,K1)).LT.506.0) GO TO 9
      Z(K1,K1)=CMPLX(506.0,-512.0)
      TZ(K1,K1)=Z(K1,K1)
      LI(K1)=1
      LJ(K1)=1
9     CONTINUE
      DO 10 I7=1,N
      DO 10 J7=1,N
      IF (I7.EQ.J7) GO TO 10
      IF (LI(I7).EQ.0.AND.LJ(J7).EQ.0) GO TO 10
      EIL=PI2*HP(I7)
      HIJ=PI2*HP(J7)
      CW1=COS(EIL+HIJ)
      CW2=COS(EIL-HIJ)
      ZMULT=60.0/(CW2-CW1)
      Z(I7,J7)=30.0*(Z(I7,J7)/ZMULT)
      TZ(I7,J7)=Z(I7,J7)
10    CONTINUE
      IF (SUM1.EQ.0.0) GO TO 13
      DO 11 I3=1,N
      DO 11 J3=1,N
      TZ(I3,J3)=CMPLX(0.0,0.0)
      DO 11 K=1,N
11    TZ(I3,J3)=TZ(I3,J3)+Y(I3,K)*Z(K,J3)
C*** LABELS 11-19 GUESSED AT 5/7/73 GWB
      DO 12 I4=1,N
12    TZ(I4,I4)=TZ(I4,I4)+CMPLX(1.0,0.0)
13    DO 14 I5=1,N
      DO 14 J5=1,N
      TX(I5,J5)=REAL(TZ(I5,J5))
14    TY(I5,J5)=AIMAG(TZ(I5,J5))
      CALL CMPINV (TX,TY,TVX,TVY,N)
      L=1
      IF (SUM1.EQ.0.0) L=NM1
      DO 16 I6=1,N
      CIX(I6)=TVX(I6,L)
      CIY(I6)=TVY(I6,L)
      IF (REAL(Z(I6,I6)).EQ.506.0) GO TO 15
      DIV=SIN(PI2*HP(I6))
      CIZ(I6)=CMPLX(CIX(I6)/DIV,CIY(I6)/DIV)
      GO TO 16
15    CIZ(I6)=CMPLX(1.7*CIX(I6),1.7*CIY(I6))
16    CONTINUE
      IF (SUM1.EQ.0.0) GO TO 18
      V=CMPLX(0.0,0.0)
      DO 17 J6=1,N
17    V=V+CMPLX(CIX(J6),CIY(J6))*Z(1,J6)
      GO TO 19
18    V=CMPLX(CIX(NM1),CIY(NM1))
      V=1./V
19    SUM1=REAL(V)
      RETURN
      END
      SUBROUTINE SIMP
      COMPLEX CSZ1,ZIJOT
      COMMON /CUR/ DIJ,EIL,HIJ,KODE,ZIJOT
      HS=EIL+HIJ
      HD=EIL-HIJ
      DIJ2=DIJ**2
      CW1=COS(HS)
      CW2=COS(HD)
      SW1=SIN(HS)
      SW2=SIN(HD)
      T=SQRT(DIJ2+HS**2)
      UZ=T-HS
      VZ=T+HS
      T=SQRT(DIJ2+HD**2)
      UZP=T-HD
      VZP=T+HD
      T=SQRT(DIJ2+EIL**2)
      U1=T-EIL
      V1=T+EIL
      T=SQRT(DIJ2+HIJ**2)
      U2=T-HIJ
      V2=T+HIJ
      ZIJOT=((CSZ1(UZ)-CSZ1(U1)-CSZ1(U2))*CMPLX(CW1,-SW1)+(CSZ1(VZ)-CSZ1
     1(V1)-CSZ1(V2))*CMPLX(CW1,SW1)+(CSZ1(UZP)-CSZ1(U1)-CSZ1(V2))*CMPLX(
     2CW2,-SW2)+(CSZ1(VZP)-CSZ1(V1)-CSZ1(U2))*CMPLX(CW2,SW2)+2.*CSZ1(DIJ
     3)*(CW1+CW2))*60.0/(CW2-CW1)
      RETURN
      END
      SUBROUTINE CMPINV (A,B,C,D,N)
      DIMENSION A(16,16), B(16,16), C(16,16), D(16,16)
      COMMON /PON/ INDEX(16,2),IPIVOT(16),PIVOT(16)
      M=N
      L=1
1     DO 2 I=1,M
      DO 2 J=1,M
2     D(I,J)=-A(I,J)
      CALL MATINV (D,M)
      DO 3 K=1,M
      IF (IPIVOT(K).NE.1) GO TO 6
3     CONTINUE
      CALL SQMULT (B,D,D,M)
      CALL SQMULT (D,B,C,M)
      DO 4 I1=1,M
      DO 4 J1=1,M
4     C(I1,J1)=A(I1,J1)-C(I1,J1)
      CALL MATINV (C,M)
      DO 5 K1=1,M
      IF (IPIVOT(K1).NE.1) GO TO 10
5     CONTINUE
      CALL SQMULT (C,D,D,M)
      GO TO (10,8), L
6     DO 7 I2=1,M
      DO 7 J2=1,M
      TEMP=A(I2,J2)
      A(I2,J2)=B(I2,J2)
7     B(I2,J2)=TEMP
      IF (L.EQ.2) GO TO 10
      L=2
      GO TO 1
8     DO 9 I3=1,M
      DO 9 J3=1,M
      TEMP=A(I3,J3)
      A(I3,J3)=B(I3,J3)
      B(I3,J3)=TEMP
      TEMP=-C(I3,J3)
      C(I3,J3)=-D(I3,J3)
9     D(I3,J3)=TEMP
10    RETURN
      END
C     COTAN FUNCTION
      FUNCTION COTAN(X)
      COTAN=COS(X)/SIN(X)
      RETURN
      END
      SUBROUTINE MATINV (A,N)
      DIMENSION A(16,16)
      COMMON /PON/ INDEX(16,2),IPIVOT(16),PIVOT(16)
      DETERM=1.0
      DO 1 J=1,N
1     IPIVOT(J)=0
      DO 9 I=1,N
C     SEARCH FOR PIVOTAL ELEMENT.
      TEMP=0.0
      DO 4 J1=1,N
      IF (IPIVOT(J1).EQ.1) GO TO 4
      DO 3 K=1,N
      IF (IPIVOT(K)-1) 2,3,12
2     IF (ABS(TEMP).GE.ABS(A(J1,K))) GO TO 3
      IROW=J1
      ICOLUM=K
      TEMP=A(J1,K)
3     CONTINUE
4     CONTINUE
      IPIVOT(ICOLUM)=IPIVOT(ICOLUM)+1
C     INTERCHANGE ROWS TO PUT PIVOTAL ELEMENT ON DIAGONAL.
      IF (IROW.EQ.ICOLUM) GO TO 6
      DETERM=-DETERM
      DO 5 L=1,N
      TEMP=A(IROW,L)
      A(IROW,L)=A(ICOLUM,L)
5     A(ICOLUM,L)=TEMP
6     INDEX(I,1)=IROW
      INDEX(I,2)=ICOLUM
      PIVOT(I)=A(ICOLUM,ICOLUM)
      DETERM=DETERM*PIVOT(I)
C     DIVIDE PIVOTAL ROW BY PIVOTAL ELEMENT.
      A(ICOLUM,ICOLUM)=1.0
      DO 7 L1=1,N
7     A(ICOLUM,L1)=A(ICOLUM,L1)/PIVOT(I)
C     REDUCE NON-PIVOTAL ROWS.
      DO 9 I1=1,N
      IF (I1.EQ.ICOLUM) GO TO 9
      TEMP=A(I1,ICOLUM)
      A(I1,ICOLUM)=0.0
      DO 8 L2=1,N
8     A(I1,L2)=A(I1,L2)-A(ICOLUM,L2)*TEMP
9     CONTINUE
C     INTERCHANGE COLUMNS.
      DO 11 I2=1,N
      LL=N+1-I2
      IF (INDEX(LL,1).EQ.INDEX(LL,2)) GO TO 11
      IROW=INDEX(LL,1)
      ICOLUM=INDEX(LL,2)
      DO 10 K1=1,N
      TEMP=A(K1,IROW)
      A(K1,IROW)=A(K1,ICOLUM)
10    A(K1,ICOLUM)=TEMP
11    CONTINUE
12    RETURN
      END
      SUBROUTINE SQMULT (A,B,C,N)
C     SQUARE MATRIX MULTIPLICATION
      DIMENSION A(16,16), B(16,16), C(16,16)
      COMMON /PON/ INDEX(16,2),IPIVOT(16),PIVOT(16)
      DO 2 J=1,N
      DO 1 K=1,N
1     PIVOT(K)=B(K,J)
      DO 2 I=1,N
      C(I,J)=0.0
      DO 2 L=1,N
2     C(I,J)=C(I,J)+A(I,L)*PIVOT(L)
      RETURN
      END
                                                                                                          