#include <stdio.h>
#include <string.h>
#include <readline/readline.h>
#include <readline/history.h>

#ifdef STD_HEADERS
#include <stdlib.h>
#else
extern char *getenv ();
extern char *malloc ();
#endif

extern int use_hist_file;

char *histfile;

static char *rl_gets_line = (char *)NULL;

extern void free ();

char *
rl_gets ()
{
  if (rl_gets_line != (char *)NULL)
    free (rl_gets_line);

  rl_gets_line = readline ("ftp> ");

  if (rl_gets_line && *rl_gets_line)
    add_history (rl_gets_line);

  return (rl_gets_line);
}

void
setup_history (read_hist)
	int read_hist;
{
  register char *tmp;
  register char *home;
  register char *maxhistenv;
  int maxhist;

  histfile = getenv ("FTPHISTFILE");
  if (histfile != NULL)
    {
      if (read_hist)
        (void) read_history (histfile);
    }
  else
    {
      home = getenv ("HOME");
      if (home != NULL)
	{
	  histfile = malloc (strlen (home) + 14);
	  strcpy (histfile, home);
	  strcat (histfile, "/.ftp_history");
          if (read_hist)
            (void) read_history (histfile);
	}
    }

  maxhist = 100;
  tmp = getenv ("FTPHISTSIZE");
  if (tmp != NULL)
    {
      maxhistenv = malloc (strlen (tmp) + 1);
      strcpy (maxhistenv, tmp);
      if (sscanf (maxhistenv, "%d", &maxhist) == -1)
	maxhist = 100;
    }
  stifle_history (maxhist);
}

void
clean_up_and_exit (status)
     int status;
{
  extern char *histfile;

  if (use_hist_file)
    write_history (histfile);

  exit (status);
}
