/* Note:  This code was extracted from the npasswd distribution by       */
/*        John W. Eaton (jwe@emx.utexas.edu)                             */
/*                                                                       */
/* --------------------------------------------------------------------  */
/*                                                                       */
/*                         Author: Clyde Hoover                          */
/*                          Computation Center                           */
/*                   The University of Texas at Austin                   */
/*                          Austin, Texas 78712                          */
/*                         clyde@emx.utexas.edu                          */
/*                   uunet!cs.utexas.edu!ut-emx!clyde                    */
/*                                                                       */
/*This code may be distributed freely, provided this notice is retained. */
/*                                                                       */
/* --------------------------------------------------------------------  */

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <strings.h>

#if	defined(SYSV)
#	include <termio.h>		/* Vanilla SV termio */
	struct termio saved_tty_mode;
#endif

#if	defined(SUNOS4)
#	include <sys/termios.h>		/* SUN OS 4.0 termio */
#define	TCGETA	TCGETS
#define	TCSETA	TCSETS
	struct termios saved_tty_mode;
#endif

#if	!defined(SUNOS4) && !defined(SYSV)
#	include <sgtty.h>		/* BSD tty */
	struct sgttyb saved_tty_mode;
	int	saved_local_flags;
#endif

/*
 *	The system getpass() throws away all but the first 8 characters
 *	of a password string.  If this isn't enough for you, use this
 *	routine instead.  This code assumes that stdin is the terminal.
 */
char	*
getpass(prompt)
char	*prompt;
{
#if	defined(SYSV)
	struct termio	saved,		/* Saved tty characteristics */
			noecho;		/* No-echo tty characteristics */
	char	*strchr();
#else
#if	defined(SUNOS4)
	struct termios	saved,		/* Saved tty characteristics */
			noecho;		/* No-echo tty characteristics */
#else
	struct sgttyb	saved,		/* Saved tty characteristics */
			noecho;		/* No-echo tty characteristics */
#endif
#endif
	static char	ib[64];		/* Input buffer */
	char	*rc;			/* Temp */

#if	defined(SYSV) || defined(SUNOS4)
	(void) ioctl(0, TCGETA, &saved);
	noecho = saved;
	noecho.c_lflag &= ~ECHO;
	(void) ioctl(0, TCSETA, &noecho);
#else
	(void) ioctl(0, TIOCGETP, &saved);
	noecho = saved;
	noecho.sg_flags &= ~ECHO;
	(void) ioctl(0, TIOCSETP, &noecho);
#endif
	fprintf(stderr, "%s", prompt);
	fflush(stderr);
	rc = fgets(ib, sizeof(ib), stdin);
	putc('\n', stderr);
	fflush(stderr);

#if	defined(SYSV) || defined(SUNOS4)
	(void) ioctl(0, TCSETA, &saved);
#else
	(void) ioctl(0, TIOCSETP, &saved);
#endif
	if (rc == NULL)
		return(NULL);
	if (rc = index(ib, '\n'))
		*rc = 0;
	return(ib);
}
