/* system-dependent definitions for ftp, extracted from the
   system-dependent definitions for the fileutils programs.
   Copyright (C) 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Include sys/types.h and sys/stat.h before this file.  */

/* Filesystem device blocksize. */
#ifndef DEV_BSIZE
#ifdef BSIZE
#define DEV_BSIZE BSIZE
#else
#define DEV_BSIZE 512
#endif
#endif

/* Extract data from a `struct stat'.
   ST_BLKSIZE: Optimal I/O blocksize for the file.
   ST_NBLOCKS: Number of blocks in the file (including indirect blocks). */
#ifdef _POSIX_SOURCE
#define ST_BLKSIZE(statbuf) DEV_BSIZE
#define ST_NBLOCKS(statbuf) (((statbuf).st_size + DEV_BSIZE - 1) / DEV_BSIZE)
#else
#ifdef STBLOCKS_MISSING
#define ST_BLKSIZE(statbuf) DEV_BSIZE
#define ST_NBLOCKS(statbuf) (st_blocks ((statbuf).st_size))
#else
/* Some systems, like Sequents, return st_blksize of 0 on pipes. */
#define ST_BLKSIZE(statbuf) ((statbuf).st_blksize > 0 \
			     ? (statbuf).st_blksize : DEV_BSIZE)
#define ST_NBLOCKS(statbuf) ((statbuf).st_blocks)
#endif
#endif

/* Convert B blocks of DEV_BSIZE bytes
   to kilobytes if K is nonzero, otherwise to blocks of 512 bytes. */

#if DEV_BSIZE == 512
#define convert_blocks(b, k) ((k) ? ((b) + 1) / 2 : (b))
#else
#if DEV_BSIZE == 1024
#define convert_blocks(b, k) ((k) ? (b) : (b) * 2)
#else
#define convert_blocks(b, k) ((k) \
			      ? ((b) * DEV_BSIZE + 1023) / 1024 \
			      : ((b) * DEV_BSIZE + 511) / 512)
#endif
#endif
