/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *	May, 1991							*
 *									*
 *	Copyright (c) 1991 University of Southern California.		*
 *	All rights reserved.						*
 *									*
 *	Redistribution and use in source and binary forms are permitted	*
 * 	provided that the above copyright notice and this paragraph are	*
 * 	duplicated in all such forms and that any documentation,	*
 * 	advertising materials, and other materials related to such	*
 * 	distribution and use acknowledge that the software was		*
 *	developed by the University of Southern California, Information	*
 *	Sciences Institute.  The name of the University may not be used *
 *	to endorse or promote products derived from this software 	*
 * 	without specific prior written permission.			*
 *	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR	*
 * 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
 * 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*
 * 	PURPOSE.							*
 *									*
 ************************************************************************/

/* tool_lib.c */

#include <ctype.h>
#include <stdio.h>

#include <suntool/sunview.h>
    /* includes <sunwindow/window_hs.h>, which includes <sys/time.h> */
#include <suntool/panel.h>
#include <suntool/textsw.h>

#include <sys/param.h>

#include "bftp.h"

extern Frame tool_frame;

Menu 	src_file_menu,
	save_menu,
	port_menu,
	host_menu,
	dir_menu,
	login_menu,
	passw_menu;

char 	def_dir[100],
	def_passwd[80];
	
boolean user_set_mult = FALSE;

extern void 
  	copy_screen(),
	show_dest_file();
extern char
	bftp_dir[MAXPATHLEN],
	def_hostname[80],
	def_user[20],
	*malloc(),
	**get_save_files();
extern boolean 
  	empty_str();

extern struct hint_record {
  Panel_item *field_item, *msg_item;
  void (*event_proc)();
} hint_list[];

extern struct help_record {
   union u_tag {
     Panel_item *ip;
     char	*cp;
     } uval;
   } helplist[1000];

#define set_ptr(item) helplist[i++].uval.ip = &item
#define set_str(str) helplist[i++].uval.cp = str
#define last_str() helplist[i++].uval.cp = NULL

Window h_frame;
   
static void
delete_help(window, event, arg)
   Window window;
   Event *event;
   caddr_t arg;
{
   if (event_id(event) == MS_MIDDLE && event_is_up(event)) {
      window_set(h_frame,
      		WIN_GRAB_ALL_INPUT,     FALSE,
		0);
      window_destroy(h_frame);
      }
   else
      window_default_event_proc(window, event, arg);
}

static void
help_proc(item, event)
   Panel_item item;
   Event *event;
{
   int i = 0, j = 0;
   Window h_panel;

   if (event_id(event) == MS_MIDDLE && event_is_down(event))
      while (helplist[i].uval.ip) {
	 if (item == *helplist[i++].uval.ip) {
	    if (h_frame = window_create(tool_frame, FRAME,
	       		FRAME_SHOW_LABEL,	FALSE,
			FRAME_NO_CONFIRM, 	TRUE,
			WIN_EVENT_PROC,         delete_help,
		        WIN_X, 			0,
		        WIN_Y, 			0,
			0)
		) {
	       h_panel = window_create(h_frame, PANEL, 0);
	       j = 0;
	       while (helplist[i].uval.cp) {
		  panel_create_item(h_panel, PANEL_MESSAGE, 
		        PANEL_LABEL_X,		ATTR_COL(0),
		        PANEL_LABEL_Y,          ATTR_ROW(j++),
	        	PANEL_LABEL_STRING, 	helplist[i++].uval.cp, 
			0);
		  }
	       window_fit(h_panel);
	       window_fit(h_frame);
	       window_set(h_frame, 
		  	WIN_SHOW, 		TRUE, 
		  	WIN_GRAB_ALL_INPUT,     TRUE,
		  	0);
	       }
	    break;
	    }
	 else
	    while (helplist[i].uval.cp)
	      i++;
	 i++;
         }
}

/* Event Procs */

void
dummy_event_proc(item, event)
   Panel_item item;
   Event *event;
{
   help_proc(item, event);	
   panel_default_handle_event(item, event);
}

void
no_spaces(item, event)
   Panel_item item;
   Event *event;
{
   help_proc(item, event);
   if (event_is_ascii(event) && ' ' == (char)event_id(event))
      window_bell((Panel)panel_get(item, PANEL_PARENT_PANEL));
   else
      panel_default_handle_event(item, event);
}

void
make_bold(item, event)
   Panel_item item;
   Event *event;
{
   help_proc(item, event);
   if (event_is_ascii(event))
      if (' ' == (char)event_id(event))
	 window_bell((Panel)panel_get(item, PANEL_PARENT_PANEL));
      else  {
	 panel_default_handle_event(item, event);
	 panel_set(item, PANEL_LABEL_BOLD,
      		(strlen((char *)panel_get(item,PANEL_VALUE)))?TRUE:FALSE,
		0);
         }
   else
      panel_default_handle_event(item, event);
}

void
check_decimal(item, event)
   Panel_item item;
   Event *event;
{
   help_proc(item, event);
   if (event_is_ascii(event) &&
       ! isdigit((char)event_id(event)) &&
       ! iscntrl((char)event_id(event)) )
      window_bell((Panel)panel_get(item, PANEL_PARENT_PANEL));
   else
      panel_default_handle_event(item, event);
}

/* Menu containing names of save files -- MENU_GEN_PROC */

static Menu
save_file_proc(m, operation)
   Menu m;
   Menu_generate operation;
{
   char **list;
	
   switch(operation) {
      case MENU_DISPLAY:
         list = get_save_files();
         while (*list)
	    menu_set(m, MENU_STRING_ITEM, *list++, 0, 0);
	 break;

      case MENU_DISPLAY_DONE:
      case MENU_NOTIFY:
      case MENU_NOTIFY_DONE:
	 break;
      }
   return(m);
}

/* PANEL_EVENT_PROC */

static void
display_save_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;

   help_proc(item, event);
   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(save_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0)))
         panel_set_value(item, (char *)menu_get(mi, MENU_STRING));
      menu_destroy(save_menu);
      save_menu = menu_create(MENU_GEN_PROC,	save_file_proc,
	 		      MENU_NOTIFY_PROC, menu_return_item,
			      0);
      }
   else
      if (event_is_ascii(event) &&
          ('-' != (char)event_id(event)) &&
	  ('.' != (char)event_id(event)) &&
	  (ispunct((char)event_id(event)) || (' ' == (char)event_id(event))))
         window_bell((Panel)panel_get(item, PANEL_PARENT_PANEL));
      else
         panel_default_handle_event(item, event);
}

/* PANEL_EVENT_PROC */

static void
display_host_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(host_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0)))
         panel_set_value(item, (char *)menu_get(mi, MENU_STRING));
      }
   else
      no_spaces(item, event);
}

void
display_login_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(login_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL),
			event, 0)))
         panel_set_value(item, (char *)menu_get(mi, MENU_STRING));
      }
   else
      no_spaces(item, event);
}

void
display_passw_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;
   char *cp;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(passw_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0))) {
	 cp = (char *)menu_get(mi, MENU_STRING);
         panel_set(item,
	 	PANEL_VALUE, 		cp,
		PANEL_LABEL_BOLD,	(strlen(cp)?TRUE:FALSE),
		0);
	 }
      }
   else
      make_bold(item, event);
}

void
display_dir_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;
   char *cp;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(dir_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0))) {
	 cp = (char *)menu_get(mi, MENU_STRING);
         panel_set(item,
	 	PANEL_VALUE, 		cp,
		0);
	 }
      }
   else
      no_spaces(item, event);
}

void
display_port_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
      	  (mi = (Menu_item *)menu_show(port_menu, 
	  		(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0))) {
         panel_set(item,
	 	PANEL_VALUE, 		(char *)menu_get(mi, MENU_STRING),
		0);
	 }
      }
   else
      check_decimal(item, event);
}

void
hint_event_proc(item, event)
     Panel_item item;
     Event *event;
{
   int i;
   boolean match = FALSE;

   if (event_is_ascii(event) || event_is_button(event)) {
      for (i=0; hint_list[i].field_item ; i++)
	 /* find the matching entry */
	 if (item == *hint_list[i].field_item) {
	    /* make the hint disappear */
	    panel_set(*hint_list[i].msg_item, PANEL_SHOW_ITEM, FALSE, 0);
	    /* perform the procedure found in the hint_list structure */
	    (*hint_list[i].event_proc)(item, event);
	    /* if the field is empty, put the hint back */
	    if (!strlen((char *)panel_get(item, PANEL_VALUE)))
	       panel_set(*hint_list[i].msg_item, PANEL_SHOW_ITEM, TRUE, 0);
	    break;
	    }
      }
   else
      panel_default_handle_event(item, event);
} /* hint_event_proc */

extern Panel_item sFile_item;

/* Menu containing source file name; used to fill in destination file. */

static Menu
src_file_proc(m, operation)
   Menu m;
   Menu_generate operation;
{
   char *cp, *sfp;

   switch(operation) {
      case MENU_DISPLAY:
      	 if (!empty_str(sfp = (char *)panel_get(sFile_item, PANEL_VALUE))) {
	    cp = malloc(strlen(sfp));
	    strcpy(cp, sfp);
	    menu_set(m, MENU_STRING_ITEM, cp, 0, 0);
	    }
	 break;

      case MENU_DISPLAY_DONE:
      case MENU_NOTIFY:
      case MENU_NOTIFY_DONE:
	 break;
      }
   return(m);
} /* src_file_proc */

void
display_sfile_menu(item, event)
   Panel_item item;
   Event *event;
{
   Menu_item *mi;

   if (event_id(event) == MS_RIGHT && event_is_down(event)) {
      if (NULL !=
	  (mi = (Menu_item *)menu_show(src_file_menu, 
			(Panel)panel_get(item, PANEL_PARENT_PANEL), 
			event, 0)))
	 panel_set_value(item, (char *)menu_get(mi, MENU_STRING));
      menu_destroy(src_file_menu);
      src_file_menu = menu_create(MENU_GEN_PROC,	src_file_proc,
	 		 	  MENU_NOTIFY_PROC, 	menu_return_item,
	 		 	  0);
      }
   else
      no_spaces(item, event);
} /* display_sfile_menu */

void
init_port_menu()
{
   port_menu = menu_create(
      		MENU_STRINGS, 		"21", 0,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

void
init_login_menu()
{
   login_menu = menu_create(
   		MENU_STRINGS, 		def_user, "anonymous", 0,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

void
init_dir_menu()
{
   dir_menu = menu_create(
      		MENU_STRINGS, 		def_dir, 0,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

void
init_passw_menu()
{
   passw_menu = menu_create(
      		MENU_STRINGS, 		"guest", 0,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

void
init_src_file_menu()
{
   src_file_menu = menu_create(
   		MENU_GEN_PROC,		src_file_proc,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

static void
init_save_menu()
{
   save_menu = menu_create(
   		MENU_GEN_PROC,		save_file_proc,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
}

boolean
host_matches(h1, h2)
   char *h1, *h2;
{
   u_long addr1 = 0, addr2 = 0;

   if (strcmp(h1, h2)) {
      /* strings don't match */
      if (!empty_str(h1)) {
	 (void)resolve_name(h1, &addr1, 1);
	 if (!empty_str(h2))
	    (void)resolve_name(h2, &addr2, 1);
         }
      /* if either address is zero it doesn't match */
      if (!addr1 || !addr2 || (addr1 != addr2))
	 return(FALSE);
      }
   return(TRUE);
}

boolean
host_okay(h)
   char *h;
{
   u_long addr;
   char *cp;

   if (!empty_str(h) && resolve_name(h, &addr, 1)) {
      /* Add the host name/number to the menu. */
      if (host_menu && !menu_find(host_menu, MENU_STRING, h, 0)) {
	 cp = malloc(strlen(h));
	 strcpy(cp, h);
	 menu_set(host_menu, MENU_STRING_ITEM, cp, 0, 0);
         }
      return(TRUE);
      }
   else
     return(FALSE);
}


void
init_host_menu()
{
   FILE *listp;
   char filename[100], hostname[80];

   host_menu = menu_create(
      		MENU_STRINGS, 		def_hostname, 0,
		MENU_NOTIFY_PROC,	menu_return_item,
		0);
		
   /* Read in hosts for menu from file bftp.allhosts */
   sprintf(filename,"%smbftp.allhosts", bftp_dir);
   listp = fopen(filename, "r");
   if (listp == NULL) {
      sprintf(filename,"%sbftp.allhosts", bftp_dir);
      listp = fopen(filename, "r");
      }
   if (listp != NULL) {
      while (fgets(hostname, sizeof(hostname), listp) != NULL) {
	 if (hostname[strlen(hostname)-1] == '\n')
	    hostname[strlen(hostname)-1]= '\0';
	 (void)host_okay(hostname);
	 }
      fclose(listp);
      }
}

int
find_errors(sw, src, dst, fil)
   Textsw sw;
   struct hostinfo *src, *dst;
   struct fileinfo *fil;
{
   int count = 0;
   char errstr[80];

#define print_sw(str)  (void)textsw_insert(sw, str, strlen(str));

   print_sw("Checking parameters...\n");

   /* check that host numbers are not zero */
   if (!host_okay(src->host)) {
      print_sw("    Error: Illegal source host number.\n");
      count++;
      }

   if ((fil->reqtype != DFILE) && !host_okay(dst->host)) {
      print_sw("    Error: Illegal destination host number.\n");
      count++;
      }

   if (empty_str(src->user)) {
      print_sw("    Error: Source user name must be specified.\n");
      count++;
      }
   if ((fil->reqtype != DFILE) && empty_str(dst->user)) {
      print_sw("    Error: Destination user name must be specified.\n");
      count++;
      }
   if (empty_str(src->file)) {
      print_sw("    Error: Source file name must be specified.\n");
      count++;
      }
   if (!fil->multflag && (fil->reqtype != DFILE) && 
   	empty_str(dst->file)) {
      count++;
      print_sw("    Error: Destination file name must be specified.\n");
      }

   if (count) {
      sprintf(errstr,"    Error count = %d\n",count);
      print_sw(errstr);
      }

   return(count);
} /* find_errors */

int type_choice(value)
   int value;
{  return((value==ASCII)? 0:
   	   (value==EBCDIC)? 1:
	   (value==IMAGE)? 2:
	   (value==LOCAL)? 3: 0);
}
int type_value(choice)
   int choice;
{  return((choice==0)? ASCII:
   	   (choice==1)? EBCDIC:
	   (choice==2)? IMAGE: LOCAL);
}
int form_choice(value)
   int value;
{
   return((value==NONPRINT)? 0:
   	   (value==TELNET)? 1:
	   (value==CCNTRL)? 2: 0);
}
int form_value(choice)
   int choice;
{  return((choice==0)? NONPRINT:
   	   (choice==1)? TELNET: CCNTRL);
}
int stru_choice(value)
   char value;
{  return((value=='F')? 0:
   	   (value=='R')? 1:
	   (value=='P')? 2: 0);
}
char stru_value(choice)
   int choice;
{  return((choice==0)? 'F':
	  (choice==1)? 'R': 'P');
}
int mode_choice(value)
   char value;
{  return((value=='S')? 0:
   	   (value=='B')? 1:
	   (value=='C')? 2: 0);
}
char mode_value(choice)
   int choice;
{  return((choice==0)? 'S':
   	   (choice==1)? 'B': 'C');
}
int op_choice(value)
   int value;
{  return((value==COPY)? 0:
   	   (value==MOVE)? 1:
	   (value==DFILE)? 2: 0);
}
int op_value(choice)
   int choice;
{  return((choice==0)? COPY: (choice==1)? MOVE: DFILE); }

Panel_item
	type_item, format_item, byteSize_item, stru_item, 
  	mode_item, stou_item, append_item, multiple_item;

int
init_param_help(index)
   int index;
{
   int i = index;

   set_ptr(stru_item);
   set_str("Structure may be");
   set_str("  'file', which is used for most transfers,");
   set_str("  'record', or");
   set_str("  'page', for TENEX binary files.");
   last_str();
  
   set_ptr(mode_item);
   set_str("Transfer Mode may be 'stream', 'block', or 'compress'.");
   set_str("  The default is 'stream'.");
   last_str();

   set_ptr(type_item);
   set_str("Type may be");
   set_str("  'ascii',  which is used to transfer most text files,");
   set_str("  'ebcdic', for text files on some IBM systems,");
   set_str("  'image',  for most binary files, or");
   set_str("  'local'.  Type 'local' with ByteSize '8' is");
   set_str("            equivalent to the BSD 'tenex' command.");
   last_str();

   set_ptr(format_item);
   set_str("Format, which is specified in conjunction with the 'ascii'");
   set_str("  and the 'ebcdic' types, can be 'nonprint', 'telnet', or ");
   set_str(" 'carriage-control'.  The default is 'nonprint'.");
   last_str();
	   
   set_ptr(byteSize_item);
   set_str("Byte size is specified in conjunction with the 'local' type.");
   set_str("  The default is 8.");
   last_str();
  
   set_ptr(multiple_item);
   set_str("The Multiple flag specifies that the wildcard character");
   set_str("  '*' will be used to match multiple source file names.");
   set_str("  The default is FALSE.");
   last_str();

   set_ptr(append_item);
   set_str("The Append flag specifies that the file will be appended");
   set_str("  to an existing file, rather than copied to a new file,");
   set_str("  on the destination host.  The default is FALSE.");
   last_str();

   set_ptr(stou_item);
   set_str("The UniqueFileName flag specifies that the STOU command");
   set_str("  will be used to store the file.  If this command is ");
   set_str("  supported by the receiving host, a unique file name");
   set_str("  will be created.  The default is FALSE.");
   last_str();

   return(i);
} /* init_param_help */

void
copy_fileparams(fil)
   struct fileinfo *fil;
{
   int type, form, bytesiz;

   /* fil->filetype */
   switch (type = type_value((int)panel_get(type_item, PANEL_VALUE))) {
      case ASCII:
      case EBCDIC:
         form = form_value((int)panel_get(format_item, PANEL_VALUE));
	 sprintf(fil->filetype,"%c %c",
	 	(type==ASCII)?'A':'E',
	 	(form==NONPRINT)?'N':(form==TELNET)?'T':'C');
	 break;
      case LOCAL:
	 bytesiz =atoi((char *)panel_get(byteSize_item, PANEL_VALUE));
	 sprintf(fil->filetype, "L %d", bytesiz);
	 break;
      case IMAGE:
	 strcpy(fil->filetype, "I");
	 break;
      };
   fil->stru = stru_value((int)panel_get(stru_item, PANEL_VALUE));
   fil->mode = mode_value((int)panel_get(mode_item, PANEL_VALUE));
   fil->reqtype = COPY;
   fil->creation =
      (((int)panel_get(stou_item, PANEL_VALUE))?
      	STOU:
       ((int)panel_get(append_item, PANEL_VALUE))?
        APPE: STOR);
   fil->multflag =
      ((int)panel_get(multiple_item, PANEL_VALUE))? TRUE: FALSE;
} /* copy_fileparams */

/* Notify Procs for Parameters Subwindow */

void
adjust_dest(mult_value)
{
   if (mult_value) {
      if (!(int)panel_get(append_item, PANEL_VALUE))
	 show_dest_file(FALSE);
      }
   else
      show_dest_file(TRUE);
}   

void
multiple(item, value, event)
   Panel_item item;
   int value;
   Event *event;
{
   adjust_dest(value);
   user_set_mult = value;
}

void
stou_off(item, value, event)
   Panel_item item;
   int value;
   Event *event;
{
   if (value) {
      panel_set(stou_item, PANEL_VALUE, FALSE, 0);
      show_dest_file(TRUE);
      }
   else
      if ((int)panel_get(multiple_item, PANEL_VALUE))
	 show_dest_file(FALSE);
}

void
append_off(item, value, event)
   Panel_item item;
   int value;
   Event *event;
{
   if (value) {
      panel_set(append_item, PANEL_VALUE, FALSE,0);
      if ((int)panel_get(multiple_item, PANEL_VALUE))
	 show_dest_file(FALSE);
      }
}

void
page_proc(item, value, event)
   Panel_item item;
   int value;
   Event *event;
{
   if (value == stru_choice('P')) {
      panel_set(format_item, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(mode_item, PANEL_VALUE, mode_choice('S'), 0);
      panel_set(type_item, 
		PANEL_SHOW_ITEM, TRUE, 
		PANEL_VALUE, type_choice(LOCAL), 
		0);
      panel_set(byteSize_item, 
		PANEL_SHOW_ITEM, TRUE,
		PANEL_VALUE, "36", 
		0);
      }
}

void
format_proc(item, value, event)
   Panel_item item;
   int value;
   Event *event;
{
   switch (value) {
      case 0: /* ascii */
      case 1: /* ebcdic */
         /* ascii, ebcdic -- Format: nonprint, telnet, carriage-control */
         panel_set(byteSize_item, PANEL_SHOW_ITEM, FALSE, 0);
         panel_set(format_item, PANEL_SHOW_ITEM, TRUE, 0);
         break;
      case 2: /* image */
         /* image -- nothing else */
         panel_set(format_item, PANEL_SHOW_ITEM, FALSE, 0);
	 panel_set(byteSize_item, PANEL_SHOW_ITEM, FALSE, 0);
         break;
      case 3: /* local */
         /* local -- ByteSize: <integer> */	
         panel_set(format_item, PANEL_SHOW_ITEM, FALSE, 0);
	 panel_set(byteSize_item, PANEL_SHOW_ITEM, TRUE, 0);
         break;
      }
}

Attr_avlist 
	stru_attr,
  	mode_attr,
  	type_attr,
	form_attr,
	byte_attr,
	mult_attr,
	app_attr,
	stou_attr,

  	host_attr,
	port_attr,
	login_attr,
	pass_attr,
	dir_attr,
	file_attr;

void
init_attr_lists()
{
   stru_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Structure:",
		PANEL_CHOICE_STRINGS, 	"file", "record", "page", 0,
		PANEL_VALUE,		stru_choice('F'),
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	page_proc,
		0);
   mode_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Mode:",
		PANEL_CHOICE_STRINGS, 	"stream", "block", "compress", 0,
		PANEL_VALUE,		mode_choice('S'),
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
   type_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Type:",
		PANEL_CHOICE_STRINGS, 	"ascii","ebcdic","image","local",0,
		PANEL_VALUE,		type_choice(ASCII),
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	format_proc,
		0);
   form_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Format:",
		PANEL_CHOICE_STRINGS, 	"nonprint", "telnet",
					"carriage-control",0,
		PANEL_VALUE,		form_choice(NONPRINT),
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
   byte_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"ByteSize:",
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE,		"8",
		PANEL_SHOW_ITEM,	FALSE,
		PANEL_EVENT_PROC,	check_decimal,
		0);
   mult_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Multiple:",
		PANEL_CHOICE_STRINGS, 	"FALSE", "TRUE", 0,
		PANEL_VALUE,		0,
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      multiple,
		0);
   app_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"AppendFile:",
		PANEL_CHOICE_STRINGS, 	"FALSE", "TRUE", 0,
		PANEL_VALUE,		0,
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	stou_off,
		0);
   stou_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"UniqueFileName:",
		PANEL_CHOICE_STRINGS, 	"FALSE", "TRUE", 0,
		PANEL_VALUE,		0,
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	append_off,
		0);

   host_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Host:",
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_EVENT_PROC,	display_host_menu,
		0);
   port_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Port:",
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE,		"21",
		PANEL_EVENT_PROC,	display_port_menu,
		0);
   login_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Login:",
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_EVENT_PROC,	display_login_menu,
		0);
   pass_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Pass:",
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_MASK_CHAR,	' ',
		PANEL_EVENT_PROC,	display_passw_menu,
		0);
   dir_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"Dir: ",
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_EVENT_PROC,	no_spaces,
		0);
   file_attr = attr_create_list(
   		PANEL_LABEL_STRING,	"File:",
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_EVENT_PROC,	no_spaces,
		0);
}

/* These procedures handle the LoadReq, StoreReq, and PurgeReq commands. */

Panel_item request_item, quit_item, load_item, store_item, purge_item, msg_item;

static int rFrame_X, rFrame_Y;
static Frame rFrame;
extern void update_screen();

int
init_req_help(index)
   int index;
{
   int i = index;

   set_ptr(load_item);
   set_str("LoadReq is used to read in a request file as the current request.");
   last_str();

   set_ptr(store_item);
   set_str("StoreReq is used to save a request in a file.");
   last_str();

   set_ptr(purge_item);
   set_str("PurgeReq is used to delete a request file.");
   last_str();

   set_ptr(request_item);
   set_str("RequestName refers to a request saved in a file for future use.");
   set_str("  Depress the right mouse button for a list of requests that can be");
   set_str("  read in using the LoadReq command.  Type a new name before writing");
   set_str("  out a request using the StoreReq command.  Request-files are stored");
   set_str("  in the user-defined BFTP directory; for example, request 'name' might");
   set_str("  be saved as '/usr/login/.bftp/bftp-save.name'.");
   last_str();

   return(i);
} /* init_req_help */

/* Routines for confirmation of the deletion of save files. */

static void
yes_or_no(item, event)
   Panel_item item;
   Event *event;
{
   window_return(panel_get(item, PANEL_CLIENT_DATA));
}

static Frame
init_confirmer(message)
   char *message;
{
   Frame confirmer;
   Panel c_panel;

   confirmer = window_create(rFrame, FRAME,
   		FRAME_SHOW_LABEL, 	FALSE,
		WIN_X, 			0,
		WIN_Y, 			0,
		FRAME_NO_CONFIRM, 	TRUE,
		0);
   c_panel = window_create(confirmer, PANEL, 0);
   panel_create_item(c_panel, PANEL_MESSAGE, 
   	PANEL_LABEL_STRING, 	message, 
	0);
   panel_create_item(c_panel, PANEL_BUTTON,
   	PANEL_LABEL_X,		ATTR_COL(0),
	PANEL_LABEL_Y,		ATTR_ROW(1),
   	PANEL_LABEL_IMAGE, panel_button_image(c_panel, "YES", 3, 0),
	PANEL_CLIENT_DATA, 1,
	PANEL_NOTIFY_PROC, yes_or_no,
	0);
   panel_create_item(c_panel, PANEL_BUTTON,
   	PANEL_LABEL_IMAGE, panel_button_image(c_panel, "NO", 3, 0),
	PANEL_CLIENT_DATA, 0,
	PANEL_NOTIFY_PROC, yes_or_no,
	0);
   window_fit(c_panel);
   window_fit(confirmer);
   return(confirmer);
}

boolean
confirm_yes(message)
   char *message;
{
   Frame confirmer;
   int answer;

   confirmer = init_confirmer(message);
   answer = (int)window_loop(confirmer);
   window_destroy(confirmer);
   return(answer);
}

void
update_params(fil)
   struct fileinfo *fil;
{
   char temp[6];
   int type, form, bytesiz;

   panel_set(stru_item, PANEL_VALUE, stru_choice(fil->stru), 0);
   panel_set(mode_item, PANEL_VALUE, mode_choice(fil->mode), 0);
   panel_set(multiple_item, PANEL_VALUE, fil->multflag, 0);
   panel_set(stou_item, PANEL_VALUE, (fil->creation==STOU)?TRUE:FALSE, 0);
   panel_set(append_item, PANEL_VALUE, (fil->creation==APPE)?TRUE:FALSE,
	0);
   unpack_filetype(fil->filetype,&type, &form, &bytesiz);
   panel_set(type_item, PANEL_VALUE, type_choice(type), 0);
   sprintf(temp, "%d", bytesiz);
   panel_set(byteSize_item, PANEL_VALUE, temp,
   	PANEL_SHOW_ITEM, (type==LOCAL)?TRUE:FALSE,
	0);
   panel_set(format_item,
	PANEL_VALUE, form_choice(form),
	PANEL_SHOW_ITEM, ((type==ASCII)||(type==EBCDIC))?TRUE:FALSE,
	0);
} /* update_params */

/* These procedures handle the LoadReq, StoreReq, and PurgeReq commands. */

static void
load_proc(item, event)
   Panel_item item;
   Event *event;
{
   char temp[100], file[100], *cp;
   struct hostinfo src, dst;
   struct fileinfo fil;
   struct reqinfo req;

   if (empty_str(cp = (char *)panel_get(request_item,PANEL_VALUE)))
      panel_set(msg_item, 
		PANEL_LABEL_STRING, "Please specify a RequestName.", 
		0);
   else {
      sprintf(file, "%s.%s", SAVEPREFIX, cp);
      if (read_req(file, &req, &src, &dst, &fil, temp)) {
	 update_screen(&src, &dst, &fil);
	 panel_set(msg_item, 
		   PANEL_LABEL_STRING, "Request loaded.",
		   0);
	 }
      else
	 panel_set(msg_item, 
		   PANEL_LABEL_STRING, "Request file not found.",
		   0);
      }
}

static void
store_proc(item, event)
   Panel_item item;
   Event *event;
{
   char temp[100], file[100], *cp;
   struct hostinfo src, dst;
   struct reqinfo req;
   struct fileinfo fil;
   FILE *fp;

   if (empty_str(cp = (char *)panel_get(request_item,PANEL_VALUE)))
	 panel_set(msg_item, 
		   PANEL_LABEL_STRING, "Please specify a RequestName.",
		   0);
   else {
      sprintf(file, "%s.%s", SAVEPREFIX, cp);
      init_req(&req);

      copy_screen(&src, &dst, &fil);
      if ((fp = fopen(file,"r")) != NULL) {
	 fclose(fp);
	 sprintf(temp, "Okay to overwrite %s%s?", bftp_dir, file);
	 if (!confirm_yes(temp)) {
	    panel_set(msg_item, 
		      PANEL_LABEL_STRING, "Request file not stored.",
		      0);
	    return;
	    }
         }
      if (write_req(file, &req, &src, &dst, &fil, NULL))
	 panel_set(msg_item, 
		   PANEL_LABEL_STRING, "Request file stored.",
		   0);
      }
}

static void
purge_proc(item, event)
   Panel_item item;
   Event *event;
{
   char temp[100], file[100], *cp;
   FILE *fp;

   if (empty_str(cp = (char *)panel_get(request_item,PANEL_VALUE)))
      panel_set(msg_item, 
		PANEL_LABEL_STRING, "Please specify a RequestName.", 
		0);
   else {
      sprintf(file, "%s.%s", SAVEPREFIX, cp);
      if ((fp = fopen(file,"r")) != NULL) {
	 fclose(fp);
	 sprintf(temp, "Okay to delete %s%s?", bftp_dir, file);
	 if (!confirm_yes(temp)) {
	    panel_set(msg_item, 
		      PANEL_LABEL_STRING, "Request file not deleted.",
		      0);
	    return;
	    }
	 sprintf(temp, "rm %s 2>&1", file);
	 if (fp = popen(temp,"r")) {
	    if (fgets(temp, sizeof(temp), fp))
	       /* print any errors from rm */
	       panel_set(msg_item, 
			 PANEL_LABEL_STRING, temp,
			 0);
	    else
	       panel_set(msg_item, 
			 PANEL_LABEL_STRING, "Request file deleted.",
			 0);
	    pclose(fp);
            }
	 }
      else
	 panel_set(msg_item, 
		   PANEL_LABEL_STRING, "Request file not found.",
		   0);
      panel_set(request_item, PANEL_VALUE, "", 0);
      }
}

void
destroy_req_frame()
{
   if (rFrame) {
      menu_destroy(save_menu);
      window_destroy(rFrame);
      rFrame = NULL;
      }
}
      
void
init_rs_location(win_x,win_y)
   int win_x,win_y;
{
   rFrame_X = win_x;
   rFrame_Y = win_y;
}

static void
create_request_frame()
{
   Window params;
   int bwidth = 8,
   	row = 0;

   init_save_menu();

   rFrame = window_create(tool_frame, FRAME,
   		WIN_X, 			rFrame_X,
		WIN_Y, 			rFrame_Y,
   		FRAME_LABEL, 		"Request Storage",
		FRAME_SHOW_LABEL,	TRUE,
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC,        destroy_req_frame,
		0);
   params = window_create(rFrame, PANEL,
   		PANEL_ITEM_X_GAP,	15,
		0);
		
   quit_item = panel_create_item(params, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(params, "Quit", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      destroy_req_frame,
		0);
   load_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
			panel_button_image(params, "LoadReq", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	load_proc,
		0);
   store_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
			panel_button_image(params, "StoreReq", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	store_proc,
		0);
   purge_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
			panel_button_image(params, "PurgeReq", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	purge_proc,
		0);
   request_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		(ATTR_ROW(++row)+(row*8)),
   		PANEL_LABEL_STRING,	"RequestName:",
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_EVENT_PROC,	display_save_menu,
		0);
   msg_item =   panel_create_item(params, PANEL_MESSAGE, 
	        PANEL_LABEL_X,		ATTR_COL(0),
	        PANEL_LABEL_Y,          (ATTR_ROW(++row)+(row*8)),
        	PANEL_LABEL_STRING, 	" ", 
		0);
		
   window_fit(params);
   window_fit(rFrame);
   window_set(rFrame, WIN_SHOW, TRUE, 0);
} /* create_request_frame */

void
rStorage_proc(item, event)
   Panel_item item;
   Event *event; 
{
   if (rFrame) 
      destroy_req_frame();
   else
      create_request_frame();
}

/* Submit Popup Window */

extern void quit_popup(), do_submit();

Window popup_frame;
Textsw fts_sw;
Panel_item 
  quitSW_item, keyword_item, queue_item,
  interval_item, tries_item, startTime_item,
  mailbox_item;

int
init_submit_help(index)
   int index;
{
  int i = index;

   set_ptr(quitSW_item);
   set_str("Quit is used to exit this command, destroying this popup window.");
   last_str();

   set_ptr(queue_item);
   set_str("QueueRequest queues the current request, which will");
   set_str("  be first attempted at the specified start time.");
   last_str();

   set_ptr(mailbox_item);
   set_str("The Mailbox is the address where the report on the outcome of the");
   set_str("  transfer will be sent.  The basic format is 'user@domain',");
   set_str("   e.g. 'smith@isi.edu'.");
   last_str();

   set_ptr(keyword_item);
   set_str("The RequestKeyword, which is made up by the person submitting a");
   set_str("  request, is checked when the BFTP/BFTPTOOL 'Find' command is");
   set_str("  used to find a previous request and/or to cancel it.");
   set_str("  This field may be left blank.");
   last_str();

   set_ptr(interval_item);
   set_str("The Interval represents the starting interval for how often the");
   set_str("  transfer will be retried (in minutes).  The retry interval will");
   set_str("  be doubled on each successive retry until the maximum interval,");
   set_str("  4 hours, is reached.  The default starting interval is 15 minutes.");
   last_str();

   set_ptr(tries_item);
   set_str("The MaxTries parameter represents the maximum number of times that");
   set_str("  the BFTP server will attempt the transfer before giving up.");
   set_str("  The default is 5 times.");
   last_str();

   set_ptr(startTime_item);
   set_str("The StartTime is the time that the transfer will be attempted for");
   set_str("  the first time, for example '4 July 2001 4:01pm', or simply");
   set_str("  '16:01', meaning today at 4:01 PM.  The default is 'now', which");
   set_str("  is interpretted as the current date and time.");
   last_str();

   return(i);
} /* init_submit_help */

Notify_value
close_popup(frame, status)
   Frame frame;
   Destroy_status status;
{
   quit_popup();
}

void
make_submit_frame(req, t_width, t_lines, x_loc, y_loc)
   struct reqinfo *req;
   int t_width, t_lines, x_loc, y_loc;
{
   Window sw_panel;
   int row = 0;
   char temp[6];

   popup_frame = window_create(tool_frame, FRAME,
   		WIN_X, 			x_loc,
		WIN_Y, 			y_loc,
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC,	close_popup,
		0);
		
   sw_panel = window_create(popup_frame, PANEL,
   		0);
   quitSW_item = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "Quit", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      quit_popup,
		0);
   queue_item = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "QueueRequest", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      do_submit,
		0);

   startTime_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"StartTime:",
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_VALUE,		"now",
		0);
   sprintf(temp, "%d", req->interval);
   interval_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"Interval:",
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_EVENT_PROC,	check_decimal,
		PANEL_VALUE,		temp,
		0);
   panel_create_item(sw_panel, PANEL_MESSAGE,
   		PANEL_LABEL_STRING,     "minutes ",
		0);
   sprintf(temp, "%d", req->ntries);
   tries_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_STRING,	"MaxTries:",
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_EVENT_PROC,	check_decimal,
		PANEL_VALUE,		temp,
		0);
   mailbox_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"Mailbox:",
		PANEL_VALUE_DISPLAY_LENGTH, 40,
		PANEL_VALUE,		req->mailbox,
		PANEL_EVENT_PROC,	no_spaces,
		0);
   keyword_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"RequestKeyword:",
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_EVENT_PROC,	make_bold,
		PANEL_MASK_CHAR,	' ',
		PANEL_LABEL_BOLD,   	(strlen(req->rpasswd))?TRUE:FALSE,
		PANEL_VALUE,		req->rpasswd,
		0);
   window_fit(sw_panel);
   window_fit_width(popup_frame);

   fts_sw = window_create(popup_frame, TEXTSW,
			  WIN_WIDTH,		ATTR_COL(t_width),
			  WIN_HEIGHT,           ATTR_ROW(t_lines),
			  TEXTSW_IGNORE_LIMIT,  TEXTSW_INFINITY,
			  TEXTSW_READ_ONLY,     TRUE,
			  0);
   window_fit(fts_sw);
   window_fit(popup_frame);

   window_set(popup_frame, WIN_SHOW, TRUE, 0);
} /* make_submit_frame */

/* General Purpose Popup Window */

make_fts_frame(name, t_width, t_lines, x_loc, y_loc)
   char *name;
   int t_width, t_lines, x_loc, y_loc;
{
   Window sw_panel;

   popup_frame = window_create(tool_frame, FRAME,
   		WIN_X,			x_loc,
		WIN_Y,			y_loc,
   		FRAME_LABEL, 		name,
		FRAME_SHOW_LABEL,       TRUE,
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC,	close_popup,
		0);
		
   sw_panel = window_create(popup_frame, PANEL,
   		0);
   quitSW_item = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "Quit", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      quit_popup,
		0);
   window_fit(sw_panel);
   window_fit_width(popup_frame);

   fts_sw = window_create(popup_frame, TEXTSW,
		WIN_WIDTH,		ATTR_COL(t_width),
 		WIN_HEIGHT,		ATTR_ROW(t_lines),
		TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
   		TEXTSW_READ_ONLY, 	TRUE,
		0);
	
   window_fit(fts_sw);
   window_fit(popup_frame);

   window_set(popup_frame, WIN_SHOW, TRUE, 0);
} /* make_fts_frame */
