/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *	May, 1991							*
 *									*
 *	Copyright (c) 1991 University of Southern California.		*
 *	All rights reserved.						*
 *									*
 *	Redistribution and use in source and binary forms are permitted	*
 * 	provided that the above copyright notice and this paragraph are	*
 * 	duplicated in all such forms and that any documentation,	*
 * 	advertising materials, and other materials related to such	*
 * 	distribution and use acknowledge that the software was		*
 *	developed by the University of Southern California, Information	*
 *	Sciences Institute.  The name of the University may not be used *
 *	to endorse or promote products derived from this software 	*
 * 	without specific prior written permission.			*
 *	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR	*
 * 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
 * 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*
 * 	PURPOSE.							*
 *									*
 ************************************************************************/

 /* 
  *        File Transfer Service
  *
  *  The File Transfer Service provides background file transfer
  *  service for the Internet, by driving FTP Servers to cause the desired
  *  file transfer.  It queues requests and tries them periodically until
  *  they succeed.
  *
  */
  
#include "bftp.h"
		
extern int errno ;
extern char *sys_errlist[] ;
  
    /* Define server information structure 
     */
#define MAX_addrs 4

struct server_struct {
	struct hostinfo h;
	
	/* List of Internet addresses (unused entries are zero). */
#ifndef CRAY
	struct in_addr inetaddr[MAX_addrs] ;  
#else /* CRAY */
	/*
	 * unsigned longs are used everywhere else for internet addresses,
	 * so why do it differently here.  On a Cray, an array of longs
	 * and an array of 32-bit bitfields (in_addr) are not the same!
	 */
	u_long inetaddr[MAX_addrs];
#endif /* CRAY */

	short addrcurr ;        /* Index of current inaddr[] entry */
	short hostcount;	/* Number of inaddr entries */
	
	int   socket ;          /* Socket number */
	FILE *fpin ;            /* File Pointer for input side of Telnet conn*/
	FILE *fpout ;           /* File Pointer for output side */
	char dir_delim;
} ;

typedef  struct server_struct *SHandle;

	/*  Define result codes from various routines*/
#define OK  0

#define ERR_RETRY     -1 /* Failed, but can be tried later.  err_string will
                          * contain explanatory string concerning error.
                          */
#define ERR_PERMANENT -2 /* Failed and should not be retried. err_string will
                          * contain explanatory string concerning error.
                          */
#define ERR_SYSTEM    -3 /* Local system failure. err_string will
                          * contain explanatory string concerning error.
                          */

#define FTPTIMEOUT 60	   /* seconds */			  
#define MAXFTSTIME 14400   /* seconds (14400 = 4 hours) */
#define MAXINTERVAL 240    /* minutes (4 hours) = limit for backoff */

#define MAXerrstr 100      /* max length global err_string */
#define MAXreply  1024     /* max length of reply that is saved */

/*  Define FTP reply codes -- leading digits */
#define REP_TIMEOUT 0
#define REP_PRELIM 1
#define REP_OK     2
#define REP_NEEDMORE 3
#define REP_TEMPERR  4
#define REP_PERMERR  5
