/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *	May, 1991							*
 *									*
 *	Copyright (c) 1991 University of Southern California.		*
 *	All rights reserved.						*
 *									*
 *	Redistribution and use in source and binary forms are permitted	*
 * 	provided that the above copyright notice and this paragraph are	*
 * 	duplicated in all such forms and that any documentation,	*
 * 	advertising materials, and other materials related to such	*
 * 	distribution and use acknowledge that the software was		*
 *	developed by the University of Southern California, Information	*
 *	Sciences Institute.  The name of the University may not be used *
 *	to endorse or promote products derived from this software 	*
 * 	without specific prior written permission.			*
 *	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR	*
 * 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
 * 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*
 * 	PURPOSE.							*
 *									*
 ************************************************************************/

 /* 
  *        File Transfer Service (FTS) -- fts.c
  *
  *  The File Transfer Service provides background file transfer service
  *  for the Internet, by driving FTP Servers to cause the desired file
  *  transfer.  This module contains code to actually cause a single file
  *  transfer operation, using the FTP server-server model.  That is, it
  *  opens FTP control connections to two hosts A and B, logs into each 
  *  one and causes a transfer from one to the other.  It is invoked with
  *  the command "fx request-file".

  *  The "request-file" consists of the necessary parameters for the file
  *  transfer, in ASCII format, separated by commas.  Such a request file 
  *  may be created by the user interface module, "bftp", or "Background 
  *  File Transfer Program".
  *
  *  For each of the two server hosts, there will be a structure containing
  *  parameters relevant to each server.  The pointer to such a structure,
  *  called the server-handle, will be a parameter to many of the routines
  *  in this module.  Additional parameters, which apply to the file
  *  transfer as a whole, will also be defined at the beginning of this
  *  module.
  *  
  */

#include <stdio.h>
#include <errno.h>
#include <ctype.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef SYSV
#include <signal.h>
#endif /* SYSV */
#include <netinet/in.h>	
	
#include "fts.h"

extern int read_req();
extern int write_req();
extern int queue_req();
extern int finish_req();

/*
*	Global Variables
*/     
struct server_struct src, dst;
		/* source and destination structures */
struct fileinfo fil;

boolean	fts_timed_out = FALSE;

extern boolean conference;
extern FILE
 	*tracefp,  /* File to save trace of Telnet history */
	*logfp;    /* File to compose message */
	
#ifndef __STDC__
giveup()
#else
void giveup(dummy)
register int dummy;
#endif /* __STDC__ */
{
   closeconn(&src);
   if ((fil.reqtype != DFILE) && (fil.reqtype != VERIFY_SRC))
      closeconn(&dst);
   fts_timed_out = TRUE;
   fprintf(logfp,"\nFTS server timed out.\n");
}

main(argc, argv)
   int argc;
   char **argv;
{
	char temp[100], reqfile[100], listfile[100];
	int retcode, interval, jobno = 0;
#ifdef SYSV
	char jobname[JOBNAMELEN];
#endif /* SYSV */
	struct reqinfo r;
	char **argp = argv + 1;
	FILE *stream;
	
	tracefp = NULL;
	if (argc < 2) {
		fprintf(stderr, "\n\nUsage: fts [-v] file-name\n");
		exit(0);
	}
	
	while ((argc) && **argp == '-') {
		argc--;
		switch (*(1+*argp)) {
		   case 'c': /* send dot-file */
		        conference = TRUE;
		        break;
		   case 'v':
			tracefp = stdout;
			break;

		   default:
			fprintf(stderr,"fts: Unknown keyword %s\n", *argp);
			exit(0);
		   }
	    argp++;
	 }
	
	strcpy(reqfile,*argp);
	if (! read_req(reqfile, &r, &src.h, &dst.h, &fil, listfile)) {
	   fprintf(stderr,
   		   "\n\nfts: Request file \'%s\' not found.\n",reqfile);
	   return;
	   }

	if (strlen(r.mailbox)==0 || strlen(r.mailfile)==0 || 
	    (logfp = fopen(r.mailfile,"a")) == NULL)
	   logfp = stdout;
	if (tracefp) 
	   tracefp = logfp;

	format_time(0, temp);
	fprintf(logfp,"\n  %s: starting...\n\n", temp);
	
	/* submit extra request, just in case */
	if (r.ntries) r.ntries--;
	if (strlen(r.cmdfile)) {
	   queue_req(&r, (time(0)+MAXFTSTIME+60), temp);
#ifndef SYSV
	   jobno = find_job(reqfile);
#else /* SYSV */
	   jobno = find_job(reqfile, jobname);
#endif /* SYSV */
	   }
	print_req(logfp, &r, &src.h, &dst.h, &fil, FALSE);
	
	signal(SIGALRM, giveup); 
	fts_timed_out = FALSE;
	alarm(MAXFTSTIME); /* start a timer */
	retcode = xfer( &src, (fil.reqtype == DFILE) ? NULL:
				(fil.reqtype==VERIFY_SRC) ? NULL:
				&dst, &fil, reqfile, listfile);
	alarm(0); /* cancel the timer */

	format_time(0, temp);
	fprintf(logfp,"\n  %s: completed %ssuccessfully.\n\n", temp, 
			(retcode == OK)?"":"un");
	fflush(logfp);
    
	if ((strlen(r.cmdfile) != 0) &&
	    ((retcode == ERR_RETRY) || fts_timed_out) && 
	    (r.ntries > 0)) {
	   /* rewrite request file and resubmit request */
	   interval = r.interval;
           if (r.interval < MAXINTERVAL) {
	      r.interval = r.interval*2;
	      if (r.interval > MAXINTERVAL)
	         r.interval = MAXINTERVAL;
	      } /* *** use MIN? */
	   
	   write_req(reqfile, &r, &src.h, &dst.h, &fil, 
   			(fil.multflag && (fil.reqtype == COPY))? listfile:"");
	   queue_req(&r, (time(0)+(60*interval)), temp);
	   fprintf(logfp,"%s\n",temp);
	   fflush(logfp);
	   /* cancel the extra request */
#ifndef SYSV
	   cancel_job(jobno);
#else /* SYSV */
	   if (jobno)
		cancel_job(jobname);
#endif /* SYSV */
	   if (logfp && (logfp != stdout)) fclose(logfp);
	   }
	else {
	   /* cancel the extra request */
#ifndef SYSV
	   cancel_job(jobno);
#else /* SYSV */
	   if (jobno)
		cancel_job(jobname);
#endif /* SYSV */
	   if (logfp && (logfp != stdout)) fclose(logfp);
	   
	   /* send the results message and delete the request files */
	   strcpy(temp, src.h.file);
	   strcat(temp, ((retcode == OK) && fil.multflag)? " -- Completed" :
	   		(retcode == OK)? " -- Succeeded" : 
					" -- Failed");
	   finish_req(reqfile, &r, temp, listfile);
	   }
	   
} /* main */
