.\" @(#)bftptool.1
.TH BFTPTOOL 1C "07 August 1989"
.nh
.SH NAME
bftptool \- Background File Transfer Program Tool
.SH SYNOPSIS
.B bftptool
.SH DESCRIPTION
.LP
The
.B bftptool
is a mouse and window oriented user interface to the Background File
Transfer Program (BFTP).
.B bftptool
may be used to submit a request to have a file transfered at some time
in the future via the standard internet File Transfer Protocol (FTP),
which is described in RFC-959.
.LP
BFTP makes use of third party FTP, so the source and the destination hosts do
not have to be operational at the time the request is submitted.
Transfers are scheduled locally via the system batch processor,
.BR at .
Therefore the exact time of a file transfer will take place depends on how
often jobs are run from the system batch queue.
.LP
For more information on BFTP see 
.BR RFC-1068 .
.SH COMMANDS
.HP
.B Quit
.br
Exit the 
.BR bftptool .
.HP
.B Explain
.br
Display a short explanation of how to use this program.
.TP
.B Verify
.br
Validate the request.  The current request will be checked to see if all
needed information has been entered.  Then the
.B bftptool
will connect to the specified hosts to determine whether the specified
parameters used are supported.
.TP
.B Submit
.br
Place the request in the batch queue.  The
.BR bftptool " will create a subwindow, prompting for the"
.BR StartTime ", the " Mailbox ", and the " RequestKeyword .
.TP
.B Transfer
.br
Perform the requested transfer now.
.TP
.BI Find
.br
Locate and display a previously submitted BFTP job.  The
.B bftptool
will create a subwindow, prompting for the (optional) 
.BR RequestID " and the " RequestKeyword .
Once a reqest has been located and displayed, it can be changed and
resubmitted, or cancelled.
.HP
.B Clear
.br
Discard all information about a request.  This command is used to reset the
.BR bftptool " to the default startup values."
.TP
.B RequestStorage
.br
Display/undisplay the request storage window.
.B LoadReq
is used to read in the
.IR request-file " corresponding to the name appearing in the"
.BR RequestName " field."
.BR StoreReq " is used to save the current request in a"
.IR request-file .
.BR PurgeReq " is used to delete the"
.IR request-file .
.SH SPECIAL MOUSE FUNCTIONS
.HP   
.B LEFT Mouse Button
.br
The left mouse button is used to position the cursor in a text field,
and to select a command.
.HP
.B CENTER Mouse Button
.br
The center mouse button is used to display help information in a popup 
window.  To test this feature, position the mouse pointer over a 
command/field label, such as
.BR Transfer , 
and hold down the center mouse button.
.HP
.B RIGHT Mouse Button
.br
The right mouse button is used to display and fill in default values.
To test this feature, position the mouse pointer over the label for a
field, such as a 
.B Host
field.  Depress the right mouse button, highlight
a value on the menu, and release the mouse button.
.SH FILES
.LP
The 
.B bftptool
creates a number of files that are used to keep track of requests that
are in progress:
.in 8
.BI bftp 123456789 .cmd
.br
.BI bftp 123456789 .list
.br
.BI bftp 123456789 .msg
.br
.BI bftp 123456789 .req
.LP
The files that are saved via the 
.B StoreReq
command are as follows:
.in 8
.BI bftp-save. request-name
.LP
The
.B bftptool
usually stores request files in the home directory of the user who is logged
on.  To have the
.B bftptool
store these files in another directory, use the system
.B setenv 
command to set
.BR $BFTPDIR , 
for example
.in 8
.BI "setenv BFTPDIR ~" "yourname/.bftp"
.LP
.SH "SEE ALSO"
.BR at (1),
.BR bftp (1C),
.BR cron (8),
.BR crontab (5),
.BR ftp (1C),
.BR ftpd (8C),
.BR mbftptool (1C)
.SH AUTHOR
Annette DeSchon, USC Information Sciences Institute
.SH BUGS
Please report bugs to Annette DeSchon <deschon@isi.edu>, 213-822-1511.
