/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *	May, 1991							*
 *									*
 *	Copyright (c) 1991 University of Southern California.		*
 *	All rights reserved.						*
 *									*
 *	Redistribution and use in source and binary forms are permitted	*
 * 	provided that the above copyright notice and this paragraph are	*
 * 	duplicated in all such forms and that any documentation,	*
 * 	advertising materials, and other materials related to such	*
 * 	distribution and use acknowledge that the software was		*
 *	developed by the University of Southern California, Information	*
 *	Sciences Institute.  The name of the University may not be used *
 *	to endorse or promote products derived from this software 	*
 * 	without specific prior written permission.			*
 *	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR	*
 * 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
 * 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*
 * 	PURPOSE.							*
 *									*
 ************************************************************************/

/*  bftp_tool.c
 *
 *  The "bftptool" SunView user interface, is implemented in this module.
*/

/* *** Things to add *** */
    /* More defaults in menus? */
    /* Mailbox check on find? */

#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <sys/file.h>
#include <suntool/sunview.h>
    /* includes <sunwindow/window_hs.h>, which includes <sys/time.h> */
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <suntool/textsw.h>
/* FTS */
#include <netinet/in.h>	
#include "fts.h"
    /* bftp.h is included in fts.h */

#define text_print(str) (void)textsw_insert(fts_sw, str, strlen(str))
#define endof(x) (x + strlen(x))
#define scroll_to_end()\
  textsw_possibly_normalize(fts_sw, (int)window_get(fts_sw,TEXTSW_LENGTH))
	
extern FILE 
	*tracefp,  /* File to save trace of Telnet history */
	*logfp,    /* File to compose message */
	*listp;

extern char
   *get_request_file(),
   bftp_dir[MAXPATHLEN],
   def_user[L_cuserid],
   *version,
   *introduction,
   *background;
   
extern struct hostinfo src, dst, nullhost;
extern struct fileinfo fil, defaultfile;
extern struct reqinfo nullreq;

extern int 
	init_param_help(),
	init_req_help(),
	init_submit_help(),
	find_errors(),
	op_choice(),
	op_value();

extern Notify_value close_popup();

extern void 
	copy_fileparams(),
	destroy_req_frame(),
	display_sfile_menu(),
	dummy_event_proc(),
	hint_event_proc(),
	init_attr_lists(),
	init_host_menu(),
	init_login_menu(),
	init_passw_menu(),
	init_port_menu(),
	init_req(),
	init_rs_location(),
	init_user(),
	make_bold(),
	make_submit_frame(),
	make_fts_frame(),
	no_spaces(),
	rStorage_proc(),
	update_params();
	
boolean verbose = FALSE;

extern boolean
        user_set_mult,
	parse_date(),
	confirm_yes(),
	read_req(),
	write_req(),
	empty_str(),
	mailbox_ok();

extern Attr_avlist 
	app_attr,
	byte_attr,
	form_attr,
  	mode_attr,
	mult_attr,
	stou_attr,
	stru_attr,
	type_attr,

  	dir_attr,
	file_attr,
	host_attr,
	login_attr,
	pass_attr,
	port_attr;

/* Globals used in the Find procedures */

static char filename[100], request[20], listfile[100], keyword[20];
static struct hostinfo tmpsrc, tmpdst;
static struct fileinfo tmpfil;
static struct reqinfo req, tmpreq;

static short icon_image[] = {
#include "bftp.icon"
};
DEFINE_ICON_FROM_IMAGE(bftp_icon, icon_image);

static int fts_pid;

/* Required for tool_lib.c */

Frame tool_frame;

/* *********************** */

extern Window popup_frame;
extern Textsw fts_sw;
Window params;

/* Panel items (used to index help info) */
	
extern Panel_item
  /* Popup Window */
	quitSW_item, keyword_item, 
	interval_item, tries_item, startTime_item, mailbox_item,
  /* Parameters subwindow */
	type_item, format_item, byteSize_item, stru_item, 
  	mode_item, stou_item, append_item, multiple_item;

Panel_item
	sFile_item;
static Panel_item 
  /* Commands */
	quit_item, explain_item, verify_item, submit_item, transfer_item,
	find_item, clear_item, storage_item,
  /* Parameters */
	op_item, verbose_item, 
	src_item, sHost_item, sLogin_item, sPass_item, sAcct_item, 
	sDir_item, sPort_item,
	dest_item, dHost_item, dLogin_item, dPass_item, dAcct_item,
	dFile_item, dFileDef_msg, dDir_item, dPort_item,
	param_item, 
  /* Find Popup Window */
	id_item,
	find_button,
	next_button,
	cancel_button,
	read_button;

#define SAME_AS_SRC "(same as Src)"

/* Table of item, corresponding hint text, and event_proc for optional
   fields for which the default value is displayed as a hint:
*/

struct hint_record {
     Panel_item *field_item, *msg_item;
     void (*event_proc)();
   } hint_list[] = {
	&dFile_item, 	&dFileDef_msg, 	  display_sfile_menu
	};

/* Help strings for event procs -- middle mouse button */

#include "help_strings.h"

struct help_record {
   union u_tag {
     Panel_item *ip;
     char	*cp;
     } uval;
   } helplist[1000];

static void
init_help()
{
   int i = 0;

#define set_ptr(item) helplist[i++].uval.ip = &item
#define set_str(str) helplist[i++].uval.cp = str
#define last_str() helplist[i++].uval.cp = NULL

   set_ptr(quit_item);
   set_str(quit_help);
   last_str();

   set_ptr(verbose_item);
   set_str("The Verbose flag specifies that a detailed log of the FTP commands will");
   set_str("  be displayed when the 'Verify' and the 'Transfer' commands are selected.");
   set_str("  The default is FALSE.");
   last_str();

   set_ptr(src_item);
   set_str("Source parameters specify from where file(s) will be copied,");
   set_str("  moved, or deleted.");
   last_str();

   set_ptr(sHost_item);
   set_str(sHost_help);
   last_str();

   set_ptr(sLogin_item);
   set_str(sLogin_help);
   last_str();

   set_ptr(sPass_item);
   set_str(sPass_help);
   last_str();

   set_ptr(sAcct_item);
   set_str("Account on source host.");
   last_str();

   set_ptr(sPort_item);
   set_str("Port used for the FTP control connection to the source host.");
   set_str("  The default is 21.");
   last_str();

   set_ptr(sFile_item);
   set_str("Name of file to be transfered/deleted.  The wildcard character '*'");
   set_str(sFile2_help);
   last_str();

   set_ptr(sDir_item);
   set_str(sDir1_help);
   set_str(sDir2_help);
   set_str(sDir3_help);
   set_str(sDir4_help);
   set_str(sDir5_help);
   last_str();

   i = init_submit_help(i);

   set_ptr(dest_item);
   set_str("Destination parameters specify where file(s) will be copied or moved.");
   last_str();
  
   set_ptr(dHost_item);
   set_str(dhost_help);
   last_str();

   set_ptr(dLogin_item);
   set_str(dlogin_help);
   last_str();

   set_ptr(dPass_item);
   set_str(dpass_help);
   last_str();

   set_ptr(dFile_item);
   set_str(dfile_help);
   set_str(paren_help);
   last_str();

   set_ptr(dAcct_item);
   set_str("Account on destination host.");
   last_str();
   
   set_ptr(dPort_item);
   set_str("Port used for the FTP control connection to the destintation host.");
   set_str("  The default is 21.");
   last_str();

   set_ptr(dDir_item);
   set_str(ddir1_help);
   set_str(ddir2_help);
   set_str(ddir3_help);
   set_str(ddir4_help);
   set_str(ddir5_help);
   last_str();

   set_ptr(storage_item);
   set_str(reqSW1_help);
   set_str(reqSW2_help);
   set_str(toggle_help);
   last_str();

   i = init_req_help();

   set_ptr(op_item);
   set_str("The following operations are supported:");
   set_str("  'copy'    The source file will be copied to the destination file name.");
   set_str("  'move'    The source file will be deleted after it has been copied.");
   set_str("  'delete'  The source file will be deleted.");
   set_str("  The default is 'copy'.");
   last_str();
  
   i = init_param_help(i);

   set_ptr(explain_item);
   set_str("Explain displays a short explanation of how to use this tool.");
   last_str();

   set_ptr(verify_item);
   set_str("Verify is used to connect to the specified hosts, while you wait,");
   set_str("  and to determine whether the specified parameters are supported.");
   last_str();

   set_ptr(submit_item);
   set_str("Submit is used to queue the request.  A popup window will appear,");
   set_str("   requesting additional parameters such as the start time.");
   last_str();

   set_ptr(transfer_item);
   set_str("Transfer is used to connect to the specified hosts,");
   set_str("  and to perform the file transfer while you wait.");
   last_str();

   set_ptr(find_item);
   set_str("Find brings up a popup window, and can be used to locate and");
   set_str("  display a previous request.  Once a request is displayed, it");
   set_str("  can be changed and resubmited, or cancelled.");
   last_str();

   set_ptr(clear_item);
   set_str("Clear resets all parameters to their default values.");
   last_str();

   set_ptr(find_button);
   set_str("FindRequest searches for and displays BFTP request(s) that match");
   set_str("  the specified RequestID and/or RequestKeyword.");
   last_str();

   set_ptr(next_button);
   set_str("NextRequest displays the next matching BFTP request.");
   last_str();

   set_ptr(cancel_button);
   set_str("CancelRequest cancels the BFTP request most recently displayed in");
   set_str("  the text subwindow, and displays the next matching request.");
   last_str();

   set_ptr(read_button);
   set_str("ChangeRequest reads the displayed request into the BFTPTOOL,");
   set_str("  and cancels the original request.  This request may now");
   set_str("  be modified and resubmitted.");
   last_str();

   set_ptr(id_item);
   set_str("The RequestID refers to a specific request.  It is displayed");
   set_str("  in the text subwindow when a request is first queued.");
   set_str("  Fill in the RequestID to display the status of a request");
   set_str("  that was previously queued.  An example of the format is");
   set_str("  'bftp588464123'.  If the RequestID field is omitted, all");
   set_str("  requests that match the RequestKeyword field will be displayed.");
   last_str();

   /* end the list */
   helplist[i++].uval.ip = NULL;
}

static void
set_buttons(status)
   boolean status;
{
   /* these items use the popup_frame and must be cleared */
   panel_set(find_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(transfer_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(verify_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(submit_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(explain_item, PANEL_SHOW_ITEM, status, 0);

   panel_set(clear_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(storage_item, PANEL_SHOW_ITEM, status, 0);
   if (!status)
      destroy_req_frame();
}

void
quit_popup(item, event)
   Panel_item item;
   Event *event;
{
   close_listp();
   if (fts_pid) {
      kill(fts_pid, SIGKILL);
      fts_pid = 0;
      }
   window_destroy(popup_frame);
   set_buttons(TRUE);
}

static void
sFile_event_proc(item, event)
     Panel_item item;
     Event *event;
{
   int i;

   if (event_is_ascii(event) &&
       ('*' == (char)event_id(event)) &&
       !panel_get(multiple_item, PANEL_VALUE)) {
      panel_set(multiple_item, PANEL_VALUE, TRUE, 0);
      adjust_dest(TRUE);
      }
   no_spaces(item, event);
   if (!user_set_mult && 
       panel_get(multiple_item, PANEL_VALUE) &&
       !strchr((char *)panel_get(sFile_item, PANEL_VALUE), '*')) {
      panel_set(multiple_item, PANEL_VALUE, FALSE, 0);
      adjust_dest(FALSE);
      window_set(params, PANEL_CARET_ITEM, sFile_item, 0);
      }
} /* sFile_event_proc */

/* routine used in upcoming notify procs */

void
toggle_dest_items(show)
   int show;
{
   if ((int)panel_get(dHost_item, PANEL_SHOW_ITEM) != show) {
      panel_set(dHost_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dLogin_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dPass_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dAcct_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dDir_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dPort_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(dFile_item, PANEL_SHOW_ITEM, show, 0);
      if (show && ((int)panel_get(multiple_item, PANEL_VALUE)) &&
          (!(int)panel_get(append_item, PANEL_VALUE)))
	 panel_set(dFile_item, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(stou_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(append_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(stru_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(mode_item, PANEL_SHOW_ITEM, show, 0);
      panel_set(type_item, PANEL_SHOW_ITEM, show, 0);
      switch ((int)panel_get(type_item, PANEL_VALUE)) {
         case 0: /* ascii */
         case 1: /* ebcdic */
            panel_set(format_item, PANEL_SHOW_ITEM, show, 0);
            break;
         case 2: /* image */
            break;
         case 3: /* local */
	    panel_set(byteSize_item, PANEL_SHOW_ITEM, show, 0);
            break;
         }
      }
}

/* Notify Procs for Parameters */

static void
op_proc(item, value, event)
   Panel_item item;
  int value;
  Event *event;
{
   toggle_dest_items((value==op_choice(DFILE))?FALSE:TRUE);
}

/* Routines used in Notify procs */

void
show_dest_file(yes)
   boolean yes;
{
   if (DFILE != op_value((int)panel_get(op_item, PANEL_VALUE))) {
      panel_set(dFile_item, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
      panel_set(dFileDef_msg, PANEL_SHOW_ITEM, 
		(yes && !strlen((char *)panel_get(dFile_item, PANEL_VALUE)))?
	     		TRUE:FALSE, 
		0);
      }
}

void
update_screen(src, dst, fil)
   struct hostinfo *src, *dst;
   struct fileinfo *fil;
{
   char temp[6];
   boolean show_file;

   panel_set(op_item, PANEL_VALUE, op_choice(fil->reqtype), 0);
   toggle_dest_items((fil->reqtype==DFILE)?FALSE:TRUE);
   panel_set(sHost_item, PANEL_VALUE, src->host, 0);
   panel_set(dHost_item, PANEL_VALUE, dst->host, 0);
   panel_set(sLogin_item, PANEL_VALUE, src->user, 0);
   panel_set(dLogin_item, PANEL_VALUE,dst->user, 0);
   panel_set(sPass_item, PANEL_VALUE, src->passwd,
   	PANEL_LABEL_BOLD, (strlen(src->passwd))?TRUE:FALSE,
	0);
   panel_set(dPass_item, PANEL_VALUE, dst->passwd,
   	PANEL_LABEL_BOLD, (strlen(dst->passwd))?TRUE:FALSE,
	0);
   panel_set(sDir_item, PANEL_VALUE, src->dir, 0);
   panel_set(dDir_item, PANEL_VALUE, dst->dir, 0);
   panel_set(sAcct_item, PANEL_VALUE, src->acct, 0);
   panel_set(dAcct_item, PANEL_VALUE, dst->acct, 0);
   sprintf(temp,"%d",src->port);
   panel_set(sPort_item, PANEL_VALUE, temp, 0);
   sprintf(temp,"%d",dst->port);
   panel_set(dPort_item, PANEL_VALUE, temp, 0);
   panel_set(sFile_item, PANEL_VALUE, src->file, 0);
   if (!strcmp(src->file, dst->file)) /* they're equal */
      dst->file[0] = '\0';
   show_file = ((!fil->multflag) ||(fil->creation==APPE))?TRUE:FALSE;
   panel_set(dFile_item, 
	     PANEL_VALUE, 	dst->file, 
	     PANEL_SHOW_ITEM, 	show_file,
	     0);
   if (!strlen(dst->file))
      panel_set(dFileDef_msg, PANEL_SHOW_ITEM, show_file, 0);
   update_params(fil);
} /* update_screen */

void
copy_screen(src, dst, fil)
   struct hostinfo *src, *dst;
   struct fileinfo *fil;
{
   char temp[6];
   int type, form, bytesiz;

   verbose = (int)panel_get(verbose_item, PANEL_VALUE);

   strcpy(src->host, (char *)panel_get(sHost_item, PANEL_VALUE));
   strcpy(src->user, (char *)panel_get(sLogin_item, PANEL_VALUE));
   strcpy(src->passwd, (char *)panel_get(sPass_item, PANEL_VALUE));
   if (empty_str(src->passwd)) src->passwd[0] = '\0';
   strcpy(src->dir, (char *)panel_get(sDir_item, PANEL_VALUE));
   strcpy(src->acct, (char *)panel_get(sAcct_item, PANEL_VALUE));
   src->port = atoi((char *)panel_get(sPort_item, PANEL_VALUE));
   strcpy(src->file, (char *)panel_get(sFile_item, PANEL_VALUE));

   strcpy(dst->host, (char *)panel_get(dHost_item, PANEL_VALUE));
   strcpy(dst->user, (char *)panel_get(dLogin_item, PANEL_VALUE));
   strcpy(dst->passwd, (char *)panel_get(dPass_item, PANEL_VALUE));
   if (empty_str(dst->passwd)) dst->passwd[0] = '\0';
   strcpy(dst->dir, (char *)panel_get(dDir_item, PANEL_VALUE));
   strcpy(dst->acct, (char *)panel_get(dAcct_item, PANEL_VALUE));
   dst->port = atoi((char *)panel_get(dPort_item, PANEL_VALUE));
   
   /* if visable, copy it, otherwise make it empty */
   if ((int)panel_get(dFile_item, PANEL_SHOW_ITEM)) {
      strcpy(dst->file, (char *)panel_get(dFile_item, PANEL_VALUE));
      if (!strlen(dst->file))
	 strcpy(dst->file, src->file);
      }
   else
      dst->file[0] = '\0';

   copy_fileparams(fil);
} /* copy_screen */

/* Notify Procs for the Commands Subwindow */

static void
quit_proc(item, event)
   Panel_item item;
   Event *event;
{
   if (fts_pid) {
      kill(fts_pid, SIGKILL);
      fts_pid = 0;
      }
   window_destroy(tool_frame);
}

static void
find_proc()
{
   set_buttons(FALSE);
   make_find_frame();
}

static void
reset_text(sw)
   Textsw sw;
{
   textsw_reset(sw, 0, 0);
   window_set(sw, TEXTSW_READ_ONLY, TRUE, 0);
}

static void
clear_proc()
{
   update_screen(&nullhost, &nullhost, &defaultfile);
   init_req(&req);
}

static void
submit_proc()
{
   set_buttons(FALSE);
   make_submit_frame(&req, 60, 12, 
		     (int)panel_get(verbose_item, PANEL_ITEM_X),
		     (int)panel_get(verbose_item, PANEL_ITEM_Y));
}

/* Notify Procs for the Commands Subwindow (continued)*/

static void
explain_proc()
{
   set_buttons(FALSE);
   make_fts_frame("Explain", 80, 20,
		  (int)panel_get(verbose_item, PANEL_ITEM_X),
		  (int)panel_get(verbose_item, PANEL_ITEM_Y));

   text_print(introduction);

text_print(
"Mouse Functions:\n\
\n\
  The LEFT mouse button is used to position the cursor in a text field,\n\
  and to select a command.\n\
\n\
  The CENTER mouse button is used to display help information. To test this\n\
  feature, position the mouse pointer over a command/field label, such as\n\
  'File:', and depress the center mouse button.\n\
\n\
  The RIGHT mouse button is used to display and fill in default values.\n\
  To test this feature, position the mouse pointer over the label for a\n\
  field, such as a 'Host' field.  Depress the right mouse button, highlight\n\
  a value on the menu, and release the mouse button.\n");

text_print("\n\
Parameters:\n\
\n\
  File transfer parameters, such as host names, logins, and file names,\n\
  are entered into the appropriate fields on the BFTPTOOL.  Some such as,\n\
  'Type' are selected by clicking the left mouse button over the field\n\
  or depressing the right mouse button and making a menu selection.\n\
\n\
  Characters that are typed into a password field are not echoed; when such\n\
  a field contains text, the label for the field is displayed in bold font.\n\
  Although characters in a password field are invisible, they may deleted\n\
  using the <delete> key, similarly to fields in which the contents are\n\
  displayed.\n\
");

text_print("\n\
Commands:\n\
\n\
  Some commands such as 'Verify', 'Submit', 'Transfer', and 'Find', create\n\
  a popup window.  These popup windows prompt for additional information\n\
  that is needed to complete the operation.  Each of these popup windows\n\
  contains a 'Quit' subcommand, which can be used to terminate the command.\n\
");

text_print(background);
textsw_normalize_view(fts_sw,0);
}

Notify_value
my_pipe_reader(me, fd)
   int *me, fd;
{
   char c[2];
   int n;

   while (fd_select(fd))
      if (n = read(fd, c, 1)) {
	 (void)textsw_insert(fts_sw, c, n);
	 }
      else {
	 if (close(fd) == -1)
	    perror("close0");
	 fts_pid = 0;
	 (void) notify_set_input_func(&fts_pid,
                                      NOTIFY_FUNC_NULL, fd);
	 break;
	 }
   return(NOTIFY_DONE);
}

static void
do_fts(transfer)
   boolean transfer;
{
   char temp[100], path[100];
   struct server_struct ssh, dsh;
   u_long now;
   int fd, nfds, pid, retcode, fildes[2];

   if (pipe(fildes) == -1) {
      perror("pipe");
      exit(1);
      }
   (void) notify_set_input_func(&fts_pid, my_pipe_reader, fildes[0]);
   if (pid = fork()) {
      if (pid == -1) {
         perror("fork");
	 close(fildes[0]);
	 (void) notify_set_input_func(&fts_pid,
	 				NOTIFY_FUNC_NULL, fildes[0]);
	 close(fildes[1]);
	 return;
	 }
      fts_pid = pid;
      (void)notify_set_wait3_func(&fts_pid,
      				  notify_default_wait3, pid);
      if (close(fildes[1]) == -1)
         perror("close1");
      }
   else { /* this is the child process */
      nfds = getdtablesize();         /* Get max number of fd's */
      for (fd = 0; fd < nfds; fd++)   /* Close all unwanted fd's */
	 if (fd!=fildes[1])
	    (void)close(fd);

      if (dup2(fildes[1], 1) == -1) {
	    perror("dup2");
	    close(fildes[1]);
	    exit(1);
	    }
      if (close(fildes[1]) == -1) {
	    perror("close-c1");
	    exit(1);
	    }

      if (!transfer) 
	    if (fil.reqtype == DFILE)
	       fil.reqtype = VERIFY_SRC;  /* set just in the child process */
	    else
	       fil.reqtype = VERIFY;

      tracefp = (verbose)?stdout:NULL;
      logfp = stdout;

      format_time(0, temp);
      fprintf(logfp,"\n  %s: starting...\n\n", temp);
	
      now = time(NULL);
      sprintf(path,"%s%d",REQPREFIX,now);
      sprintf(temp, "%s.req", path);
	 
      bcopy((char *)&src, (char *)&ssh.h, sizeof(struct hostinfo));
      bcopy((char *)&dst, (char *)&dsh.h, sizeof(struct hostinfo));
      retcode = xfer(&ssh, &dsh, &fil, temp, NULL);
	 
      sprintf(temp,"rm %s.list 1> /dev/null 2>&1\n", path);
      system(temp);

      format_time(0, temp);
      fprintf(logfp,"\n  %s: completed %ssuccessfully.\n\n", temp, 
	      (retcode == OK)?"":"un");

      fflush(logfp);
      exit(0);
      }
} /* do_fts */

/* Notify Procs for the Commands Subwindow (continued) */

static void 
verify_proc()
{
   set_buttons(FALSE);
   make_fts_frame("Verify", 80, 20,
		  (int)panel_get(verbose_item, PANEL_ITEM_X),
		  (int)panel_get(verbose_item, PANEL_ITEM_Y));
   copy_screen(&src, &dst, &fil);
   if (find_errors(fts_sw, &src, &dst, &fil))
      textsw_normalize_view(fts_sw,0);
   else
      do_fts(FALSE);
}

static void
transfer_proc()
{
   set_buttons(FALSE);
   make_fts_frame("Transfer", 80, 20,
		  (int)panel_get(verbose_item, PANEL_ITEM_X),
		  (int)panel_get(verbose_item, PANEL_ITEM_Y));
   copy_screen(&src, &dst, &fil);
   if (find_errors(fts_sw, &src, &dst, &fil))
      textsw_normalize_view(fts_sw,0);
   else
      do_fts(TRUE);
}

/* Notify Proc for the Submit Window */

void
do_submit()
{
   FILE *xxx;
   char timestr[100], temp[100], path[100];
   u_long now, start;

   now = time(NULL);

   scroll_to_end();

   copy_screen(&src, &dst, &fil);
   if (find_errors(fts_sw, &src, &dst, &fil))
      return;

   /* parse the start time */
   strcpy(timestr, (char *)panel_get(startTime_item, PANEL_VALUE));
   if (empty_str(timestr))
      start = now;
   else if (!parse_date(timestr, &start)) {
      sprintf(temp," Date '%s' not parsed.\n",timestr);
      text_print(temp);
      panel_set(startTime_item, PANEL_VALUE, "now", 0);
      return;
      }

   /* copy request parameters from screen */
   strcpy(req.rpasswd, (char *)panel_get(keyword_item, PANEL_VALUE));
   if (empty_str(req.rpasswd)) req.rpasswd[0] = '\0';
   strcpy(req.mailbox, (char *)panel_get(mailbox_item, PANEL_VALUE));
   if (!mailbox_ok(req.mailbox, temp)) {
      text_print(temp);
      return;
      }
   req.interval = atoi((char *)panel_get(interval_item, PANEL_VALUE));
   req.ntries = atoi((char *)panel_get(tries_item, PANEL_VALUE));

   sprintf(path,"%s%d",REQPREFIX,now);

   sprintf(temp, "%s.req", path);
   sprintf(req.mailfile,"%s.msg",path);
   sprintf(req.cmdfile,"%s.cmd",path);

   write_req(temp,&req,&src,&dst,&fil,NULL);

   sprintf(temp, "%s.cmd", path);
   xxx = fdopen(open(temp,(O_WRONLY|O_CREAT),0600),"w");
   fprintf(xxx, "%s -v %s.req\n", FXPATH, path);
   fclose(xxx);

   sprintf(temp, "%s.msg", path);
   xxx = fdopen(open(temp,(O_WRONLY|O_CREAT),0600),"w");
   queue_req(&req, (now > start) ? now : start, temp);
   print_req(xxx, &req, &src, &dst, &fil, FALSE);
   fprintf(xxx,"\n%s\n",temp);
   fclose(xxx);
   strcat(temp,"\n\n");
   text_print(temp);
} /* do_submit */

/* Find Subwindow Notify Procs */

static void
do_find()
{
   char temp[100], id[100];
   char *filep;
   int  okay = TRUE;	
   FILE *grepfp;
	
   scroll_to_end();

   text_print("Find...\n");
   if ((int) panel_get(id_item, PANEL_SHOW_ITEM)) {
      strcpy(request, (char *)panel_get(id_item, PANEL_VALUE));
      strcpy(keyword, (char *)panel_get(keyword_item, PANEL_VALUE));
      if (empty_str(keyword)) keyword[0] = '\0';
      if (!empty_str(request)) {
         sprintf(filename,"%s.req",request);
         if (!read_req(filename,
	 		&tmpreq, &tmpsrc, &tmpdst, &tmpfil, listfile)) {
	    sprintf(temp,"    Request %s not found.\n",request);
	    text_print(temp);
	    okay = FALSE;
            }
         else if (strcmp(keyword, tmpreq.rpasswd) != 0) {
            text_print("    Keyword does not match.\n");
	    okay = FALSE;
	    }
         }
      else {
	 while (filep = get_request_file(keyword)) {
	     if (read_req(filep,
	     		&tmpreq, &tmpsrc, &tmpdst, &tmpfil, listfile)) {
		if (strcmp(keyword, tmpreq.rpasswd) == 0) {
		   strcpy(filename, filep);
		   break;
		   }
	        }
	     }
	 if (!filep) {
	    text_print("    No matching request was found.\n");
	    okay = FALSE;
	    }
         }
      }
   else {
      while (filep = get_request_file(keyword)) {
	 if (read_req(filep, &tmpreq, &tmpsrc, &tmpdst, &tmpfil, listfile)) {
	    if (!strcmp(keyword, tmpreq.rpasswd)) {
		strcpy(filename, filep);
		break;
		}
	    }
	 }
      if (!filep) {
         text_print("    No more matching requests.\n");
         okay = FALSE;
	 }
      }

   if (!okay) {
      panel_set(next_button, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(cancel_button, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(read_button, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(find_button, PANEL_SHOW_ITEM, TRUE, 0);
      panel_set(keyword_item, PANEL_SHOW_ITEM, TRUE, 0);
      panel_set(id_item, PANEL_SHOW_ITEM, TRUE, 0);
      }
   else {
      /* Display the request in the text subwidow. */
      get_id(id, filename);
      sprintf(temp,"\nRequest: %s\n\n",id);
      text_print(temp);

      /* print_req equivalent */
      sprintf(temp,"    Request type: %s\n",
		(tmpfil.reqtype==COPY)?"COPY":
		(tmpfil.reqtype==MOVE)?"MOVE":
		(tmpfil.reqtype==DFILE)?"DFILE":
		(tmpfil.reqtype==VERIFY)?"VERIFY":
		(tmpfil.reqtype==VERIFY_SRC)?"VERIFY_SRC":
		"unknown");
      text_print(temp);
      sprintf(temp,"    Source: %s,%s,XXX,%s,%d,%s,%s\n",
   	   tmpsrc.host, tmpsrc.user, tmpsrc.acct, tmpsrc.port,
	   tmpsrc.dir, tmpsrc.file);
      text_print(temp);
      if ((tmpfil.reqtype != VERIFY_SRC) && (tmpfil.reqtype != DFILE)) {
	 sprintf(temp,"    Destination: %s,%s,XXX,%s,%d,%s,%s\n",
	   tmpdst.host, tmpdst.user, tmpdst.acct, tmpdst.port,
	   tmpdst.dir, tmpdst.file);
      	 text_print(temp);
	 sprintf(temp,"    Stru: %c",tmpfil.stru);
         text_print(temp);
	 sprintf(temp,", Mode: %c, Type: %s, Creation: %s\n",
	 		tmpfil.mode, tmpfil.filetype,
			(tmpfil.creation==APPE)?"APPE":
			(tmpfil.creation==STOU)?"STOU":
			"STOR");
         text_print(temp);
	 }
      sprintf(temp,"    Multiple matching: %s",
   			(tmpfil.multflag)?"TRUE": "FALSE");
      text_print(temp);
      if ((tmpfil.reqtype != VERIFY) && (tmpfil.reqtype != VERIFY_SRC)) {
         sprintf(temp, ", Return mailbox: '%s'\n", tmpreq.mailbox);
         text_print(temp);
         sprintf(temp,
	 	"    Remaining tries: %d, Current retry interval: %d minutes",
      		tmpreq.ntries, tmpreq.interval);
         text_print(temp);
         }
      text_print("\n\n");

      /* Summarize */
      if (!empty_str(tmpreq.mailfile)) {
         text_print("History:\n\n");

	 sprintf(temp,"egrep 'submitted|starting|completed' %s\n",
	 		tmpreq.mailfile);
         if (grepfp = popen(temp,"r")) {
      	    while (fgets(temp, sizeof(temp), grepfp))
	       text_print(temp);
	    pclose(grepfp);
            }
         text_print("\n");
         }
      else
         text_print("History: No mail file found!\n\n");

      panel_set(find_button, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(keyword_item, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(id_item, PANEL_SHOW_ITEM, FALSE, 0);
      panel_set(next_button, PANEL_SHOW_ITEM, TRUE, 0);
      panel_set(cancel_button, PANEL_SHOW_ITEM, TRUE, 0);
      panel_set(read_button, PANEL_SHOW_ITEM, TRUE, 0);
      if (!request_queued(filename))
         text_print(
	 " This request is NOT queued; to resubmit it, click ChangeRequest.\n\n"
	 );
      }
} /* do_find */

static void
findnext_proc()
{
   if (empty_str(request) && listp)
	do_find();
   else {
       panel_set(next_button, PANEL_SHOW_ITEM, FALSE, 0);
       panel_set(cancel_button, PANEL_SHOW_ITEM, FALSE, 0);
       panel_set(read_button, PANEL_SHOW_ITEM, FALSE, 0);
       panel_set(find_button, PANEL_SHOW_ITEM, TRUE, 0);
       panel_set(keyword_item, PANEL_SHOW_ITEM, TRUE, 0);
       panel_set(id_item, PANEL_SHOW_ITEM, TRUE, 0);
       }
}

static void
cancel_req()
{
   cancel_msg(filename, &tmpreq, tmpsrc.file, listfile);
   scroll_to_end();
   text_print("\n Previous request cancelled.\n");
}

static void
cancel_proc()
{
   cancel_req();
   findnext_proc();	
}


static void
read_proc()
{
   char temp[100];

   scroll_to_end();
   sprintf(temp, "Reading %s%s...\n", bftp_dir, filename);
   text_print(temp);
   if (! read_req(filename, &req, &src, &dst, &fil, temp))
         text_print("    Request file not found.\n");
   else
         update_screen(&src, &dst, &fil);
   text_print("    Done\n");

   cancel_req();
   quit_popup();
}

make_find_frame()
{
   Window sw_panel;
   int row = 0;
	
   popup_frame = window_create(tool_frame, FRAME,
   		WIN_X, (int)panel_get(verbose_item, PANEL_ITEM_X),
		WIN_Y, (int)panel_get(verbose_item, PANEL_ITEM_Y),
		FRAME_NO_CONFIRM, TRUE,
		FRAME_DONE_PROC,	close_popup,
		0);
		
   sw_panel = window_create(popup_frame, PANEL,
   		0);
   quitSW_item = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "Quit", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      quit_popup,
		0);
   find_button = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "FindRequest", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      do_find,
		0);
   next_button = panel_create_item(sw_panel, PANEL_BUTTON,
   		PANEL_LABEL_X,		(int)panel_get(find_button,
							PANEL_LABEL_X),
		PANEL_LABEL_Y,		(int)panel_get(find_button,
							PANEL_LABEL_Y),
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "NextRequest", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      findnext_proc,
		PANEL_SHOW_ITEM, 	FALSE,
		0);
   cancel_button = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "CancelRequest", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      cancel_proc,
		PANEL_SHOW_ITEM, 	FALSE,
		0);
   read_button = panel_create_item(sw_panel, PANEL_BUTTON,
                PANEL_LABEL_IMAGE,
			panel_button_image(sw_panel, "ChangeRequest", 0, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,      read_proc,
		PANEL_SHOW_ITEM, 	FALSE,
		0);
   keyword_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"RequestKeyword:",
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_EVENT_PROC,	make_bold,
		PANEL_MASK_CHAR,	' ',
		0);
   id_item = panel_create_item(sw_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
   		PANEL_LABEL_STRING,	"RequestID (optional):",
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_EVENT_PROC,	no_spaces,
		0);
   window_fit(sw_panel);
   window_fit_width(popup_frame);

   fts_sw = window_create(popup_frame, TEXTSW,
		WIN_WIDTH,		ATTR_COL(70),
 		WIN_HEIGHT,		ATTR_ROW(20),
		TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
   		TEXTSW_READ_ONLY, 	TRUE,
		0);
   window_fit(fts_sw);

   window_fit(popup_frame);
   window_set(popup_frame, WIN_SHOW, TRUE, 0);
} /* make_find_frame */

static void
create_param_items()
{
   int bwidth = 8,
       indent = 4,
       row = 0;
	
   quit_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Quit", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	quit_proc,
		0);
   verify_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Verify", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	verify_proc,
		0);
   submit_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Submit", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	submit_proc,
		0);
   transfer_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Transfer", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	transfer_proc,
		0);
   find_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Find", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	find_proc,
		0);

   clear_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		(ATTR_ROW(++row)+(row*10)),
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Clear", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	clear_proc,
		0);
   explain_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,	
			panel_button_image(params, "Explain", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	explain_proc,
		0);
   storage_item = panel_create_item(params, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
			panel_button_image(params, "RequestStorage", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	rStorage_proc,
		0);

   op_item = panel_create_item(params, PANEL_CHOICE,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		(ATTR_ROW(++row)+(row*10)),
   		PANEL_LABEL_STRING,	"Operation:",
		PANEL_CHOICE_STRINGS, 	"copy", "move", "delete", 0,
		PANEL_VALUE,		op_choice(COPY),
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_NOTIFY_PROC,	op_proc,
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
   verbose_item = panel_create_item(params, PANEL_CHOICE,
   		PANEL_LABEL_STRING,	"Verbose:",
		PANEL_CHOICE_STRINGS, 	"FALSE", "TRUE", 0,
		PANEL_VALUE,		0,
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
   row++;
   src_item = panel_create_item(params, PANEL_MESSAGE,
   		PANEL_LABEL_STRING,	"Source",
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
		
   sHost_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		host_attr,
		0);
   sLogin_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,		login_attr,
		PANEL_VALUE_DISPLAY_LENGTH, 11,
		0);
   sPass_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,		pass_attr,
		0);
   sDir_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		dir_attr,
		0);
   sAcct_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_STRING,	"Acct:",
		PANEL_VALUE_DISPLAY_LENGTH, 12,
		PANEL_EVENT_PROC,	no_spaces,
		0);
   sPort_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,              port_attr,
		0);
   sFile_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		file_attr,
		PANEL_EVENT_PROC,       sFile_event_proc,
		PANEL_VALUE_DISPLAY_LENGTH, 40,
		0);

   dest_item = panel_create_item(params, PANEL_MESSAGE,
                PANEL_LABEL_STRING,     "Destination",
		PANEL_LABEL_X,          ATTR_COL(0),
		PANEL_LABEL_Y,          ATTR_ROW(++row),
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);
   dHost_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		host_attr,
		0);
   dLogin_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,		login_attr,
		PANEL_VALUE_DISPLAY_LENGTH, 11,
		0);
   dPass_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,		pass_attr,
		0);
   dDir_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		dir_attr,
		0);
   dAcct_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_STRING,	"Acct:",
		PANEL_VALUE_DISPLAY_LENGTH, 12,
		PANEL_EVENT_PROC,	no_spaces,
		0);
   dPort_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,              port_attr,
		0);
		
   dFile_item = panel_create_item(params, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		file_attr,
		PANEL_VALUE_DISPLAY_LENGTH, 40,
		PANEL_EVENT_PROC,	hint_event_proc,
		0);
   dFileDef_msg = panel_create_item(params, PANEL_MESSAGE,
   		PANEL_LABEL_X,		(int)panel_get(dFile_item,
						    PANEL_VALUE_X),
		PANEL_LABEL_Y,		(int)panel_get(dFile_item,
						    PANEL_VALUE_Y),
	        PANEL_LABEL_STRING,  	SAME_AS_SRC,
		0);

   param_item = panel_create_item(params, PANEL_MESSAGE,
   		PANEL_LABEL_STRING,     "FTP Parameters",
                PANEL_LABEL_X,          ATTR_COL(0),
                PANEL_LABEL_Y,          ATTR_ROW(++row),
		PANEL_EVENT_PROC,	dummy_event_proc,
                0);
   stru_item = panel_create_item(params, PANEL_CHOICE,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		stru_attr,
		0);
   mode_item = panel_create_item(params, PANEL_CHOICE,
		ATTR_LIST,		mode_attr,
		0);
   type_item = panel_create_item(params, PANEL_CHOICE,
		ATTR_LIST,              type_attr,
		0);
		
   format_item = panel_create_item(params, PANEL_CHOICE,
		ATTR_LIST,              form_attr,
		0);
   byteSize_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,              byte_attr,
   		PANEL_LABEL_X,		(int)panel_get(format_item, 
						PANEL_LABEL_X),
		PANEL_LABEL_Y,
					(int)panel_get(format_item, 
						PANEL_LABEL_Y),
		0);
   multiple_item = panel_create_item(params, PANEL_CHOICE,
   		PANEL_LABEL_X,		ATTR_COL(indent),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,              mult_attr,
		0);
   append_item = panel_create_item(params, PANEL_CHOICE,
		ATTR_LIST,              app_attr,
		0);
   stou_item = panel_create_item(params, PANEL_CHOICE,
		ATTR_LIST,              stou_attr,
		0);

   window_fit(params);
   window_fit(tool_frame);
} /* create_param_items */

static void
tool_help(name)
   char *name;
{
   fprintf(stderr,"Background File Transfer Program\n\n");
   frame_cmdline_help(name);
}

static Notify_value
clear_text(frame, status)
   Frame frame;
   Destroy_status status;
{
   if (fts_pid) {
      kill(fts_pid, SIGKILL);
      fts_pid = 0;
      }
   window_destroy(frame);
}

static void
close_proc()
{
   window_set(tool_frame, FRAME_CLOSED, TRUE, 0);
   quit_popup();
}

main(argc, argv)
   int argc;
   char *argv;
{
   Menu menu;
   Menu_item close_item;
   char frame_label[40];

   init_help();
   init_user();
   init_req(&req);

   init_src_file_menu();
   init_login_menu();
   init_passw_menu();
   init_host_menu();
   init_port_menu();
   init_attr_lists();
   
   strcpy(frame_label, "BFTP Tool  ");
   strcat(frame_label, version);
   tool_frame = window_create(NULL, FRAME,
   		FRAME_LABEL, 		 frame_label,
		FRAME_ICON,  		 &bftp_icon, 
		FRAME_CMDLINE_HELP_PROC, tool_help,
		FRAME_ARGS,		 argc, argv,
		WIN_ERROR_MSG,		 "Can't create window.",
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC,	clear_text,
		0);

   menu = (Menu)window_get(tool_frame, WIN_MENU);
   close_item = menu_find(menu, MENU_STRING, "Close", 0);
   menu_set(close_item, MENU_ACTION_PROC, close_proc, 0);
		
   params = window_create(tool_frame, PANEL,
   		PANEL_ITEM_X_GAP,	15,
		0);
   create_param_items(); 
/*
   text_sw = window_create(tool_frame, TEXTSW,
 		WIN_HEIGHT,		ATTR_ROW(20),
		TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
   		TEXTSW_READ_ONLY, 	TRUE,
		0);
   window_fit(text_sw);
   window_fit(tool_frame);
*/

   init_rs_location(ATTR_COL(40),ATTR_ROW(2)); 

   window_main_loop(tool_frame);
   exit(0);
}
