/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *	May, 1991							*
 *									*
 *	Copyright (c) 1991 University of Southern California.		*
 *	All rights reserved.						*
 *									*
 *	Redistribution and use in source and binary forms are permitted	*
 * 	provided that the above copyright notice and this paragraph are	*
 * 	duplicated in all such forms and that any documentation,	*
 * 	advertising materials, and other materials related to such	*
 * 	distribution and use acknowledge that the software was		*
 *	developed by the University of Southern California, Information	*
 *	Sciences Institute.  The name of the University may not be used *
 *	to endorse or promote products derived from this software 	*
 * 	without specific prior written permission.			*
 *	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR	*
 * 	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
 * 	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 	*
 * 	PURPOSE.							*
 *									*
 ************************************************************************/

/*
 *	bftp.h
 */

/* --- Customize these parameters for your site! --- */

#ifdef SPARC
#define FXPATH "/nfs/u5/deschon/bftp/sparc/fts"    /* used in bftp & bftptool */
#define BFTPPATH "/nfs/u5/deschon/bftp/sparc/bftp" /* used in bftpd */
#else
#ifdef SUNOS4
#define FXPATH "/nfs/u5/deschon/bftp/sunos4/fts"    /* used in bftp & bftptool */
#define BFTPPATH "/nfs/u5/deschon/bftp/sunos4/bftp" /* used in bftpd */
#else
#ifdef BSD4_3
#define FXPATH "/nfs/u5/deschon/bftp/vax/fts"
#define BFTPPATH "/nfs/u5/deschon/bftp/vax/bftp"
#else
#define FXPATH "/nfs/u5/deschon/bftp/sunos3/fts"    /* used in bftp & bftptool */
/* (was /nfs/u3/pd/bin/fts) */
#define BFTPPATH "/nfs/u5/deschon/bftp/sunos3/bftp" /* used in bftpd */
#endif
#endif
#endif
#define MAILPATH "/usr/ucb/mail"	/* used by fts */
#define SITESTR "isi.edu"	    /* default mailbox = login@sitestr */

/* ------------------------------------------------- */

#ifdef SYSV
/*
 * This is the name of the file used to keep track of bftp job names
 * and the jobnames that at assigns to them.
 */
#define JOBDATABASE	".bftpjobs"
#define JOBBASETEMP	".bftpjobtemp"
#define JOBNAMELEN	20
#endif /* SYSV */

#ifndef MAXPATHLEN
#define MAXPATHLEN	1024
#endif 

#ifndef SYSV
#define REQPREFIX "bftp"
#define SAVEPREFIX "bftp-save"
#else /* SYSV */
/* System V filenames are limited to 14 characters */
#define REQPREFIX "b"
#define SAVEPREFIX "s"
#endif /* SYSV */

#define NULLSTR	""

#define DEFAULT_BYTESZ 8
#define DEFAULT_PORT 21

#define boolean int

#ifndef FALSE
#define FALSE		0		/* logical false */
#define TRUE		!FALSE		/* logical true */
#endif

#define COPY 0		/* transfer mode */
#define MOVE 1
#define DFILE 2
#define VERIFY 3
#define VERIFY_SRC 4

#define APPE 0		/* creation mode */
#define STOR 1
#define STOU 2

#define DST 0
#define SRC 1

#define ASCII 0
#define EBCDIC 1
#define IMAGE 2
#define LOCAL 3
#define NOTYPE 4

#define NONPRINT 0
#define TELNET 1
#define CCNTRL 2
#define NOFORM 3

#define STREAM 0
#define BLOCK 1
#define COMP 2
	
#define FIL 0
#define RECORD 1
#define PAGE 2

#define MAXLEN 100	/* standard string length */
#define MAX_SAVES 50	/* max number of save files shown */

#ifdef	CRAY
#define	hostinfo	my_hostinfo
#endif

struct hostinfo {
	char	host[MAXLEN];	/* Domain name of FTP server host */
	char	user[MAXLEN];	/* User name for login */
	char	passwd[MAXLEN];	/* Password for login */
	char	acct[MAXLEN];	/* Account for login */
	char	dir[MAXLEN];	/* Pathname - directory part */
	char	file[MAXLEN];	/* Pathname - file part */
	short	port;		/* Port number to use */
};

struct fileinfo {
	char 	filetype[10],	/* Ascii plus form, Ebcdic plus form,
				  (form = Non-print, Telnet, 
				  			or Carriage-control)
				  Image, or Local plus Byte-size */
		stru,		/* File, Record, or Page */
		mode;		/* Stream, Block, Compressed */
	int  	reqtype,	/* COPY, MOVE, DFILE, VERIFY, NOMODE */
		creation,	/* STOR, STOU, APPE */
		multflag;	
};

struct reqinfo {
	char 	rpasswd[MAXLEN],
		mailbox[MAXLEN],
		mailfile[MAXLEN],	/* *** MAXPATHLEN ? */
		cmdfile[MAXLEN]; 	/* *** MAXPATHLEN ? */
	int	interval,
		ntries;
};

struct conninfo {
	int   socket ;	/* Socket number */
	FILE *fpin ;         /* File Pointer for input side of Telnet conn*/
	FILE *fpout ;        /* File Pointer for output side */
};
