/* vox.c - simple silence-deletion filter
**
** Copyright (C) 1989 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "libst.h"

#define abs(a) ((a) >= 0 ? (a) : -(a))

#define Q_DELTA 100
#define Q_SAMPLES 512
#define MYBUFSIZ 256

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *f;
    char mybuf[MYBUFSIZ];
    int c, lc, plc, q;

    if ( argc == 1 )
	f = stdin;
    else if ( argc == 2 )
	{
	f = fopen( argv[1], "r" );
	if ( f == NULL )
	    {
	    perror( argv[1] );
	    exit( 1 );
	    }
	}
    else
	{
	fprintf( stderr, "usage:  %s [<file>]\n", argv[0] );
	exit( 1 );
	}
    setbuffer( stdout, mybuf, MYBUFSIZ );

    q = 0;
    for ( plc = 0; (c = getc( f )) != EOF; plc = lc )
	{
	lc = st_ulaw_to_linear( c );
	if ( abs( plc - lc ) <= Q_DELTA )
	    q++;
	else
	    q = 0;

	if ( q < Q_SAMPLES )
	    putchar( (unsigned char) c );
	else if ( q == Q_SAMPLES )
	    fflush( stdout );
	}

    exit( 0 );
    }
