/* tones.c - play sine-wave tones on the speaker
**
** Copyright (C) 1989 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <fcntl.h>
#include "libsst.h"

main( argc, argv )
int argc;
char *argv[];
    {
    int sst_fd, dhz1, dhz2, thz, rhz;

    if ( argc < 2 || argc > 5 )
	{
	fprintf( stderr, "usage:  %s <dhz1> [<dhz2> [<thz> [<rhz>]]]\n", argv[0] );
	exit( 1 );
	}
    dhz1 = atoi( argv[1] );
    dhz2 = thz = rhz = 0;
    if ( argc > 2 )
	{
	dhz2 = atoi( argv[2] );
	if ( argc > 3 )
	    {
	    thz = atoi( argv[3] );
	    if ( argc > 4 )
		{
		rhz = atoi( argv[4] );
		}
	    }
	}

    sst_fd = sst_open( );

    sst_tones( sst_fd, dhz1, dhz2, thz, rhz, 1000000 );

    sst_close( sst_fd );
    exit( 0 );
    }
