/* record.c - record from the microphone input
**
** Copyright (C) 1989 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/signal.h>
#include "libsst.h"

#define MYBUF 256

int sst_fd;

main( argc, argv )
int argc;
char *argv[];
    {
    int rrtn, wrtn;
    unsigned char buf[MYBUF];
    int file_fd;
    int sighandler();

    sst_fd = sst_open( );
    file_fd = 1;
    (void) signal( SIGHUP, sighandler );
    (void) signal( SIGINT, sighandler );

    if ( ioctl( sst_fd, AUDIOREADSTART, &rrtn ) < 0 )
	{
	perror( "AUDIOREADSTART" );
	exit( 1 );
	}

    for ( ; ; )
	{
	rrtn = read( sst_fd, buf, MYBUF );
	if ( rrtn < 0 )
	    {
	    perror( "read" );
	    exit( 1 );
	    }
	if ( rrtn == 0 )
	    break;

	wrtn = write( file_fd, buf, rrtn );
	if ( wrtn < 0 )
	    {
	    perror( "write" );
	    exit( 1 );
	    }
	if ( wrtn != rrtn )
	    {
	    fprintf( stderr, "record: rrtn = %d, wrtn = %d\n", rrtn, wrtn );
	    exit( 1 );
	    }
	}

    sst_close( file_fd );
    exit( 0 );
    }

int
sighandler( )
    {
    sst_close( sst_fd );
    exit( 1 );
    }
