dnl -*- Autoconf -*-
dnl Copyright (C) 2002-2008 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Sam Steingold.

AC_PREREQ(2.61)

AC_DEFUN([CL_SIGSEGV], [dnl
  dnl Prerequisites of AC_LIB_LINKFLAGS_BODY.
  AC_REQUIRE([AC_LIB_PREPARE_PREFIX])
  AC_REQUIRE([AC_LIB_RPATH])

  dnl Search for libsigsegv and define LIBSIGSEGV, LTLIBSIGSEGV and INCSIGSEGV
  dnl accordingly.
  AC_LIB_LINKFLAGS_BODY([sigsegv])

  dnl Add $INCSIGSEGV to CPPFLAGS before performing the following checks,
  dnl because if the user has installed libsigsegv and not disabled its use
  dnl via --without-libsigsegv-prefix, he wants to use it.
  cl_save_CPPFLAGS="$CPPFLAGS"
  AC_LIB_APPENDTOVAR([CPPFLAGS], [$INCSIGSEGV])

  AC_CACHE_CHECK(for libsigsegv, cl_cv_lib_sigsegv, [dnl
    cl_cv_lib_sigsegv="no, consider installing GNU libsigsegv"
    cl_save_LIBS="$LIBS"
    LIBS="$LIBS $LIBSIGSEGV"
    AC_LINK_IFELSE([AC_LANG_PROGRAM([#include <sigsegv.h>],
      [sigsegv_deinstall_handler();])], [cl_cv_lib_sigsegv=yes])
    LIBS="$cl_save_LIBS"
  ])
  if test "$cl_cv_lib_sigsegv" = yes; then
    AC_DEFINE(HAVE_SIGSEGV, 1, [Define if you have the libsigsegv library.])
    AC_MSG_CHECKING([how to link with libsigsegv])
    AC_MSG_RESULT([$LIBSIGSEGV])
  else
    dnl If $LIBSIGSEGV didn't lead to a usable library, we don't need
    dnl $INCSIGSEGV either.
    CPPFLAGS="$cl_save_CPPFLAGS"
    LIBSIGSEGV=
    LTLIBSIGSEGV=
  fi
  AC_SUBST(LIBSIGSEGV)
  AC_SUBST(LTLIBSIGSEGV)
])
