/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uMalloc.c -- Cover routines for UNIX storage management routines.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:15:54 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Fri Mar  1 15:52:15 1991
 * Update Count     : 43
 */

#define __U_KERNEL__

#include "uUnix.h"
#include "uSystem.h"
#include "uKernel.i"

#if defined( __sgi__ )

#define shmalloc malloc
#define shfree free
#define shrealloc realloc

#elif defined( __encore__ )

#define shmalloc share_malloc
#define shfree share_free
#define shrealloc share_realloc

    void *share_realloc( void *old, int size ) {
	uNoExtendExMsg msg;

	msg.head.msg = "uRealloc: Shared memory reallocation not available.\n";
	msg.head.size = size;
	msg.addr = old;

	uRaise( uThisCoroutine(), &uNoExtendEx, &msg, sizeof( msg ) );

	return 0;
    } /* share_realloc */

#endif

inline void *uLowMalloc( int size ) {

    void *addr;

#ifdef __U_MULTI__
    addr = shmalloc( size );
#else
    addr = malloc( size );
#endif

    return addr;
} /* uLowMalloc */

inline void uLowFree( void *addr ) {

#ifdef __U_MULTI__
    shfree( addr );
#else
    free( addr );
#endif
} /* uFree */

inline void *uLowRealloc( void *addr, int size ) {

#ifdef __U_MULTI__
    addr = shrealloc( addr, size );
#else
    addr = realloc( addr, size );
#endif

    return addr;
} /* uRealloc */

void *uMalloc( int size ) {

    void *addr = uLowMalloc( size );

#ifdef __U_DEBUG__
    if ( addr == NULL ) {
	uOutOfMemoryExMsg msg;

	msg.msg = "uMalloc: OUT OF MEMORY.\n";
	msg.size = size;

	uRaise( uThisCoroutine(), &uOutOfMemoryEx, &msg, sizeof( msg ) );
    } /* if */
#endif

    return addr;
} /* uMalloc */

void uFree( void *addr ) {
    uLowFree( addr );
} /* uFree */

void *uRealloc( void *addr, int size ) {

    addr = uLowRealloc( addr, size );

#ifdef __U_DEBUG__
    if ( addr == NULL ) {
	uNoExtendExMsg msg;

	msg.head.msg = "uRealloc: OUT OF MEMORY.\n";
	msg.head.size = size;
	msg.addr = addr;

	uRaise( uThisCoroutine(), &uNoExtendEx, &msg, sizeof( msg ) );
    } /* if */
#endif

    return addr;
} /* uRealloc */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
