/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cd-sgi-irix-mips.i -- vendor dependent locking mechanisms
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:32:43 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:01 1990
 * Update Count     : 77
 */

#include "configure/stdarg-mips.h"

#include "configure/vd-sgi.i"
#include "configure/os-irix.i"
#include "configure/md-mips.i"

/*
 * If hardware locks are available, define the following macro.
 */

/* #define __SGI_HARDWARE_LOCK__ */

#include <ulocks.h>

#ifdef __U_MULTI__

#define NUM_SGI_LOCKS 128				/* must be a power of 2 */

static ulock_t sgi_locks[NUM_SGI_LOCKS];
static char ArenaFileName[L_tmpnam];

#endif

static inline void uCreateLocks( void ) {

#ifdef __U_MULTI__
    
    int i;
    usptr_t *LockArena;
    
    tmpnam( ArenaFileName );				/* create a temporary file name for the locks */
    /* usconfig( CONF_INITSIZE, 8 * 1024 ); */		/* room for locks */
    usconfig( CONF_INITUSERS, 64 );			/* maximum number of sproc processes that can access the shared memory */
    LockArena = usinit( ArenaFileName );		/* initialize lock file */
    if ( LockArena == NULL ) {
	uError( "uCreateLocks(): could not allocate the lock arena:%s.\n", ArenaFileName );
    } /* if */
    
    for ( i = 0; i < NUM_SGI_LOCKS; i += 1 ) {
	sgi_locks[i] = usnewlock( LockArena );
	if ( sgi_locks[i] == NULL ) {
	    uError( "uCreateLocks(): could only allocate %d of the desired %d shared locks.\n", i, NUM_SGI_LOCKS );
	} /* if */ 
   } /* for */

#endif
    
} /* uCreateLocks */

static inline void uDestroyLocks( void ) {

#ifdef __U_MULTI__

    int code;

    code = unlink( ArenaFileName );
    if ( code != 0 ) {
	uError( "uDestroyLocks(): could not de-allocate lock arena:%s.\n", ArenaFileName );
    } /* if */

#endif

} /* uDestroyLocks */

/*
 * The following function, uAcquireLock(), is derived from page C-7 of
 * "The Guide to Parallel Programming", 2nd. Edition, Sequent Computer Systems.
 */

static inline void uAcquireLock( uLock *mutex ) {

#ifdef __U_MULTI__

    /*
     * Use a simple hash function that uses the address of the software lock to compute the index
     * to a hardware lock.  This function assumes that the software lock is aligned on a 4-byte
     * boundary, and discards the lower 2 bites by shifting.
     */

    ulock_t lock = sgi_locks[ ( (int)mutex >> 2 ) & ( NUM_SGI_LOCKS - 1 ) ]; /* select a hardware lock */

    for( ;; ) {
	while ( *mutex == U_LOCKED ) {			/* wait for software lock to be available */
	    /* spin */
	} /* while */
#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	while ( *(int *)lock & 1 ) {			/* grab hardware lock */
	    /* spin */
	} /* while */
#else
	ussetlock( lock );
#endif
      if ( *mutex == U_UNLOCKED ) break;		/* can race with others trying to get the lock */
#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	*(int *)lock = 0;				/* lost race, try again */
#else
	usunsetlock( lock );
#endif
    } /* for */

#ifdef __SGI_HARDWARE_LOCK__
    /* faster but non-portable test-and-set code */
    *mutex = U_LOCKED;					/* no race, or won it, so grab the lock */
    *(int *)lock = 0;
#else
    *mutex = U_LOCKED;					/* no race, or won it, so grab the lock */
    usunsetlock( lock );
#endif

#endif

} /* uAcquireLock */

static inline void uReleaseLock( uLock *mutex ) {

#ifdef __U_MULTI__
    
    /*
     * This function causes a task to release a lock.
     */

    *mutex = U_UNLOCKED;				/* release the lock */

#endif

} /* uReleaseLock */
