/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cd-sequent-bsd43-i386.i -- vendor dependent locking mechanisms
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:38:01 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:31:38 1990
 * Update Count     : 4
 */

#include <stdarg.h>

#include "configure/vd-sequent.i"
#include "configure/os-bsd43.i"
#include "configure/md-i386.i"

#ifdef __U_MULTI__

static inline uLock uTestAndSet( uLock *mutex ) {

    /*
     * This function sets the value of a lock to U_LOCKED and
     * returns its old value.
     */
    
    uLock result;
    
    asm volatile ( "movl %2, %0; xchgl %0, (%1)" : "=r" (result) : "r" (mutex), "i" (U_LOCKED) );

    return result;
}

#endif

static inline void uCreateLocks( void ) {
}

static inline void uDestroyLocks( void ) {
}

static inline void uAcquireLock( uLock *mutex ) {

    /*
     * This function causes a task to spin
     * until it can acquire a lock.
     * These locks should ony be used in cases
     * where the amount of work to be done is
     * small, since other tasks will be wasting
     * cycles while attempting to obtain the lock.
     */

#ifdef __U_MULTI__

    while( uTestAndSet( mutex ) == U_LOCKED ) {		    /* test and set the lock, if lock was already set, try again */
	while( *mutex == U_LOCKED ) {			    /* read the lock until it becomes unlocked, reduces bus traffic */
	    /* spin */
	} /* while */
    } /* while */

#endif

} /* uAcquireLock */

static inline void uReleaseLock( uLock *mutex ) {

    /*
     * This function causes a task to release a lock.
     */

#ifdef __U_MULTI__

    /* release the lock */
    *mutex = U_UNLOCKED;

#endif

} /* uReleaseLock */
