
#include <uSystem.h>

#define N 20
#define W 6

int mata[N][N];
int matb[N][N];
int matc[N][N];

uTask worker[N][N];

void uPrintMatrix( int mat[N][N] ) {
    int row;
    int col;

    for ( row = 0; row < N; row++ ) {
	uPrintf( "%2d:", row );
	for( col = 0; col < N; col++ ) {
	    uPrintf( " %5d", mat[row][col] );
	}
	uPrintf( "\n" );
    }
    uPrintf( "\n" );
}

void uSum( int row, int col ) {
    int i;
    int sum;

    sum = 0;
    for ( i = 0; i < N; i++ ) {
	sum += ( mata[row][i] * matb[i][col] );
    }

    matc[row][col] = sum;

    uDie( NULL, 0 );
}

void uMain() {
    int row;
    int col;
    
    uPrintf( "Starting initialization.\n" );
    
    for ( row = 0; row < N; row++ ) {
	for ( col = 0; col < N; col++ ) {
	    mata[row][col] = row + col;
	    matb[row][col] = row - col;	    
	}
    }

    uPrintf( "Finished initialization.\n" );

    uPrintMatrix( mata );
    uPrintMatrix( matb );

    uSetProcessors( W );

    uPrintf( "Starting to multiply with %d workers.\n", uGetProcessors() );

    for ( row = 0; row < N; row++ ) {
	for ( col = 0; col < N; col++ ) {
	    worker[row][col] = uEmit( uSum, row, col );
	}
    }

    uPrintf( "Wait for workers to complete multiplication\n" );
    for ( row = 0; row < N; row++ ) {
	for ( col = 0; col < N; col++ ) {
	    uAbsorb( worker[row][col], NULL, 0 );
	}
    }

    uPrintf( "Finished multiplying.\n\n" );

    uPrintMatrix( matc );
    
    uDie( NULL, 0 );
}

/* Local Variables: */
/* compile-command: "concc -multi -work -O Matrix.c" */
/* End: */
