/* Copyright (c) 1989  P. A. Buhr */

/*
  Produce the fibonacci numbers in sequence on each call.
  
  No explicit states, communication with argument-parameter
  mechanism between suspend and resume
  */

#include <uSystem.h>

void printf( char *, ... );

void fibonacci() {
    int fn, fn1, fn2;

    fn = 1;						/* 1st case */
    fn1 = fn;
    uSuspend(NULL, 0, &fn, sizeof(fn));
    fn = 1;						/* 2nd case */
    fn2 = fn1;
    fn1 = fn;
    uSuspend(NULL, 0, &fn, sizeof(fn));
    for (;;) {						/* general case */
        fn = fn1 + fn2;
        fn2 = fn1;
        fn1 = fn;
	uSuspend(NULL, 0, &fn, sizeof(fn));
    } /* for */
} /* fibonacci */

#define NoOfFibs 10

void uMain() {
    uCoroutine c;
    int i, fn;

    printf("Fibonacci Numbers\n");
    c = uCocall(&fn, sizeof(fn), fibonacci);
    for (i = 1; ; i += 1) {
	printf("%d\n", fn);
    if (i >= NoOfFibs) break;
        uResume(c, &fn, sizeof(fn), NULL, 0);
    } /* for */
    printf("successful completion\n");
} /* uMain */
