/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uBench.c -- This program performs a benchmark test on the concurrency facilities
 *    of UNIX. It will run on the BSD and System V OSs.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Feb 13 11:06:19 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:24:32 1990
 * Update Count     : 21
 */

#include <Time.i>
#include <stdio.h>
#include <sys/wait.h>

extern int fork( void );
extern void exit( int );
extern int getpid( void );
extern int wait( union wait * );
extern int pipe( int fildes[] );
extern int open( char *, int, int );
extern int close( int );
extern int read( int, char *, int );
extern int write( int, char *, int );
extern int printf( char *, ... );
extern int fflush( FILE * );

void ProcessCreateDelete( int N ) {
    int StartTime, EndTime;
    int i;
    int pid;
    
    fflush(stdout);					/* flush standard output */
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	pid = fork();
	if ( pid == 0 ) {				/* child ? */
	    /* printf( "child %x\n", getpid() ); */
	    exit ( 0 );
	} /* if */
	pid = wait( (union wait*)0 );			/* wait for child to finish */
	/* printf( "wait %x\n", pid ); */
    } /* for */

    EndTime = Time();
    printf( "& %d", ( EndTime - StartTime ) / N );
} /* ProcessCreateDelete */

#include <sys/file.h>

#define READ	0
#define WRITE	1

void SendReceive( int N ) {
    int StartTime, EndTime;
    int i;
    char SendMsg[16], RecMsg[16];

    int pid;
    int sender[2], replier[2];

    pipe( sender );					/* create 2 pipes */
    pipe( replier );

    fflush(stdout);					/* flush standard output */
    pid = fork();					/* fork a child process */
    
    if ( pid == 0 ) {
	/* receiver */

	close( sender[WRITE] );				/* close write end of sender pipe */
	close( replier[READ] );				/* close read end of replier pipe */

	for ( i = 0; i < N; i += 1 ) {
	    read( sender[READ], RecMsg, sizeof(RecMsg) ); /* read message from sender */
	    /* printf( "child msg:%s\n", RecMsg ); */
	    /* RecMsg[0] += 1; */
	    write( replier[WRITE], RecMsg, sizeof(RecMsg) ); /* write reply to sender */
	} /* for */

	close( sender[READ] );				/* close other ends of pipes */
	close( replier[WRITE] );

	exit( 0 );					/* terminate child process */
    } /* if */
    /* sender */

    close( sender[READ] );				/* close read end of sender pipe */
    close( replier[WRITE] );				/* close write end of replier pipe */

    /* SendMsg[0] = 'a'; */
    /* SendMsg[1] = '\0'; */
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	write( sender[WRITE], SendMsg, sizeof(SendMsg) ); /* write message to receiver */
	read( replier[READ], SendMsg, sizeof(SendMsg) ); /* read reply from receiver */
	/* printf( "parent msg:%s\n", SendMsg ); */
    } /* for */

    EndTime = Time();
    printf( "\t& %d", ( EndTime - StartTime ) / N );
    
    pid = wait( (union wait*)0 );			/* wait for child to finish */
    close( sender[WRITE] );				/* close other ends of pipes */
    close( replier[READ] );
} /* SendReceive */

struct TestStruct {
    char msg[16];
}; /* TestStruct */

void TestProc( struct TestStruct inmsg, struct TestStruct *outmsg ) {
    *outmsg = inmsg;
} /* TestProc */

void main() {
    const int NoOfTimes = 10000;

    int StartTime, EndTime;
    int i;

    struct TestStruct inmsg, outmsg;

    printf( "process\tsend/rec/reply,\tproc call\n" );
    printf( "create/\t16 bytes\t16 bytes\n" );
    printf( "delete\tbidirectional\tbidirectional\n" );


    ProcessCreateDelete( NoOfTimes );

    SendReceive( NoOfTimes );
    
    StartTime = Time();

    for ( i = 0; i < NoOfTimes ; i+= 1 ) {
	TestProc( inmsg, &outmsg );
    } /* for */

    EndTime = Time();
    printf( "\t\t& %d", ( EndTime - StartTime ) / NoOfTimes );

    printf( "\t\\\\\n" );
} /* main */

/* Local Variables: */
/* compile-command: "gcc -O UNIXBench.c" */
/* End: */
