/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/msdos/RCS/runargv.c,v 1.2 90/10/30 23:16:02 dvadura Exp $
-- SYNOPSIS -- run a sub process.
-- 
-- DESCRIPTION
--	Use spawn to run a subprocess.
--
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log:	runargv.c,v $
 * Revision 1.2  90/10/30  23:16:02  dvadura
 * Added #if for _MSC_VER.
 * 
 * Revision 1.1  90/10/06  12:05:30  dvadura
 * dmake Release, Version 3.6
 * 
*/

#include "sysintf.h"
#include "extern.h"
#include <process.h>
#include <string.h>
#include <errno.h>

static int  _abort_flg = FALSE;
static void _add_child ANSI((CELLPTR, HOWPTR, int));
static void _finished_child ANSI((int));

int
runargv(target, how, ignore, group, last, shell, cmd)
CELLPTR target;
HOWPTR  how;
int     ignore;
int	group;
int	last;
int	shell;
char	*cmd;
{
#if ! defined(_MSC_VER)
   extern char **environ;
#endif
   int status;
   char **argv;

   argv = Pack_argv( group, shell, cmd );
   _add_child(target, how, ignore);
   status = spawnvpe(P_WAIT, *argv, argv, environ);
   if( status == -1 ) Error("%s: %s", argv[0], strerror(errno));
   _finished_child(status);
   if( last && !Doing_bang ) Update_time_stamp( target, how );

   return( 0 );
}


void
Clean_up_processes()
{
   _abort_flg = TRUE;
   _finished_child(-1);
}


int
Wait_for_child( abort_flg, pid )
int abort_flg;
int pid;
{
   return(1);
}


static int     _valid = -1;
static CELLPTR _tg;
static HOWPTR  _how;
static int     _ignore;

static void
_add_child( target, how, ignore )
CELLPTR target;
HOWPTR  how;
int	ignore;
{
   _tg = target;
   _ignore = ignore;
   _how    = how;
   _valid = 0;

   Current_target = NIL(HOW);
}


static void
_finished_child(status)
int	status;
{
   if( _valid == -1 ) return;
   Unlink_temp_files( _how );
   _valid = -1;
   Handle_result( status, _ignore, _abort_flg, _tg );
}
