/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/RCS/extern.h,v 1.1 90/10/06 12:04:24 dvadura Exp $
-- SYNOPSIS -- external declarations for dmake functions.
-- 
-- DESCRIPTION
--	ANSI is a macro that allows the proper handling of ANSI style
--	function declarations.
-- 
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log:	extern.h,v $
 * Revision 1.1  90/10/06  12:04:24  dvadura
 * dmake Release, Version 3.6
 * 
*/

#ifndef EXTERN_h
#define EXTERN_h

#include "vextern.h"
#include <stdlib.h>
#include <string.h>

extern	void	Add_dfa ANSI((char *));
extern	void	Add_fringe ANSI((CELLPTR));
extern	void	Add_recipe_to_list ANSI((char *, int, int));
extern	LINKPTR	Add_prerequisite ANSI((HOWPTR, CELLPTR, int));
extern	char*	Apply_edit ANSI((char *, char *, char *, int, int));
extern	void	Append_line ANSI((char*, int, FILE*, char*, int, int));
extern	char*	basename ANSI((char*));
extern	void	Bind_rules_to_targets ANSI((int));
extern	char*	Build_path ANSI((char *, char *));
extern	void 	Catch_signals ANSI((void (*)()));
extern	void	Check_circle ANSI((LINKPTR));
extern	void	Check_circle_dfa ANSI(());
extern	void	Clear_prerequisites ANSI((HOWPTR));
extern	void	Clear_signals ANSI(());
extern  void	Clean_up_processes ANSI(());
extern	FILE*	Closefile ANSI(());
extern  void    Close_temp ANSI((HOWPTR, FILE *));
extern	void	Create_macro_vars ANSI(());
extern	DFAPTR	Construct_dfa ANSI((char *));
extern	CELLPTR	Def_cell ANSI((char *, CELLPTR));
extern	HASHPTR	Def_macro ANSI((char *, char *, int));
extern	STRINGPTR	Def_recipe ANSI((char *, STRINGPTR, int, int));
extern	int 	Do_cmnd ANSI((char *, int, int, CELLPTR, HOWPTR, int,int,int));
extern	time_t	Do_stat ANSI((char *, char *, char **));
extern	time_t	Do_time ANSI(());
extern	int	Do_touch ANSI((char *, char *, char **));
extern	void	Dump ANSI(());
extern	void	Dump_recipe ANSI((STRINGPTR));
extern	void 	Epilog ANSI((int));
extern  char*   Exec_function ANSI((char *));
extern	char*	Expand ANSI((char *));
extern  CELLPTR Explode_cell ANSI((CELLPTR, CELLPTR));
extern  HOWPTR  Explode_how ANSI((HOWPTR, CELLPTR, int));
extern  LINKPTR Explode_prq ANSI((LINKPTR, CELLPTR, int));
extern  char*   Filename ANSI(());
extern	char*	Get_current_dir ANSI(());
extern	int	Get_line ANSI((char *, FILE *));
extern	HASHPTR	Get_name ANSI((char *, HASHPTR *, int, CELLPTR));
extern	char*	Get_suffix ANSI((char *));
extern	char	Get_switch_char ANSI(());
extern	char*	Get_token ANSI((TKSTRPTR, char *, int));
extern	uint16	Hash ANSI((char *,uint32 *));
extern  void    Handle_result ANSI((int, int, int, CELLPTR));
extern	int	If_root_path ANSI((char *));
extern	CELLPTR	Infer_recipe ANSI((CELLPTR, HOWPTR, DFASETPTR, CELLPTR));
extern	int	Macro_op ANSI((char *));
extern	int	Make ANSI((CELLPTR, HOWPTR, CELLPTR));
extern	void	Make_rules ANSI(());
extern  void	Map_esc ANSI((char *));
extern	DFALINKPTR	Match_dfa ANSI((char *));
extern	char*	My_malloc ANSI((unsigned int, char *, int));
extern	char*	My_calloc ANSI((unsigned int, unsigned int, char *, int));
extern	void	My_free ANSI((char *, char *, int));
extern  void	No_ram ANSI(());
extern	FILE*	Open_temp ANSI((char **, char *));
extern	FILE*	Openfile ANSI((char *, int));
extern  char**  Pack_argv ANSI((int, int, char *));
extern	void	Parse ANSI((FILE *));
extern	int	Parse_macro ANSI((char *, int));
extern	int	Parse_rule_def ANSI((int *));
extern	void	Pop_dir ANSI((int));
extern	void	Prolog ANSI((int, char **));
extern	int	Push_dir ANSI((CELLPTR, int));
extern	void	Quit ANSI(());
extern	char*	Read_env_string ANSI((char *));
extern	void	ReadEnvironment ANSI(());
extern  void	Remove_prq ANSI((CELLPTR));
extern	int	Rule_op ANSI((char *));
extern	int	runargv ANSI((CELLPTR, HOWPTR, int, int, int, int, char *));
extern	time_t	seek_arch ANSI((char*, char*));
extern	int	Set_dir ANSI((char *));
extern	int	Set_group_attributes ANSI((char *));
extern	void	Stat_target ANSI((CELLPTR, int));
extern  FILE*   Start_temp ANSI((char *, CELLPTR, HOWPTR, char **));
extern	int	Test_circle ANSI((CELLPTR, int));
extern	int	touch_arch ANSI((char*, char*));
extern  void    Unlink_temp_files ANSI((HOWPTR));
extern  void	Update_time_stamp ANSI((CELLPTR, HOWPTR));
extern  void    Void_lib_cache ANSI((char *, char *));
extern  int	Wait_for_child ANSI((int, int));
extern	int	Write_env_string ANSI((char *, char *));

extern	char*	_stradd ANSI((char *,char *, int));
extern	char*	_strapp ANSI((char *,char *));
extern	char*	_strjoin ANSI((char *,char *,int, int));
extern	char*	_strdup ANSI((char *));
extern	char*	_strpbrk ANSI((char *,char *));
extern	char*	_strspn ANSI((char *,char *));
extern	char*	_strstr ANSI((char *,char *));
extern	char*	_substr ANSI((char *,char *));

/* Include this last as it invalidates some functions that are defined
 * externally above and turns them into no-ops.  Have to do this after
 * the extern declarations however. */
#include "config.h"

#endif

