/* RCS      -- $Header: /u2/dvadura/src/generic/dmake/src/RCS/dump.c,v 1.2 90/10/30 23:06:05 dvadura Exp $
-- SYNOPSIS -- dump the internal dag to stdout.
-- 
-- DESCRIPTION
--	This file contains the routine that is called to dump a version of
--	the digested makefile to the standard output.  May be useful perhaps
--	to the ordinary user, and invaluable for debugging make.
-- 
-- AUTHOR
--      Dennis Vadura, dvadura@watdragon.uwaterloo.ca
--      CS DEPT, University of Waterloo, Waterloo, Ont., Canada
--
-- COPYRIGHT
--      Copyright (c) 1990 by Dennis Vadura.  All rights reserved.
-- 
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      (version 1), as published by the Free Software Foundation, and
--      found in the file 'LICENSE' included with this distribution.
-- 
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warrant of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
-- 
--      You should have received a copy of the GNU General Public License
--      along with this program;  if not, write to the Free Software
--      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
-- LOG
--     $Log:	dump.c,v $
 * Revision 1.2  90/10/30  23:06:05  dvadura
 * #include db.h after including other includes first.
 * 
 * Revision 1.1  90/10/06  12:03:37  dvadura
 * dmake Release, Version 3.6
 * 
*/

#include "extern.h"
#include "db.h"

#define M_TEST	(M_PRECIOUS | M_VAR_MASK)

static	void	dump_normal_target ANSI((CELLPTR, HOWPTR, CELLPTR));
static	void	dump_graph_node ANSI((CELLPTR));
static	void	dump_name ANSI((HASHPTR, int));


void
Dump()/*
========  Dump onto standard output the digested makefile.  Note that
	  the form of the dump is not representative of the contents
	  of the original makefile contents at all */
{
   HASHPTR      hp;
   int          i;

   DB_ENTER( "Dump" );

   puts( "# Dump of dmake macro variables:" );
   for( i=0; i<HASH_TABLE_SIZE; i++)
      for( hp=Macs[i]; hp != NIL(HASH); hp = hp->ht_next ) {
	 int flag = hp->ht_flag;

	 printf( "%s ", hp->ht_name );
	 if( flag & M_EXPANDED ) putchar( ':' );
	 printf( "= " );
	 if( hp->ht_value != NIL(char) ) printf( hp->ht_value );
	 if( flag & M_PRECIOUS )
	    printf( "\t # PRECIOUS " );
	 putchar( '\n' );
      }

   puts( "\n#====================================" );
   puts( "# Dump of targets:\n" );

   for( i=0; i<HASH_TABLE_SIZE; i++ )
      for( hp = Defs[i]; hp != NIL(HASH); hp = hp->ht_next )
         if( !(hp->CP_OWNR->ce_flag & F_PERCENT) ) {
	    if( hp->CP_OWNR == Fringe_hd->cl_prq )
	       puts( "# ******* FIRST TARGET ********" );
	    dump_normal_target( hp->CP_OWNR, hp->CP_OWNR->CE_HOW, NIL(CELL) );
	 }

   puts( "\n#====================================" );
   puts( "# Dump of inference graph\n" );

   for( i=0; i<HASH_TABLE_SIZE; i++ )
      for( hp = Defs[i]; hp != NIL(HASH); hp = hp->ht_next )
         if( (hp->CP_OWNR->ce_flag & F_PERCENT) &&
	    !(hp->CP_OWNR->ce_flag & F_MAGIC) )
	    dump_graph_node( hp->CP_OWNR );

   DB_VOID_RETURN;
}



void
Dump_recipe( sp )/*
===================
   Given a string pointer print the recipe line out */
STRINGPTR sp;
{
   char *st;
   char *nl;

   if( sp == NIL(STRING) ) return;

   putchar( '\t' );
   if( sp->st_attr & A_SILENT ) putchar( '@' );
   if( sp->st_attr & A_IGNORE ) putchar( '-' );
   if( sp->st_attr & A_SHELL  ) putchar( '+' );

   st = sp->st_string;
   for( nl=strchr(st,'\n'); nl != NIL( char); nl=strchr(st,'\n') ) {
      *nl = '\0';
      printf( "%s\\\n", st );
      *nl = '\n';
      st  = nl+1;
   }
   printf( "%s\n", st );
}


static char *_attrs[] = { ".PRECIOUS", ".SILENT", ".LIBRARY",
   ".EPILOG", ".PROLOG", ".IGNORE", ".SYMBOL", ".NOINFER",
   ".UPDATEALL", ".SEQUENTIAL", ".SETDIR=", ".USESHELL", ".SWAP", ".MKSARGS" };

static void
dump_normal_target( cp, hw, prq )/*
===================================
	Dump in makefile like format the dag information */
CELLPTR cp;
HOWPTR  hw;
CELLPTR prq;
{
   register LINKPTR   lp;
   register STRINGPTR sp;
   t_attr	      attr;
   unsigned int	      k;

   DB_ENTER( "dump_normal_target" );

   if( hw == NIL(HOW) ) { DB_VOID_RETURN; }
   if( hw->hw_next != NIL(HOW) ) dump_normal_target( cp, hw->hw_next, prq );

   dump_name( cp->ce_name, FALSE );

   for( k=0, attr=1; attr <= MAX_ATTR; attr <<= 1, k++ )
      if( (cp->ce_attr & attr) || ((hw->hw_attr & A_SHELL)&attr) ) {
         printf( "%s%s ", _attrs[k],
		 (attr != A_SETDIR) ? "" : (cp->ce_dir?cp->ce_dir:"") );
      }
         
   putchar( ':' );

   if( cp->ce_flag & F_MULTI )  putchar( ':' );
   if( hw->hw_flag & F_SINGLE ) putchar( '!' );
   putchar( ' ' );

   if( prq != NIL(CELL) ) dump_name( prq->ce_name, FALSE );
   for( lp = hw->hw_prq; lp != NIL(LINK); lp = lp->cl_next )
      dump_name( lp->cl_prq->ce_name, FALSE );

   if( (lp = hw->hw_indprq) != NIL(LINK) ) {
      for( ; lp != NIL(LINK); lp = lp->cl_next )
	 dump_name( lp->cl_prq->ce_name, TRUE );
   }

   putchar( '\n' );
   if( hw->hw_flag & F_GROUP ) {
      if( hw->hw_attr & A_IGNORE ) putchar( '-' );
      if( hw->hw_attr & A_SILENT ) putchar( '@' );
      puts( "[" );
   }

   for( sp = hw->hw_recipe; sp != NIL(STRING); sp = sp->st_next )
      Dump_recipe( sp );
   if( hw->hw_flag & F_GROUP ) puts( "]" );

   putchar( '\n' );
   DB_VOID_RETURN;
}


static void
dump_name( hp, quote )/*
========================
	print out a name */
HASHPTR hp;
int     quote;
{
   if( quote ) putchar('\'');
   printf( "%s", hp->ht_name );
   if( quote ) putchar('\'');
   putchar(' ');
}
 


static void
dump_graph_node( cp )/*
=======================*/
CELLPTR cp;
{
   EDGEPTR	pe;

   pe = cp->CE_EDGES; 

   if( pe != NIL(EDGE) )
      do {
	 dump_normal_target( cp, pe->ed_how, pe->ed_prq );
	 pe = pe->ed_next;
      }
      while( pe != cp->CE_EDGES );
}
