case $CONFIG in
'')
	if test ! -f config.sh; then
		ln ../config.sh . || \
		ln ../../config.sh . || \
		ln ../../../config.sh . || \
		ln ../../../../config.sh . || \
		(echo "Can't find config.sh."; exit 1)
	fi 2>/dev/null
	. ./config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile <<!GROK!THIS!
########################################################
##
##   Project:  Tcl Modules
##   Created:  Sep 3 1991
##    Author:  John L. Furlani<john.furlani@East.Sun.COM>
##
##  Description of File:
##	 Makefile for init files
##
##  $Id: Makefile.SH,v 1.4 1993/01/23 02:02:22 jlf Exp $
##
########################################################
##
##	Installation

INSTALL=../myinstall
INITDEST=$modules_init

!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'
INITFILES=  sh \
            bash \
            ksh \
            zsh \
            csh \
            tcsh

sh: sh.SH
	/bin/sh sh.SH
bash: bash.SH
	/bin/sh bash.SH
ksh: ksh.SH
	/bin/sh ksh.SH
zsh: zsh.SH
	/bin/sh zsh.SH
csh: csh.SH
	/bin/sh csh.SH
tcsh: sh.SH
	/bin/sh tcsh.SH
                        
##
##	Install Myself
##
install all: $(INITFILES)
	$(INSTALL) -m 0755 -d $(INITDEST)
	for file in $(INITFILES); do \
	    $(INSTALL) -c -m 0444 $$file $(INITDEST); \
	done

##
##	How to clean up after myself
##
clean:
	rm -f $(INITFILES)

!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile
