/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	91/10/23
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *     The definitions of all of the global accesible functions and data.
 *  Also, all of the defines.
 *	
 * $Log: global.h,v $
 *
 *
 * Revision 1.9  1993/01/29  06:16:57  jlf
 * Added #define for FreeList too so it won't get called since we're
 * not freeing memory.
 *
 * Revision 1.8  1993/01/28  16:22:17  jlf
 * Added a #define which removes all of the calls to free() since modulecmd
 * only runs for a very short time, it only takes extra time to manage the
 * heap and the OS will be cleaning up anyway.
 *
 * Revision 1.7  1993/01/25  18:48:13  jlf
 * Changed the method for keeping and unwinding failed modulefiles.
 * The output returns to its optimized state where only the aggregate
 * changes to the environment are sent to the executing shell.
 *
 * Revision 1.6  1993/01/23  01:01:23  jlf
 * Fixed a number of memory leaks and large static arrays.
 *
 * Revision 1.5  1993/01/22  17:37:35  jlf
 * Added purge sub-command.
 *
 * Revision 1.4  1993/01/21  03:18:51  jlf
 * Turned FORCE_PATH and FORCE_PATHNAME into Configure variables.
 *
 * Revision 1.3  1993/01/20  03:36:15  jlf
 * Updated a number of function prototypes.
 *
 * Revision 1.2  1992/11/18  23:08:07  jlf
 * Added the default defines for the different UNAME command fields.
 *
 * Revision 1.1  1992/11/05  23:26:30  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tclHash.h>
#include "config.h"

/* LocateModule.c */
extern int    Locate_ModuleFile(Tcl_Interp*, char*, char*, char*);
extern char*  GetModuleName(Tcl_Interp*, char*, char*);
extern char** SortedDirList(Tcl_Interp*, char*, char*, int*);
extern char** SplitIntoList(Tcl_Interp*, char*, int*);
extern void   FreeList(char**, int);

/* ModuleCmd_Avail.c */
extern int   ModuleCmd_Avail(Tcl_Interp*, char*[]);
extern void  print_dirents(char*);
extern char* strip_top(char*);

/* ModuleCmd_Clear.c */
extern int   ModuleCmd_Clear(Tcl_Interp*, int, char*[]);

/* ModuleCmd_Display.c */
extern int   ModuleCmd_Display(Tcl_Interp*, char*[]);

/* ModuleCmd_Help.c */
extern int   ModuleCmd_Help(Tcl_Interp*, int, char*[]);
extern int   PerModuleHelp(Tcl_Interp*, int, char*[]);

/* ModuleCmd_Init.c */
extern int   ModuleCmd_Init(Tcl_Interp*, int, char*[]);

/* ModuleCmd_List.c */
extern int   ModuleCmd_List(Tcl_Interp*, char*[]);

/* ModuleCmd_Load.c */
extern int   ModuleCmd_Load(Tcl_Interp*, int, int, char*[]);

/* ModuleCmd_Purge.c */
extern int   ModuleCmd_Purge(Tcl_Interp*, int, char*[]);

/* ModuleCmd_Switch.c */
extern int   ModuleCmd_Switch(Tcl_Interp*, int, char*[]);

/* ModuleCmd_Update.c */
extern int   ModuleCmd_Update(Tcl_Interp*, int, char*[]);

/* ModuleCmd_Use.c */
extern int   ModuleCmd_Use(Tcl_Interp*, int, char*[]);
extern int   ModuleCmd_UnUse(Tcl_Interp*, int, char*[]);

/* cmdAlias.c */
extern int   cmdSetAlias(ClientData, Tcl_Interp*, int, char*[]);

/* cmdConflict.c */
extern int   cmdConflict(ClientData, Tcl_Interp*, int, char*[]);
extern int   cmdPrereq(ClientData, Tcl_Interp*, int, char*[]);

/* cmdInfo.c */
extern int   cmdModuleInfo(ClientData, Tcl_Interp*, int, char*[]);


/* cmdMisc.c */
extern int   cmdSystem(ClientData, Tcl_Interp*, int, char*[]);

/* cmdModule.c */
extern int   cmdModule(ClientData, Tcl_Interp*, int, char*[]);
extern int   Read_Modulefile(Tcl_Interp*, char*);
extern int   Execute_TclFile(Tcl_Interp*, char*);
extern int   CallModuleProcedure(Tcl_Interp*, Tcl_CmdBuf, char*, char*, int);

/* cmdPath.c */
extern int   cmdSetPath(ClientData, Tcl_Interp*, int, char*[]);
extern int   cmdRemovePath(ClientData, Tcl_Interp*, int, char*[]);
extern char* chk_nullvars(char*);

/* cmdSetenv.c */
extern int   cmdSetEnv(ClientData, Tcl_Interp*, int, char*[]);
extern int   moduleSetenv(Tcl_Interp*, char*, char*, int);
extern int   cmdUnsetEnv(ClientData, Tcl_Interp*, int, char*[]);
extern int   moduleUnsetenv(Tcl_Interp*, char*);

/* cmdUname.c */
extern int   cmdUname(ClientData, Tcl_Interp*, int, char*[]);

/* cmdXResource.c */
extern int   cmdXResource(ClientData, Tcl_Interp*, int, char*[]);
extern void  xresourceFinish(int);

/* init.c */
extern int   Initialize_Tcl(Tcl_Interp**, int, char*[], char*[]);
extern void  InitializeModuleCommands(Tcl_Interp*);
extern int   Setup_Environment(Tcl_Interp*);
extern void  SetStartupFiles(void);
extern int   TieStdout(void);
extern int   UnTieStdout(int);

/* utility.c */
extern int             store_old_shell_variable(Tcl_HashTable*, const char*,
                                                const char*);
extern int             clear_old_shell_variable(Tcl_HashTable*, const char*);
extern int             store_shell_alias(Tcl_HashTable*, const char*,
                                         const char*);
extern void            Clear_Global_Hash_Tables(void);
extern void            Delete_Global_Hash_Tables(void);
extern void            Delete_Hash_Tables(Tcl_HashTable**);
extern Tcl_HashTable** Copy_Hash_Tables(void);
extern int             Unwind_Modulefile_Changes(Tcl_Interp*, const char*, Tcl_HashTable**);
extern int             Output_Modulefile_Changes(Tcl_Interp*);
extern int             Output_Modulefile_Aliases(Tcl_Interp*);
extern int             output_set_variable(const char*, const char*);
extern int             output_unset_variable(const char*);
extern int             output_set_alias(const char*, const char*);
extern int             output_unset_alias(const char*, const char*);
extern char*           set_derelict(const char*);
extern int             store_env(void);
extern int             free_stored_env(void);
extern void            set_marked_entry(Tcl_HashTable*, char*, int);
extern int             chk_marked_entry(Tcl_HashTable*, char*);
extern Tcl_HashTable*  environ_changes;
extern Tcl_HashTable*  alias_changes;
extern int             IsLoaded(Tcl_Interp*, char*, char**, char*);
extern int             Update_LoadedList(Tcl_Interp*, char*, char*);
extern char*           get_module_basename(char*);
extern int             ForcePath(Tcl_Interp*, char*);
extern int             check_magic(char*, char*, int);
extern void            chk4spch(char* finame);

/* Tcl Library */
extern void             setenv(char *name, char *value);
extern void             unsetenv(char *name);
extern int              FindVariable(char *name, int *lengthPtr);


/* flags values */
#define      M_REMOVE   0x0001
#define      M_DISPLAY  0x0002
#define      M_SWSTATE1 0x0004
#define      M_SWSTATE2 0x0008
#define      M_SWSTATE3 0x0010
#define      M_SWITCH   (M_SWSTATE1 | M_SWSTATE2 | M_SWSTATE3)
#define      M_LOAD     0x0020
#define      M_CLEAR    0x0040
#define      M_PREPEND  0x0080

/* markers for switching */
#define      SWMARKER        "--VARMARKER--"  /* for variables and aliases */
#define      APP_SW_MARKER   "--APPMARKER--"  /* for appending paths */
#define      PRE_SW_MARKER   "--PREMARKER--"  /* for prepending paths */

#define      MODULES_MAGIC_COOKIE         "#%Module"
#define      MODULES_MAGIC_COOKIE_LENGTH  8

/* return values */
#define TCL_LEVEL0_RETURN    11

/* uname defaults when uname can't be found */
#ifndef HAS_UNAME

#ifndef UNAME_SYSNAME
#define UNAME_SYSNAME   "unknown"
#endif

#ifndef UNAME_NODENAME
#define UNAME_NODENAME  "unknown"
#endif

#ifndef UNAME_RELEASE
#define UNAME_RELEASE   "unknown"
#endif

#ifndef UNAME_VERSION
#define UNAME_VERSION   "unknown"
#endif

#ifndef UNAME_MACHINE
#define UNAME_MACHINE   "unknown"
#endif

#endif

#define  LINELENGTH   8192

/* global vars */
extern int    errno;
extern char** environ;

extern char*  current_module;
extern char** shell_startups;
extern char   shell_name[];
extern char   shell_derelict[];
extern int    flags;
extern char*  line;

#include <regexp.h>

extern regexp* addPtr;
extern regexp* rmPtr;
extern regexp* swPtr;
extern regexp* dispPtr;
extern regexp* listPtr;
extern regexp* availPtr;
extern regexp* helpPtr;
extern regexp* initPtr;
extern regexp* usePtr;
extern regexp* unusePtr;
extern regexp* updatePtr;
extern regexp* purgePtr;
extern regexp* clearPtr;

extern Tcl_HashTable*  setenvHashTable;
extern Tcl_HashTable*  unsetenvHashTable;
extern Tcl_HashTable*  aliasSetHashTable;
extern Tcl_HashTable*  aliasUnsetHashTable;
extern Tcl_HashTable*  markVariableHashTable;
extern Tcl_HashTable*  markAliasHashTable;

/*
 *  I'm going to remove all of the calls to free() since they arn't
 *    very necessary for Modules.  Since the modulecmd program is only run for
 *    a very short time (usually <1sec) it's faster to not clutter the heap
 *    by freeing up memory.
 *
 *  If you disagree with this decision, or have some problems with this
 *    behavior on your system, comment out the #define.
 */
#define  free(x)  
#define  FreeList(x,y)  
