/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Switches two modulefiles such that the paths are switched in-place.
 *	
 * $Log: ModuleCmd_Switch.c,v $
 *
 *
 * Revision 1.2  1993/01/20  03:33:05  jlf
 * Updated to use new Locate_Modulefile function.
 *
 * Revision 1.1  1992/11/05  23:52:12  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Switch.c,v 2.0 1993/02/21 00:00:16 jlf Exp jlf $";

#include "global.h"

int
ModuleCmd_Switch(Tcl_Interp* interp,
                 int         argc,
                 char*       argv[])
{
    char* oldmodule = argv[0];
    char* newmodule = argv[1];
    char  oldfile[1024];
    char  newfile[1024];
    char  oldname[1024];
    char  newname[1024];
    int   ret_val;
    char* realname;
    
    if(argc != 2) {
	Tcl_AppendResult(interp,
			 "Wrong number of arguments:  usage is ", 
			 "'switch oldmodule newmodule'", NULL);
	return TCL_ERROR;
    }

    /*
       First try to find a match for the modulefile out of the LOADEDMODULES.
       */
    if(! IsLoaded(interp, oldmodule, &realname, oldfile)) {
	Tcl_AppendResult(interp,
			 "Module '", oldmodule, 
			 "' is not currently loaded", NULL);
	return TCL_ERROR;
    }
    
    /*
       If we have another name to try, try finding it on disk.
       */
    if(realname != NULL) {
        ret_val = Locate_ModuleFile(interp, realname, oldname, oldfile);
    }

    /*
       If we've made it this far without finding a file, then look using the
       exact name the user gave me -- i.e. the old method. 
       */
    if(ret_val == TCL_ERROR) {
        ret_val = Locate_ModuleFile(interp, oldmodule, oldname, oldfile);

        if(! IsLoaded(interp, oldname, NULL, oldfile)) {
            Tcl_AppendResult(interp,
                             "Module '", oldmodule, 
                             "' is not currently loaded", NULL);
            return TCL_ERROR;
        }
    }

    /*
       Now try to find the new file to swap with.
       */
    ret_val = Locate_ModuleFile(interp, newmodule, newname, newfile);
    
    if(ret_val == TCL_ERROR) {
	Tcl_AppendResult(interp,
			 "Couldn't find module '", newmodule, 
			 "' in MODULEPATH", NULL);
	return TCL_ERROR;
    }
    
    fprintf(stderr, "Switching '%s' to '%s'...", oldname, newname);
    
    flags |= (M_REMOVE | M_SWSTATE1);
    
    current_module = oldname;
    if(Read_Modulefile(interp, oldfile) == 0)
	Update_LoadedList(interp, oldname, oldfile);
    else {
        fprintf(stderr, "failed.\n");
	return TCL_ERROR;
    }
    
    flags &= ~(M_REMOVE | M_SWSTATE1);
    flags |= M_SWSTATE2;

    current_module = newname;
    if(Read_Modulefile(interp, newfile) == 0)
	Update_LoadedList(interp, newname, newfile);
    else {
        fprintf(stderr, "failed.\n");
	return TCL_ERROR;
    }

    flags &= ~M_SWSTATE2;
    flags |= (M_REMOVE | M_SWSTATE3);

    if(Read_Modulefile(interp, oldfile) == 0)
	Update_LoadedList(interp, newname, newfile);
    else {
        fprintf(stderr, "failed.\n");
	return TCL_ERROR;
    }
    
    fprintf(stderr, "ok.\n");
    
    return TCL_OK;
}

