/* 
 * init.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.20 $
 * $Date: 1992/02/07 04:40:24 $
 */

#include <ctype.h>
#include "x_stdio.h"
#include "process.h"
#include "upi.h"
#include "xk_debug.h"
#include "event_i.h"
#include "site.h"
#include "event.h"
#include "machine.h"
#include "compose.h"
#include "platform.h"
#include "prottbl.h"
#include "x_libc.h"
#include "x_util.h"

int globalArgc;
char **globalArgv;
char errBuf[200];
char *rom[ROM_MAX_LINES + 1][ROM_MAX_FIELDS + 1];  

int	traceinit;


static void	initRom( void );

static	char *protocolTablesDefault[2] = {
    PROTOCOL_TABLE,
    0
};


static void
pgraphStub( void *arg )
{
    build_pgraph();
}


int
main(argc,argv)
int	argc;
char	*argv[];
{
    char **protTbl;
    
    extern void clock_ih(), InitProtocols();
    
    setbuf(stdout, 0);
    globalArgc = argc;
    globalArgv = argv;
    
    LWP_Init();			/* cjt */
    
    initTraceLevels();
    
    msgInit();
    evInit();
    init_clock(clock_ih, (long)(EVENT_INTERVAL/1000));
    initRom();
    if ( *protocolTables == 0 ) {
	/* 
	 * No tables defined in graph.comp
	 */
	protTbl = protocolTablesDefault;
    } else {
	protTbl = protocolTables;
    }
    while ( *protTbl != 0 ) {
	if ( protTblBuild(*protTbl) ) {
	    Kabort("Error building protocol table");
	}
	protTbl++;
    }
    
    evDetach( evSchedule( pgraphStub, 0, 0 ) );
    
    return 0;
}


/* 
 * Save all but the last character (the newline)
 */
static char *
savestr( char *s )
{
    char 	*r;
    unsigned	len;

    len = strlen(s);
    r = (char *) xMalloc(len);
    strncpy(r, s, len - 1);
    return r;
}


#define ROM_LEN	200

static void
initRom()
{
    char buf[ROM_LEN + 2];
    char *p;
    FILE *f;
    int	i, j;
    
    if ((f = fopen("rom", "r")) == NULL) {
	xTrace0(init, TR_MAJOR_EVENTS, "not loading ROM file");
	return;
    } else {
	xTrace0(init, TR_MAJOR_EVENTS, "loading ROM file");
    }
    
    for ( i=0; fgets(buf, ROM_LEN + 2, f); i++ ) {
	if ( i > ROM_MAX_LINES  ) {
	    Kabort(sprintf(errBuf,
			   "ROM file has too many lines (max %d)",
			   ROM_MAX_LINES));
	}
	if ( strlen(buf) > ROM_LEN ) {
	    Kabort(sprintf(errBuf, 
			   "ROM entry in line %d is too long (max %d chars)",
			   i, ROM_LEN));
	}
	p = savestr(buf);
	/* 
	 * Put a '\0' after each field and set the rom array to these
	 * fields 
	 */
	for ( j=0; *p; j++ ) {
	    if ( j > ROM_MAX_FIELDS ) {
		Kabort(sprintf(errBuf,
			"ROM entry on line %d has too many fields (max %d)",
			       i, ROM_MAX_FIELDS));
	    }
	    rom[i][j] = p;
	    /* 
	     * Find and mark the end of this field
	     */
	    while ( *p && ! isspace(*p) ) {
		p++;
	    }
	    if ( *p ) {
		*p++ = 0;
		/* 
		 * Find the start of the next field
		 */
		while ( *p && isspace(*p) ) {
		    p++;
		}
	    }
	}
    }
    fclose(f);
}
