/*     
 * ip_gc.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.15 $
 * $Date: 1992/02/07 04:34:12 $
 */

/*
 * When fragments of IP messages are lost, the resources dedicated to
 * the reassembly of those messages remain allocated.  This code scans
 * throught the fragment map looking for such fragments and deallocates
 * their resources.
 */

#include "xkernel.h"
#include "ip_i.h"

/*
 * Trace levels
 */
#define GC1 1
#define GC2 1

#ifdef __STDC__

static void	ipFragCollect( void * );

#else

static void	ipFragCollect();

#endif __STDC__

void
scheduleIpFragCollector(pstate)
    PSTATE *pstate;
{
    evDetach( evSchedule( ipFragCollect, pstate, IP_GC_INTERVAL ) );
}


char *
fragIdStr(key, buf)
    FragId *key;
    char *buf;
{
    sprintf(buf, "s: %s  d: %s  p: %d  seq: %d",
	    ipHostStr(&key->source), ipHostStr(&key->dest),
	    key->prot, key->seqid);
    return buf;
}


static int
markFrag(key, value, arg)
    VOID *key;
    int value;
    VOID *arg;
{
    Fragtable	*tbl = (Fragtable *)value;
    PSTATE	*pstate = (PSTATE *)arg;
#ifndef NDEBUG
    char	buf[80];
#endif

    if ( tbl->gcMark ) {
	xTrace1(ipp, GC2, "IP GC removing %s", fragIdStr(key, buf));
	mapRemoveBinding(pstate->fragMap, tbl->binding);
	free_fragtable(tbl);
    } else {
	xTrace1(ipp, GC2, "IP GC marking  %s", fragIdStr(key, buf));
	tbl->gcMark = TRUE;
    }
    return 1;
}


static void
ipFragCollect(arg)
    VOID *arg;
{
    PSTATE	*pstate = (PSTATE *)arg;

    xTrace0(ipp, GC1, "IP fragment garbage collector");
    mapForEach(pstate->fragMap, markFrag, pstate);
    scheduleIpFragCollector(pstate);
    xTrace0(ipp, GC2, "IP GC exits");
}
