/* 
 * idmap_templ.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.10 $
 * $Date: 1992/01/16 19:18:57 $
 */

/*
 * We need the definitions of:
 *	KEYSIZE
 *	HASH
 *	COMPBYTES
 *	COPYBYTES
 */

static Bind
BINDNAME ( table, ext, intern )
    Map table;
    register char *ext;
    int intern;
{
    Bind     elem_posn, new_elem, prev_elem, *table_posn;
    register char *o_ext;
    
    table_posn = &table->table[HASH(ext, table->tableSize)];
    elem_posn = *table_posn;
    prev_elem = elem_posn;
    while (elem_posn != 0) {
	o_ext = elem_posn->externalid;
	if (COMPBYTES(o_ext, ext)) {
	    if (elem_posn->internalid == intern) {
		return(elem_posn);
	    } else {
		return(ERR_BIND);
	    }
	} else {
	    prev_elem = elem_posn;
	    elem_posn = elem_posn->next;
	}
    }
    
    /* Note: Memory allocated here that is not immediately freed  cjt */
    /*
     * Elements must be inserted at the end of the list rather than at the
     * beginning for the semantics mapForEach to work properly.
     */
    GETMAPELEM(table, new_elem);
    COPYBYTES(new_elem->externalid, ext);
    new_elem->internalid = intern;
    new_elem->next = 0;
    table->cache = new_elem;
    if ( prev_elem == 0 ) {
	*table_posn = new_elem;
    } else {
	prev_elem->next = new_elem;
    }
    return new_elem;
}

static int
RESOLVENAME ( table, ext )
    Map table;
    register char *ext;
{
    register Bind elem_posn;
    register char *o_ext;
    
    if (elem_posn = table->cache) {
	o_ext = elem_posn->externalid;
	if (COMPBYTES(o_ext, ext)) {
	    return(elem_posn->internalid);
	}
    }
    elem_posn = table->table[HASH(ext, table->tableSize)];
    while (elem_posn != 0) {
	o_ext = elem_posn->externalid;
	if (COMPBYTES(o_ext, ext)) {
	    table->cache = elem_posn;
	    return elem_posn->internalid;
	} else {
	    elem_posn = elem_posn->next;
	}
    }
    return(-1);
}


/* 
 * UNBIND -- remove an entry based on the key->value pair
 */
static int
UNBINDNAME ( table, ext )
    Map table;
    register char *ext;
{
    Bind     elem_posn, *prev_elem;
    register char *o_ext;
    
    prev_elem = &table->table[HASH(ext, table->tableSize)];
    elem_posn = *prev_elem;
    table->cache = 0;
    while (elem_posn != 0) {
	o_ext = elem_posn->externalid;
	if (COMPBYTES(o_ext, ext)) {
	    *prev_elem = elem_posn->next;
	    FREEIT(table, elem_posn);
	    return 0;
	} 
	prev_elem = &(elem_posn->next);
	elem_posn = elem_posn->next;
    }
    return -1;
}


/* 
 * REMOVE -- remove an entry based on the binding
 */
static int
REMOVENAME ( table, bind )
    Map table;
    Bind bind;
{
    Bind     elem_posn, *prev_elem;
    
    prev_elem = &table->table[HASH(bind->externalid, table->tableSize)];
    elem_posn = *prev_elem;
    table->cache = 0;
    while (elem_posn != 0) {
	if ( elem_posn == bind ) {
	    *prev_elem = elem_posn->next;
	    FREEIT(table, elem_posn);
	    return 0;
	} 
	prev_elem = &(elem_posn->next);
	elem_posn = elem_posn->next;
    }
    return -1;
}



#undef BINDNAME
#undef REMOVENAME
#undef RESOLVENAME
#undef UNBINDNAME
#undef FIRSTNAME
#undef KEYSIZE
#undef HASH
#undef COMPBYTES
#undef COPYBYTES
